/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.block.blocks.GoldDoorBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.KeyLockableTile;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class NetheriteDoorBlock
extends DoorBlock
implements EntityBlock {
    public NetheriteDoorBlock(BlockBehaviour.Properties builder) {
        super(BlockSetType.IRON, builder);
    }

    public SoundType getSoundType(BlockState state) {
        return SoundType.NETHERITE_BLOCK;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof KeyLockableTile) {
            KeyLockableTile tile = (KeyLockableTile)blockEntity;
            if (PlatHelper.getPlatform().isFabric() && CommonConfigs.Building.NETHERITE_DOOR_UNBREAKABLE.get().booleanValue() && !tile.getKeyInInventoryStatus(player).isCorrect()) {
                return state;
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockPos p = this.hasTileEntity(state) ? pos : pos.below();
        BlockEntity blockEntity = level.getBlockEntity(p);
        if (blockEntity instanceof KeyLockableTile) {
            KeyLockableTile keyLockableTile = (KeyLockableTile)blockEntity;
            if (keyLockableTile.handleAction(player, hand, stack, "door")) {
                GoldDoorBlock.tryOpenDoubleDoorKey(level, state, pos, player, hand, stack);
                state = (BlockState)state.cycle((Property)OPEN);
                level.setBlock(pos, state, 10);
                boolean open = (Boolean)state.getValue((Property)OPEN);
                this.playSound((Entity)player, level, pos, (Boolean)state.getValue((Property)OPEN));
                level.gameEvent((Entity)player, (Holder)(open ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        return (BlockState)((BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public boolean hasTileEntity(BlockState state) {
        return state.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        if (this.hasTileEntity(pState)) {
            return new KeyLockableTile(pPos, pState);
        }
        return null;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (!MiscUtils.showsHints(tooltipFlag)) {
            return;
        }
        tooltipComponents.add((Component)KeyLockableTile.KEY_LOCKABLE_TOOLTIP);
    }
}

