/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Arrays;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FodderBlock
extends WaterBlock {
    private static final int MAX_LAYERS = 8;
    public static final IntegerProperty LAYERS = BlockStateProperties.LAYERS;
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[8];

    public FodderBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LAYERS, (Comparable)Integer.valueOf(8))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.getValue((Property)LAYERS) * 2 - 1;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathType) {
        if (pathType == PathComputationType.LAND) {
            return (Integer)state.getValue((Property)LAYERS) <= 4;
        }
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return SHAPE_BY_LAYER[(Integer)state.getValue((Property)LAYERS) - 1];
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos otherPos) {
        if (facingState.is((Block)this)) {
            int layers;
            int missing;
            if (direction == Direction.UP) {
                int layers2 = (Integer)state.getValue((Property)LAYERS);
                int missing2 = 8 - layers2;
                if (missing2 > 0) {
                    int otherLayers = (Integer)facingState.getValue((Property)LAYERS);
                    int newOtherLayers = otherLayers - missing2;
                    BlockState newOtherState = newOtherLayers <= 0 ? Blocks.AIR.defaultBlockState() : (BlockState)facingState.setValue((Property)LAYERS, (Comparable)Integer.valueOf(newOtherLayers));
                    BlockState newState = (BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf(layers2 + otherLayers - Math.max(0, newOtherLayers)));
                    world.setBlock(currentPos, newState, 0);
                    world.setBlock(otherPos, newOtherState, 0);
                    return newState;
                }
            } else if (direction == Direction.DOWN && (missing = 8 - (layers = ((Integer)facingState.getValue((Property)LAYERS)).intValue())) > 0) {
                int myLayers = (Integer)state.getValue((Property)LAYERS);
                int myNewLayers = myLayers - missing;
                BlockState myNewState = myNewLayers <= 0 ? Blocks.AIR.defaultBlockState() : (BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf(myNewLayers));
                world.setBlock(otherPos, (BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf(layers + myLayers - Math.max(0, myNewLayers))), 0);
                return myNewState;
            }
        }
        return super.updateShape(state, direction, facingState, world, currentPos, otherPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos());
        if (blockstate.is((Block)this)) {
            int i = (Integer)blockstate.getValue((Property)LAYERS);
            return (BlockState)blockstate.setValue((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        return super.getStateForPlacement(context);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LAYERS});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() instanceof HoeItem && Utils.mayPerformBlockAction((Player)player, (BlockPos)pos, (ItemStack)stack)) {
            level.playSound(player, pos, SoundEvents.HOE_TILL, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!level.isClientSide) {
                int layers = (Integer)state.getValue((Property)LAYERS);
                if (layers > 1) {
                    level.levelEvent(2001, pos, Block.getId((BlockState)state));
                    level.setBlock(pos, (BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf(layers - 1)), 11);
                } else {
                    level.destroyBlock(pos, false);
                }
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    static {
        Arrays.setAll(SHAPE_BY_LAYER, l -> Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)((double)l * 2.0 + 2.0), (double)16.0));
    }
}

