/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.block.IPistonMotionReact;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class FlintBlock
extends Block
implements IPistonMotionReact {
    private static final Long2ObjectMap<Direction> BY_NORMAL = (Long2ObjectMap)Arrays.stream(Direction.values()).collect(Collectors.toMap(direction -> new BlockPos(direction.getNormal()).asLong(), direction -> direction, (direction, direction2) -> {
        throw new IllegalArgumentException("Duplicate keys");
    }, Long2ObjectOpenHashMap::new));

    public FlintBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onMoved(Level level, BlockPos pos, BlockState movedState, Direction direction, boolean extending) {
        BlockPos firePos;
        if (!extending && !level.isClientSide && level.getBlockState(firePos = pos.relative(direction)).isAir()) {
            for (Direction ironDir : Direction.values()) {
                BlockPos ironPos;
                BlockState facingState;
                if (ironDir.getAxis() == direction.getAxis() || !FlintBlock.canBlockCreateSpark(facingState = level.getBlockState(ironPos = firePos.relative(ironDir)), level, ironPos, ironDir.getOpposite())) continue;
                this.ignitePosition(level, firePos, false);
                return;
            }
        }
    }

    private void ignitePosition(Level level, BlockPos firePos, boolean isIronMoving) {
        NetworkHelper.sendToAllClientPlayersInParticleRange((ServerLevel)((ServerLevel)level), (BlockPos)firePos, (CustomPacketPayload)new ClientBoundParticlePacket(Vec3.atCenterOf((Vec3i)firePos), ClientBoundParticlePacket.Kind.FLINT_BLOCK_IGNITE, isIronMoving ? 1 : 0));
        for (Direction dir : Direction.values()) {
            if (!BaseFireBlock.canBePlacedAt((Level)level, (BlockPos)firePos, (Direction)dir)) continue;
            level.setBlockAndUpdate(firePos, BaseFireBlock.getState((BlockGetter)level, (BlockPos)firePos));
            level.gameEvent(null, (Holder)GameEvent.BLOCK_PLACE, firePos);
            break;
        }
        this.playSound(level, firePos);
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        LivingEntity le;
        if (!level.isClientSide && entity instanceof LivingEntity && !(le = (LivingEntity)entity).isSteppingCarefully() && le.isSprinting() && le.tickCount % 2 == 0 && le.getItemBySlot(EquipmentSlot.FEET).is(ModTags.IGNITE_FLINT_BLOCKS) && level.getBlockState(pos.above()).isAir()) {
            this.ignitePosition(level, pos.above(), true);
        }
        super.stepOn(level, pos, state, entity);
    }

    public static boolean canBlockCreateSpark(BlockState state, Level level, BlockPos pos, Direction face) {
        return state.is(ModTags.FLINT_METALS) && state.isFaceSturdy((BlockGetter)level, pos, face);
    }

    private void playSound(Level level, BlockPos pos) {
        RandomSource randomSource = level.getRandom();
        level.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, (randomSource.nextFloat() - randomSource.nextFloat()) * 0.2f + 1.0f);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block oldBlock, BlockPos targetPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, oldBlock, targetPos, isMoving);
        BlockState newState = level.getBlockState(targetPos);
        if (!newState.isAir() || !oldBlock.builtInRegistryHolder().is(ModTags.FLINT_METALS)) {
            return;
        }
        Direction dir = (Direction)BY_NORMAL.get(pos.subtract((Vec3i)targetPos).asLong());
        for (Direction pistonDir : Direction.values()) {
            BlockState magnetState;
            if (dir.getAxis() == pistonDir.getAxis()) continue;
            BlockPos tilePos = targetPos.relative(pistonDir);
            BlockEntity be = level.getBlockEntity(tilePos);
            if (be instanceof PistonMovingBlockEntity) {
                PistonMovingBlockEntity piston = (PistonMovingBlockEntity)be;
                if (piston.getDirection() != pistonDir.getOpposite() || !piston.getMovedState().is(oldBlock) || !FlintBlock.canBlockCreateSpark(piston.getMovedState(), level, tilePos, dir)) continue;
                this.ignitePosition(level, targetPos, true);
                continue;
            }
            if (be == null || !CompatHandler.QUARK || (magnetState = QuarkCompat.getMagnetStateForFlintBlock(be, pistonDir)) == null || !magnetState.is(oldBlock) || !FlintBlock.canBlockCreateSpark(magnetState, level, tilePos, dir)) continue;
            this.ignitePosition(level, targetPos, true);
        }
    }
}

