/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block;

import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public interface IRopeConnection {
    default public boolean shouldConnectToFace(BlockState thisState, BlockState facingState, BlockPos facingPos, Direction dir, LevelReader world) {
        if (!this.canSideAcceptConnection(thisState, dir)) {
            return false;
        }
        switch (dir) {
            case UP: {
                return IRopeConnection.isSupportingCeiling(facingState, facingPos, world);
            }
            case DOWN: {
                return IRopeConnection.isSupportingCeiling(facingPos.above(2), world) || IRopeConnection.canConnectDown(facingState);
            }
        }
        if (CommonConfigs.Functional.ROPE_UNRESTRICTED.get().booleanValue() && facingState.isFaceSturdy((BlockGetter)world, facingPos, dir.getOpposite())) {
            return true;
        }
        Block block = facingState.getBlock();
        if (block instanceof IRopeConnection) {
            IRopeConnection otherRope = (IRopeConnection)block;
            return otherRope.canSideAcceptConnection(facingState, dir.getOpposite());
        }
        return false;
    }

    public boolean canSideAcceptConnection(BlockState var1, Direction var2);

    public static boolean isSupportingCeiling(BlockPos pos, LevelReader world) {
        return IRopeConnection.isSupportingCeiling(world.getBlockState(pos), pos, world);
    }

    public static boolean canConnectDown(BlockState downState) {
        Block b = downState.getBlock();
        if (b instanceof IRopeConnection) {
            IRopeConnection ropeConnection = (IRopeConnection)b;
            return ropeConnection.canSideAcceptConnection(downState, Direction.UP);
        }
        return downState.is(ModTags.ROPE_HANG_TAG) || downState.hasProperty((Property)FaceAttachedHorizontalDirectionalBlock.FACE) && downState.getValue((Property)FaceAttachedHorizontalDirectionalBlock.FACE) == AttachFace.CEILING || b instanceof ChainBlock && downState.getValue((Property)BlockStateProperties.AXIS) == Direction.Axis.Y || downState.hasProperty((Property)BlockStateProperties.HANGING) && (Boolean)downState.getValue((Property)BlockStateProperties.HANGING) != false;
    }

    public static boolean isSupportingCeiling(BlockState upState, BlockPos pos, LevelReader world) {
        Block block = upState.getBlock();
        if (block instanceof IRopeConnection) {
            IRopeConnection ropeConnection = (IRopeConnection)block;
            return ropeConnection.canSideAcceptConnection(upState, Direction.DOWN);
        }
        return Block.canSupportCenter((LevelReader)world, (BlockPos)pos, (Direction)Direction.DOWN) && upState.isSolid() || upState.is(ModTags.ROPE_SUPPORT_TAG);
    }
}

