/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import net.mehvahdjukaar.supplementaries.client.BlackboardTextureManager;
import net.mehvahdjukaar.supplementaries.common.items.components.BlackboardData;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;

public class BlackboardTooltipComponent
implements ClientTooltipComponent {
    private final int size = ClientConfigs.Tweaks.TOOLTIP_IMAGE_SIZE.get();
    private final ResourceLocation texture;

    public BlackboardTooltipComponent(BlackboardData key) {
        this.texture = BlackboardTextureManager.getInstance(key).getTextureLocation();
    }

    public int getHeight() {
        return this.size + 2;
    }

    public int getWidth(Font pFont) {
        return this.size;
    }

    public void renderImage(Font pFont, int x, int y, GuiGraphics graphics) {
        graphics.pose().pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(this.texture, x, y, 0, 0.0f, 0.0f, this.size, this.size, this.size, this.size);
        graphics.pose().popPose();
    }
}

