/*
 * Decompiled with CFR 0.152.
 */
package com.enhancedplayerlist.server;

import com.enhancedplayerlist.Config;
import com.enhancedplayerlist.server.ServerStatsManager;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.util.thread.EffectiveSide;

public class ServerScheduler {
    private static int tickCounter = 0;
    private static long lastStatsSave = 0L;
    private static final long STATS_SAVE_COOLDOWN = 1000L;

    public static void onServerTick(MinecraftServer server) {
        if (EffectiveSide.get() != LogicalSide.SERVER) {
            return;
        }
        if (++tickCounter >= Config.updateFrequency) {
            long currentTime;
            tickCounter = 0;
            List players = server.getPlayerList().getPlayers();
            if (!players.isEmpty() && (currentTime = System.currentTimeMillis()) - lastStatsSave >= 1000L) {
                server.execute(() -> {
                    for (ServerPlayer player : players) {
                        player.getStats().save();
                    }
                    lastStatsSave = currentTime;
                    ServerStatsManager.forceSync();
                });
            }
        }
    }
}

