/*
 * Decompiled with CFR 0.152.
 */
package com.enhancedplayerlist.network;

import com.enhancedplayerlist.client.ClientStatsManager;
import com.enhancedplayerlist.network.PlayerStatsPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NetworkHandler {
    public static final ResourceLocation PLAYER_STATS_ID = ResourceLocation.fromNamespaceAndPath((String)"enhancedplayerlist", (String)"player_stats");

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("enhancedplayerlist").versioned("1.0");
        registrar.playToClient(PlayerStatsPacket.TYPE, PlayerStatsPacket.STREAM_CODEC, (packet, context) -> context.enqueueWork(() -> ClientStatsManager.updatePlayerStats(packet.playerStats())));
    }

    public static void sendToServer(PlayerStatsPacket packet) {
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToAllPlayers(PlayerStatsPacket packet) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

