/*
 * Decompiled with CFR 0.152.
 */
package com.enhancedplayerlist.data;

import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class PlayerStatsData {
    private String playerName = "";
    private String uuid = "";
    private boolean isOnline;
    private long lastSeen;
    private long playTime;
    private int deaths;
    private long timeSinceDeath;
    private int mobKills;
    private long blocksWalked;
    private long blocksMined;
    private int jumps;
    private float damageDealt;
    private float damageTaken;
    private static final StreamCodec<ByteBuf, PlayerStatsData> BASIC_DATA_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, PlayerStatsData::getPlayerName, (StreamCodec)ByteBufCodecs.STRING_UTF8, PlayerStatsData::getUuid, (StreamCodec)ByteBufCodecs.BOOL, PlayerStatsData::isOnline, (name, uuid, online) -> PlayerStatsData.builder().playerName((String)name).uuid((String)uuid).online((boolean)online).build());
    private static final StreamCodec<ByteBuf, PlayerStatsData> STATS_DATA_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, PlayerStatsData::getPlayTime, (StreamCodec)ByteBufCodecs.VAR_INT, PlayerStatsData::getDeaths, (StreamCodec)ByteBufCodecs.VAR_LONG, PlayerStatsData::getTimeSinceDeath, (playTime, deaths, timeSinceDeath) -> PlayerStatsData.builder().playTime((long)playTime).deaths((int)deaths).timeSinceDeath((long)timeSinceDeath).build());
    private static final StreamCodec<ByteBuf, PlayerStatsData> EXTENDED_STATS_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, PlayerStatsData::getJumps, (StreamCodec)ByteBufCodecs.VAR_LONG, PlayerStatsData::getBlocksWalked, (StreamCodec)ByteBufCodecs.FLOAT, PlayerStatsData::getDamageDealt, (jumps, blocksWalked, damageDealt) -> PlayerStatsData.builder().jumps((int)jumps).blocksWalked((long)blocksWalked).damageDealt(damageDealt.floatValue()).build());
    public static final StreamCodec<ByteBuf, PlayerStatsData> STREAM_CODEC = new StreamCodec<ByteBuf, PlayerStatsData>(){

        public void encode(@Nonnull ByteBuf buf, @Nonnull PlayerStatsData value) {
            BASIC_DATA_CODEC.encode((Object)buf, (Object)value);
            STATS_DATA_CODEC.encode((Object)buf, (Object)value);
            EXTENDED_STATS_CODEC.encode((Object)buf, (Object)value);
            ByteBufCodecs.VAR_LONG.encode((Object)buf, (Object)value.getLastSeen());
            ByteBufCodecs.VAR_LONG.encode((Object)buf, (Object)value.getBlocksMined());
            ByteBufCodecs.FLOAT.encode((Object)buf, (Object)Float.valueOf(value.getDamageTaken()));
        }

        @Nonnull
        public PlayerStatsData decode(@Nonnull ByteBuf buf) {
            Builder builder = PlayerStatsData.builder();
            PlayerStatsData basic = (PlayerStatsData)BASIC_DATA_CODEC.decode((Object)buf);
            builder.playerName(basic.getPlayerName()).uuid(basic.getUuid()).online(basic.isOnline());
            PlayerStatsData stats = (PlayerStatsData)STATS_DATA_CODEC.decode((Object)buf);
            builder.playTime(stats.getPlayTime()).deaths(stats.getDeaths()).timeSinceDeath(stats.getTimeSinceDeath());
            PlayerStatsData extended = (PlayerStatsData)EXTENDED_STATS_CODEC.decode((Object)buf);
            builder.jumps(extended.getJumps()).blocksWalked(extended.getBlocksWalked()).damageDealt(extended.getDamageDealt());
            return builder.lastSeen((Long)ByteBufCodecs.VAR_LONG.decode((Object)buf)).blocksMined((Long)ByteBufCodecs.VAR_LONG.decode((Object)buf)).damageTaken(((Float)ByteBufCodecs.FLOAT.decode((Object)buf)).floatValue()).build();
        }
    };

    private PlayerStatsData() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public void loadFromJson(JsonObject json) {
        try {
            JsonObject stats = json.getAsJsonObject("stats");
            if (stats == null) {
                return;
            }
            JsonObject customStats = stats.getAsJsonObject("minecraft:custom");
            if (customStats == null) {
                return;
            }
            this.playTime = PlayerStatsData.getStatLong(customStats, "minecraft:play_time", 0L);
            this.deaths = PlayerStatsData.getStatInt(customStats, "minecraft:deaths", 0);
            this.timeSinceDeath = PlayerStatsData.getStatLong(customStats, "minecraft:time_since_death", 0L);
            this.mobKills = PlayerStatsData.getStatInt(customStats, "minecraft:mob_kills", 0);
            this.blocksWalked = PlayerStatsData.getStatLong(customStats, "minecraft:walk_one_cm", 0L) + PlayerStatsData.getStatLong(customStats, "minecraft:sprint_one_cm", 0L) + PlayerStatsData.getStatLong(customStats, "minecraft:walk_on_water_one_cm", 0L) + PlayerStatsData.getStatLong(customStats, "minecraft:walk_under_water_one_cm", 0L);
            this.jumps = PlayerStatsData.getStatInt(customStats, "minecraft:jump", 0);
            this.damageDealt = PlayerStatsData.getStatFloat(customStats, "minecraft:damage_dealt", 0.0f);
            this.damageTaken = PlayerStatsData.getStatFloat(customStats, "minecraft:damage_taken", 0.0f);
            JsonObject minedStats = stats.getAsJsonObject("minecraft:mined");
            if (minedStats != null) {
                this.blocksMined = minedStats.entrySet().stream().mapToLong(entry -> PlayerStatsData.getStatLong(minedStats, (String)entry.getKey(), 0L)).sum();
            }
        }
        catch (Exception e) {
            System.err.println("Error loading player stats: " + e.getMessage());
        }
    }

    private static long getStatLong(JsonObject json, String key, long defaultValue) {
        try {
            return json.has(key) ? json.get(key).getAsLong() : defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static int getStatInt(JsonObject json, String key, int defaultValue) {
        try {
            return json.has(key) ? json.get(key).getAsInt() : defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static float getStatFloat(JsonObject json, String key, float defaultValue) {
        try {
            return json.has(key) ? json.get(key).getAsFloat() : defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Nonnull
    public String getPlayerName() {
        return this.playerName;
    }

    @Nonnull
    public String getUuid() {
        return this.uuid;
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public long getPlayTime() {
        return this.playTime;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public long getTimeSinceDeath() {
        return this.timeSinceDeath;
    }

    public int getMobKills() {
        return this.mobKills;
    }

    public long getBlocksWalked() {
        return this.blocksWalked;
    }

    public long getBlocksMined() {
        return this.blocksMined;
    }

    public int getJumps() {
        return this.jumps;
    }

    public float getDamageDealt() {
        return this.damageDealt;
    }

    public float getDamageTaken() {
        return this.damageTaken;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName != null ? playerName : "";
    }

    public void setUuid(String uuid) {
        this.uuid = uuid != null ? uuid : "";
    }

    public void setOnline(boolean online) {
        this.isOnline = online;
        if (!online) {
            this.lastSeen = System.currentTimeMillis();
        }
    }

    public void setLastSeen(long lastSeen) {
        this.lastSeen = lastSeen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlayerStatsData)) {
            return false;
        }
        PlayerStatsData that = (PlayerStatsData)o;
        return this.playTime == that.playTime && this.deaths == that.deaths && this.timeSinceDeath == that.timeSinceDeath && this.mobKills == that.mobKills && this.blocksWalked == that.blocksWalked && this.blocksMined == that.blocksMined && this.jumps == that.jumps && Float.compare(that.damageDealt, this.damageDealt) == 0 && Float.compare(that.damageTaken, this.damageTaken) == 0 && Objects.equals(this.playerName, that.playerName) && Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.playerName, this.uuid, this.playTime, this.deaths, this.timeSinceDeath, this.mobKills, this.blocksWalked, this.blocksMined, this.jumps, Float.valueOf(this.damageDealt), Float.valueOf(this.damageTaken));
    }

    public static class Builder {
        private final PlayerStatsData data = new PlayerStatsData();

        public Builder playerName(String playerName) {
            this.data.playerName = playerName != null ? playerName : "";
            return this;
        }

        public Builder uuid(String uuid) {
            this.data.uuid = uuid != null ? uuid : "";
            return this;
        }

        public Builder online(boolean online) {
            this.data.isOnline = online;
            if (!online) {
                this.data.lastSeen = System.currentTimeMillis();
            }
            return this;
        }

        public Builder lastSeen(long lastSeen) {
            this.data.lastSeen = lastSeen;
            return this;
        }

        public Builder playTime(long playTime) {
            this.data.playTime = playTime;
            return this;
        }

        public Builder deaths(int deaths) {
            this.data.deaths = deaths;
            return this;
        }

        public Builder timeSinceDeath(long timeSinceDeath) {
            this.data.timeSinceDeath = timeSinceDeath;
            return this;
        }

        public Builder mobKills(int mobKills) {
            this.data.mobKills = mobKills;
            return this;
        }

        public Builder blocksWalked(long blocksWalked) {
            this.data.blocksWalked = blocksWalked;
            return this;
        }

        public Builder blocksMined(long blocksMined) {
            this.data.blocksMined = blocksMined;
            return this;
        }

        public Builder jumps(int jumps) {
            this.data.jumps = jumps;
            return this;
        }

        public Builder damageDealt(float damageDealt) {
            this.data.damageDealt = damageDealt;
            return this;
        }

        public Builder damageTaken(float damageTaken) {
            this.data.damageTaken = damageTaken;
            return this;
        }

        public PlayerStatsData build() {
            return this.data;
        }
    }
}

