/*
 * Decompiled with CFR 0.152.
 */
package com.enhancedplayerlist.client.event;

import com.enhancedplayerlist.Config;
import com.enhancedplayerlist.client.ClientStatsManager;
import com.enhancedplayerlist.client.PlayerListRenderer;
import com.enhancedplayerlist.data.PlayerStatsData;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.common.NeoForge;

public class ClientEventHandler {
    private static final Minecraft minecraft = Minecraft.getInstance();
    private static final int ROW_HEIGHT = 9;
    private static final int STAT_SPACING = 8;
    private static final int NAME_COLUMN_WIDTH = 100;
    private static final int PADDING = 5;
    private static final int BACKGROUND_COLOR = Integer.MIN_VALUE;
    private static final Object2IntMap<String> fontWidthCache = new Object2IntOpenHashMap();
    private static Map<String, Integer> lastColumnWidths = new HashMap<String, Integer>();
    private static long lastWidthCalculation = 0L;
    private static final long WIDTH_CACHE_DURATION = 500L;

    public static void init() {
        NeoForge.EVENT_BUS.register(ClientEventHandler.class);
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGuiEvent.Post event) {
        if (ClientEventHandler.minecraft.player == null || !minecraft.isWindowActive() || !ClientEventHandler.minecraft.options.keyPlayerList.isDown()) {
            return;
        }
        LocalPlayer player = ClientEventHandler.minecraft.player;
        if (player == null || player.connection == null) {
            return;
        }
        GuiGraphics graphics = event.getGuiGraphics();
        int screenWidth = minecraft.getWindow().getGuiScaledWidth();
        int screenHeight = minecraft.getWindow().getGuiScaledHeight();
        Collection onlinePlayers = player.connection.getListedOnlinePlayers();
        ArrayList<PlayerStatsData> allPlayers = new ArrayList<PlayerStatsData>();
        for (PlayerInfo info : onlinePlayers) {
            UUID playerId = info.getProfile().getId();
            PlayerStatsData data2 = ClientStatsManager.getPlayerStats().get(playerId);
            if (data2 == null) continue;
            allPlayers.add(data2);
        }
        if (Config.showOfflinePlayers) {
            ClientStatsManager.getPlayerStats().values().stream().filter(data -> !data.isOnline()).forEach(allPlayers::add);
        }
        if (allPlayers.isEmpty()) {
            return;
        }
        ArrayList<String> statColumns = new ArrayList<String>(Config.visibleStats);
        Map<String, Integer> columnWidths = ClientEventHandler.getColumnWidths(allPlayers, statColumns);
        int totalStatsWidth = ClientEventHandler.calculateTotalWidth(columnWidths);
        int totalWidth = 100 + totalStatsWidth + 15;
        int startX = (screenWidth - totalWidth) / 2;
        int backgroundY = screenHeight / 4;
        int playerCount = allPlayers.size();
        int backgroundHeight = (playerCount + 1) * 9 + 10;
        graphics.fill(startX, backgroundY, startX + totalWidth, backgroundY + backgroundHeight, Integer.MIN_VALUE);
        int headerY = backgroundY + 5;
        graphics.drawString(ClientEventHandler.minecraft.font, "Players", startX + 5, headerY, 0xFFFFFF);
        int statHeaderX = startX + 100 + 10;
        for (String stat : statColumns) {
            graphics.drawString(ClientEventHandler.minecraft.font, ClientEventHandler.formatStatHeader(stat), statHeaderX, headerY, 0xFFFFFF);
            statHeaderX += columnWidths.get(stat) + 8;
        }
        ClientEventHandler.renderPlayerRows(graphics, allPlayers, startX, headerY + 9 + 5, columnWidths, statColumns);
    }

    private static void renderPlayerRows(GuiGraphics graphics, List<PlayerStatsData> players, int startX, int startY, Map<String, Integer> columnWidths, List<String> statColumns) {
        int rowY = startY;
        for (PlayerStatsData playerData : players) {
            int nameColor = playerData.isOnline() ? 0xFFFFFF : (Config.grayOutOffline ? 0x808080 : 0xFFFFFF);
            graphics.drawString(ClientEventHandler.minecraft.font, playerData.getPlayerName(), startX + 5, rowY, nameColor);
            int statX = startX + 100 + 10;
            Map<String, Component> stats = PlayerListRenderer.getPlayerStatsMap(UUID.fromString(playerData.getUuid()));
            for (String stat : statColumns) {
                Component value = stats.get(stat);
                if (value == null) continue;
                graphics.drawString(ClientEventHandler.minecraft.font, value, statX, rowY, nameColor);
                statX += columnWidths.get(stat) + 8;
            }
            rowY += 9;
        }
    }

    private static Map<String, Integer> getColumnWidths(Collection<PlayerStatsData> players, List<String> statColumns) {
        long now = System.currentTimeMillis();
        if (!lastColumnWidths.isEmpty() && now - lastWidthCalculation < 500L) {
            return lastColumnWidths;
        }
        Map<String, Integer> columnWidths = ClientEventHandler.calculateColumnWidths(players, statColumns);
        lastColumnWidths = columnWidths;
        lastWidthCalculation = now;
        return columnWidths;
    }

    private static Map<String, Integer> calculateColumnWidths(Collection<PlayerStatsData> players, List<String> statColumns) {
        HashMap<String, Integer> columnWidths = new HashMap<String, Integer>();
        for (String stat : statColumns) {
            MutableComponent header = Component.literal((String)ClientEventHandler.formatStatHeader(stat));
            columnWidths.put(stat, ClientEventHandler.getFontWidth(header.getString()));
        }
        for (PlayerStatsData playerData : players) {
            Map<String, Component> stats = PlayerListRenderer.getPlayerStatsMap(UUID.fromString(playerData.getUuid()));
            for (String stat : statColumns) {
                Component value = stats.get(stat);
                if (value == null) continue;
                columnWidths.put(stat, Math.max((Integer)columnWidths.get(stat), ClientEventHandler.getFontWidth(value.getString())));
            }
        }
        return columnWidths;
    }

    private static int getFontWidth(String text) {
        return fontWidthCache.computeIfAbsent((Object)text, key -> ClientEventHandler.minecraft.font.width((String)key));
    }

    private static int calculateTotalWidth(Map<String, Integer> columnWidths) {
        return columnWidths.values().stream().mapToInt(Integer::intValue).sum() + columnWidths.size() * 8;
    }

    private static String formatStatHeader(String stat) {
        return Config.compactMode ? stat.substring(0, Math.min(3, stat.length())).toUpperCase() : stat.substring(0, 1).toUpperCase() + stat.substring(1);
    }
}

