/*
 * Decompiled with CFR 0.152.
 */
package com.enhancedplayerlist.client;

import com.enhancedplayerlist.Config;
import com.enhancedplayerlist.client.ClientStatsManager;
import com.enhancedplayerlist.data.PlayerStatsData;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class PlayerListRenderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Object2ObjectMap<UUID, Map<String, Component>> STATS_CACHE = new Object2ObjectOpenHashMap();
    private static final Map<Long, String> TIME_FORMAT_CACHE = new HashMap<Long, String>();
    private static long lastCacheClean = System.currentTimeMillis();
    private static final long CACHE_CLEANUP_INTERVAL = 30000L;

    public static Map<String, Component> getPlayerStatsMap(UUID playerId) {
        Map cached;
        if (playerId == null) {
            LOGGER.debug("PlayerListRenderer: playerId is null");
            return Collections.emptyMap();
        }
        long now = System.currentTimeMillis();
        if (now - lastCacheClean > 30000L) {
            STATS_CACHE.clear();
            TIME_FORMAT_CACHE.clear();
            lastCacheClean = now;
        }
        if ((cached = (Map)STATS_CACHE.get((Object)playerId)) != null) {
            return cached;
        }
        PlayerStatsData stats = ClientStatsManager.getPlayerStats().get(playerId);
        if (stats == null) {
            LOGGER.debug("PlayerListRenderer: No stats found for player {}", (Object)playerId);
            return Collections.emptyMap();
        }
        HashMap<String, Component> statMap = new HashMap<String, Component>();
        for (String string : Config.visibleStats) {
            try {
                MutableComponent value;
                if ((value = (switch (string.toLowerCase()) {
                    case "playtime" -> PlayerListRenderer.formatValue(PlayerListRenderer.formatTime(stats.getPlayTime()));
                    case "deaths" -> PlayerListRenderer.formatValue(String.valueOf(stats.getDeaths()));
                    case "distance" -> {
                        double km = (double)stats.getBlocksWalked() / 100.0 / 1000.0;
                        yield PlayerListRenderer.formatValue(Config.compactMode ? String.format("%.1f", km) : String.format("%.1f km", km));
                    }
                    case "jumps" -> PlayerListRenderer.formatValue(String.valueOf(stats.getJumps()));
                    case "dmgdealt" -> PlayerListRenderer.formatValue(Config.compactMode ? String.format("%.0f", Float.valueOf(stats.getDamageDealt())) : String.format("%.0f \u2665", Float.valueOf(stats.getDamageDealt() / 2.0f)));
                    case "dmgtaken" -> PlayerListRenderer.formatValue(Config.compactMode ? String.format("%.0f", Float.valueOf(stats.getDamageTaken())) : String.format("%.0f \u2665", Float.valueOf(stats.getDamageTaken() / 2.0f)));
                    case "lastseen" -> {
                        if (stats.isOnline()) {
                            yield Component.literal((String)"Online").withStyle(ChatFormatting.GREEN);
                        }
                        yield PlayerListRenderer.formatValue(PlayerListRenderer.formatLastSeen(stats.getLastSeen()));
                    }
                    default -> Component.empty();
                })) == Component.empty()) continue;
                if (!stats.isOnline() && Config.grayOutOffline) {
                    value = value.copy().withStyle(ChatFormatting.GRAY);
                }
                statMap.put(string, (Component)value);
            }
            catch (Exception e) {
                LOGGER.error("Error processing stat {}: {}", (Object)string, (Object)e.getMessage());
            }
        }
        STATS_CACHE.put((Object)playerId, statMap);
        return statMap;
    }

    private static String formatTime(long ticks) {
        Object result;
        if (ticks <= 0L) {
            return "0h";
        }
        Long cacheKey = ticks;
        String cached = TIME_FORMAT_CACHE.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        long totalSeconds = ticks / 20L;
        if (Config.compactMode) {
            result = TimeUnit.SECONDS.toHours(totalSeconds) + "h";
        } else {
            long days = TimeUnit.SECONDS.toDays(totalSeconds);
            long hours = TimeUnit.SECONDS.toHours(totalSeconds) % 24L;
            long minutes = TimeUnit.SECONDS.toMinutes(totalSeconds) % 60L;
            StringBuilder time = new StringBuilder();
            if (days > 0L) {
                time.append(days).append("d ");
            }
            if (hours > 0L || days > 0L) {
                time.append(hours).append("h ");
            }
            if (minutes > 0L) {
                time.append(minutes).append("m");
            }
            result = time.toString().trim();
        }
        TIME_FORMAT_CACHE.put(cacheKey, (String)result);
        return result;
    }

    private static String formatLastSeen(long timestamp) {
        if (timestamp <= 0L) {
            return "Never";
        }
        long now = System.currentTimeMillis();
        long diff = now - timestamp;
        if (diff < 0L) {
            return "Unknown";
        }
        Object result = Config.compactMode ? (diff < TimeUnit.MINUTES.toMillis(1L) ? "now" : (diff < TimeUnit.HOURS.toMillis(1L) ? diff / TimeUnit.MINUTES.toMillis(1L) + "m" : (diff < TimeUnit.DAYS.toMillis(1L) ? diff / TimeUnit.HOURS.toMillis(1L) + "h" : diff / TimeUnit.DAYS.toMillis(1L) + "d"))) : (diff < TimeUnit.MINUTES.toMillis(1L) ? "Just now" : (diff < TimeUnit.HOURS.toMillis(1L) ? diff / TimeUnit.MINUTES.toMillis(1L) + " mins ago" : (diff < TimeUnit.DAYS.toMillis(1L) ? diff / TimeUnit.HOURS.toMillis(1L) + " hours ago" : diff / TimeUnit.DAYS.toMillis(1L) + " days ago")));
        return result;
    }

    private static Component formatValue(String value) {
        return value == null || value.isEmpty() ? Component.empty() : Component.literal((String)value);
    }
}

