/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.mehvahdjukaar.moonlight.api.misc.ResourceLocationSearchTrie;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.IDebugDumpable;
import net.mehvahdjukaar.moonlight.api.resources.pack.IEditablePackResources;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public class InMemoryPackResources
extends AbstractPackResources
implements IEditablePackResources,
IDebugDumpable {
    protected final boolean hidden;
    protected final PackType packType;
    protected final PackMetadataSection metadata;
    protected final Set<String> namespaces = new HashSet<String>();
    protected final Map<ResourceLocation, byte[]> resources = new ConcurrentHashMap<ResourceLocation, byte[]>();
    protected final Map<String, byte[]> rootResources = new ConcurrentHashMap<String, byte[]>();
    protected final ResourceLocationSearchTrie searchTrie = new ResourceLocationSearchTrie();

    protected InMemoryPackResources(PackLocationInfo info, PackType type) {
        this(info, type, false);
    }

    protected InMemoryPackResources(PackLocationInfo info, PackType type, boolean hidden) {
        super(info);
        this.packType = type;
        this.hidden = hidden;
        this.metadata = new PackMetadataSection((Component)Component.translatable((String)"message.moonlight.runtime"), SharedConstants.getCurrentVersion().getPackVersion(this.packType), Optional.empty());
    }

    public Set<String> getNamespaces(PackType packType) {
        if (packType != this.packType) {
            return Set.of();
        }
        return this.namespaces;
    }

    public <T> T getMetadataSection(MetadataSectionSerializer<T> serializer) {
        try {
            return (T)(serializer == PackMetadataSection.TYPE ? this.metadata : null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... strings) {
        String fileName = String.join((CharSequence)"/", strings);
        byte[] resource = this.rootResources.get(fileName);
        return resource == null ? null : () -> new ByteArrayInputStream(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listResources(PackType packType, String namespace, String id, PackResources.ResourceOutput output) {
        if (packType == this.packType) {
            InMemoryPackResources inMemoryPackResources = this;
            synchronized (inMemoryPackResources) {
                this.searchTrie.search(namespace + "/" + id).forEach(r -> {
                    byte[] buf = this.resources.get(r);
                    output.accept(r, () -> {
                        if (buf == null) {
                            throw new IllegalStateException("Somehow search tree returned a resource not in resources " + String.valueOf(r));
                        }
                        return new ByteArrayInputStream(buf);
                    });
                });
            }
        }
    }

    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation id) {
        byte[] res = this.resources.get(id);
        if (res != null) {
            return () -> {
                if (type != this.packType) {
                    throw new IOException(String.format("Tried to access wrong type of resource on %s.", this.packId()));
                }
                return new ByteArrayInputStream(res);
            };
        }
        return null;
    }

    public void close() {
    }

    @Override
    public void addNamespaces(String ... namespaces) {
        this.namespaces.addAll(Arrays.asList(namespaces));
    }

    @Override
    public void addRootResource(String name, byte[] resource) {
        this.rootResources.put(name, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResource(ResourceLocation id, byte[] bytes) {
        InMemoryPackResources inMemoryPackResources = this;
        synchronized (inMemoryPackResources) {
            this.namespaces.add(id.getNamespace());
            this.resources.put(id, bytes);
            this.searchTrie.insert(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResource(ResourceLocation id) {
        InMemoryPackResources inMemoryPackResources = this;
        synchronized (inMemoryPackResources) {
            this.resources.remove(id);
            this.searchTrie.remove(id);
        }
    }

    @Override
    public void removeRootResource(String name) {
        this.rootResources.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clearAllResources() {
        InMemoryPackResources inMemoryPackResources = this;
        synchronized (inMemoryPackResources) {
            this.resources.clear();
            this.rootResources.clear();
            this.searchTrie.clear();
        }
        return true;
    }

    @Override
    public PackType getPackType() {
        return this.packType;
    }

    @Override
    public boolean isEmpty() {
        return this.resources.isEmpty();
    }

    @Override
    public void dumpToDisk(Path path) {
        this.resources.forEach((k, v) -> {
            try {
                Path p = RPUtils.getResourcePath(path, k, this.packType);
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
                Files.write(p, v, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }
}

