/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.mehvahdjukaar.moonlight.api.misc.ResourceLocationSearchTrie;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FastSearchFilePackResources
extends AbstractPackResources {
    static final Logger LOGGER = LogUtils.getLogger();
    private final SharedZipFileAccess zipFileAccess;
    private final ResourceLocationSearchTrie searchTrie = new ResourceLocationSearchTrie();
    private final PackType packType;

    FastSearchFilePackResources(PackLocationInfo location, File file, PackType packType) {
        super(location);
        this.zipFileAccess = new SharedZipFileAccess(file);
        this.packType = packType;
        this.buildIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildIndex() {
        Stopwatch watch = Stopwatch.createStarted();
        try {
            ZipFile zip = this.zipFileAccess.getOrCreateZipFile();
            String pathName = this.packType.getDirectory() + "/";
            assert (zip != null);
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                String name;
                ZipEntry ze = e.nextElement();
                if (ze.isDirectory() || !(name = ze.getName()).startsWith(pathName)) continue;
                name = name.substring(pathName.length());
                this.searchTrie.insertPath(name);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to index zip file {}", (Object)this.zipFileAccess, (Object)e);
        }
        finally {
            Moonlight.LOGGER.info("Populated search tree for pack at {} in {}", (Object)this.zipFileAccess, (Object)watch);
        }
    }

    private static String getPathFromLocation(PackType packType, ResourceLocation location) {
        return String.format(Locale.ROOT, "%s/%s/%s", packType.getDirectory(), location.getNamespace(), location.getPath());
    }

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... elements) {
        return this.getResource(String.join((CharSequence)"/", elements));
    }

    public IoSupplier<InputStream> getResource(PackType packType, ResourceLocation location) {
        if (packType != this.packType) {
            return null;
        }
        return this.getResource(FastSearchFilePackResources.getPathFromLocation(packType, location));
    }

    @Nullable
    private IoSupplier<InputStream> getResource(String resourcePath) {
        ZipFile zipFile = this.zipFileAccess.getOrCreateZipFile();
        if (zipFile == null) {
            return null;
        }
        ZipEntry zipEntry = zipFile.getEntry(resourcePath);
        return zipEntry == null ? null : IoSupplier.create((ZipFile)zipFile, (ZipEntry)zipEntry);
    }

    public Set<String> getNamespaces(PackType packType) {
        if (packType != this.packType) {
            return Set.of();
        }
        return new HashSet<String>(this.searchTrie.listFolders(""));
    }

    public void close() {
        this.zipFileAccess.close();
    }

    public void listResources(PackType packType, String namespace, String path, PackResources.ResourceOutput output) {
        if (packType != this.packType) {
            return;
        }
        String prefix = packType.getDirectory() + "/";
        ZipFile zipFile = this.zipFileAccess.getOrCreateZipFile();
        if (zipFile != null) {
            this.searchTrie.search(namespace + "/" + path).forEach(r -> {
                ZipEntry zipEntry = zipFile.getEntry(prefix + r.getNamespace() + "/" + r.getPath());
                if (zipEntry == null) {
                    throw new RuntimeException("Zip file entry was null");
                }
                output.accept(r, (Object)IoSupplier.create((ZipFile)zipFile, (ZipEntry)zipEntry));
            });
        }
    }

    static class SharedZipFileAccess
    implements AutoCloseable {
        final File file;
        @Nullable
        private ZipFile zipFile;
        private boolean failedToLoad;

        SharedZipFileAccess(File file) {
            this.file = file;
        }

        @Nullable
        ZipFile getOrCreateZipFile() {
            if (this.failedToLoad) {
                return null;
            }
            if (this.zipFile == null) {
                try {
                    this.zipFile = new ZipFile(this.file);
                }
                catch (IOException var2) {
                    LOGGER.error("Failed to open pack {}", (Object)this.file, (Object)var2);
                    this.failedToLoad = true;
                    return null;
                }
            }
            return this.zipFile;
        }

        public String toString() {
            return this.file.toString();
        }

        @Override
        public void close() {
            if (this.zipFile != null) {
                IOUtils.closeQuietly((Closeable)this.zipFile);
                this.zipFile = null;
            }
        }
    }
}

