/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform;

import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.neoforge.PlatHelperImpl;
import net.mehvahdjukaar.moonlight.core.misc.LoaderCondition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatHelper {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addCommonSetup(Runnable commonSetup) {
        PlatHelperImpl.addCommonSetup(commonSetup);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addCommonSetupAsync(Runnable commonSetup) {
        PlatHelperImpl.addCommonSetupAsync(commonSetup);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addReloadableCommonSetup(BiConsumer<RegistryAccess, Boolean> setup) {
        PlatHelperImpl.addReloadableCommonSetup(setup);
    }

    @Contract
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isDev() {
        return PlatHelperImpl.isDev();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoadingValid() {
        return PlatHelperImpl.isModLoadingValid();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isInitializing() {
        return PlatHelperImpl.isInitializing();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean evaluateRecipeCondition(DynamicOps<JsonElement> ops, JsonElement jo) {
        void var1_1;
        return PlatHelperImpl.evaluateRecipeCondition(ops, (JsonElement)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <A> void setComponent(DataComponentHolder to, DataComponentType<A> type, A componentValue) {
        void var2_2;
        void var1_1;
        PlatHelperImpl.setComponent(to, var1_1, var2_2);
    }

    @Contract
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void invokeLevelUnload(Level l) {
        PlatHelperImpl.invokeLevelUnload(l);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isFakePlayer(ServerPlayer instance) {
        return PlatHelperImpl.isFakePlayer(instance);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static MapCodec<LoaderCondition> getConditionCodec() {
        return PlatHelperImpl.getConditionCodec();
    }

    @Contract
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Platform getPlatform() {
        return PlatHelperImpl.getPlatform();
    }

    @Contract
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Side getPhysicalSide() {
        return PlatHelperImpl.getPhysicalSide();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getGamePath() {
        return PlatHelperImpl.getGamePath();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getModFilePath(String modId) {
        return PlatHelperImpl.getModFilePath(modId);
    }

    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String getModPageUrl(String modId) {
        return PlatHelperImpl.getModPageUrl(modId);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String getModName(String modId) {
        return PlatHelperImpl.getModName(modId);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> Field findField(Class<? super T> clazz, String fieldName) {
        void var1_1;
        return PlatHelperImpl.findField(clazz, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Method findMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        void var2_2;
        void var1_1;
        return PlatHelperImpl.findMethod(clazz, (String)var1_1, var2_2);
    }

    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static MinecraftServer getCurrentServer() {
        return PlatHelperImpl.getCurrentServer();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String modId) {
        return PlatHelperImpl.isModLoaded(modId);
    }

    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String getModVersion(String modId) {
        return PlatHelperImpl.getModVersion(modId);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<String> getInstalledMods() {
        return PlatHelperImpl.getInstalledMods();
    }

    @Deprecated(forRemoval=true)
    public static void registerResourcePack(PackType packType, Supplier<Pack> packSupplier) {
        RegHelper.registerResourcePack(packType, packSupplier);
    }

    /*
     * WARNING - void declaration
     */
    @Contract
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isMobGriefingOn(Level level, Entity entity) {
        void var1_1;
        return PlatHelperImpl.isMobGriefingOn(level, (Entity)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isAreaLoaded(LevelReader level, BlockPos pos, int maxRange) {
        void var2_2;
        void var1_1;
        return PlatHelperImpl.isAreaLoaded(level, (BlockPos)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @Nullable
    @ExpectPlatform.Transformed
    public static FoodProperties getFoodProperties(ItemStack stack, Player player) {
        void var1_1;
        return PlatHelperImpl.getFoodProperties(stack, (Player)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getBurnTime(ItemStack stack) {
        return PlatHelperImpl.getBurnTime(stack);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isFireSource(BlockState blockState, Level level, BlockPos pos, Direction up) {
        void var3_3;
        void var2_2;
        void var1_1;
        return PlatHelperImpl.isFireSource(blockState, (Level)var1_1, (BlockPos)var2_2, (Direction)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        void var3_3;
        void var2_2;
        void var1_1;
        return PlatHelperImpl.getFireSpreadSpeed(state, (BlockGetter)var1_1, (BlockPos)var2_2, (Direction)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        void var3_3;
        void var2_2;
        void var1_1;
        return PlatHelperImpl.getFlammability(state, (BlockGetter)var1_1, (BlockPos)var2_2, (Direction)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        void var3_3;
        void var2_2;
        void var1_1;
        return PlatHelperImpl.isFlammable(state, (BlockGetter)var1_1, (BlockPos)var2_2, (Direction)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void onCaughtFire(BlockState state, Level level, BlockPos pos, Direction direction, @Nullable LivingEntity igniter) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        PlatHelperImpl.onCaughtFire(state, (Level)var1_1, (BlockPos)var2_2, (Direction)var3_3, (LivingEntity)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Packet<ClientGamePacketListener> getEntitySpawnPacket(Entity entity, ServerEntity serverEntity) {
        void var1_1;
        return PlatHelperImpl.getEntitySpawnPacket(entity, (ServerEntity)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SpawnEggItem newSpawnEgg(Supplier<? extends EntityType<? extends Mob>> entityType, int color, int outerColor, Item.Properties properties) {
        void var3_3;
        void var2_2;
        void var1_1;
        return PlatHelperImpl.newSpawnEgg(entityType, (int)var1_1, (int)var2_2, (Item.Properties)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static FlowerPotBlock newFlowerPot(@Nullable Supplier<FlowerPotBlock> emptyPot, Supplier<? extends Block> supplier, BlockBehaviour.Properties properties) {
        void var2_2;
        void var1_1;
        return PlatHelperImpl.newFlowerPot(emptyPot, (Supplier<? extends Block>)var1_1, (BlockBehaviour.Properties)var2_2);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SimpleParticleType newParticle() {
        return PlatHelperImpl.newParticle();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends ParticleOptions> ParticleType<T> newParticle(MapCodec<T> codec, StreamCodec<RegistryFriendlyByteBuf, T> streamCodec) {
        void var1_1;
        return PlatHelperImpl.newParticle(codec, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends BlockEntity> BlockEntityType<T> newBlockEntityType(BlockEntitySupplier<T> blockEntitySupplier, Block ... validBlocks) {
        void var1_1;
        return PlatHelperImpl.newBlockEntityType(blockEntitySupplier, (Block[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <E extends Entity> EntityType<E> newEntityType(String name, EntityType.EntityFactory<E> factory, MobCategory category, float width, float height, int clientTrackingRange, boolean velocityUpdates, int updateInterval) {
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return PlatHelperImpl.newEntityType(name, var1_1, (MobCategory)var2_2, (float)var3_3, (float)var4_4, (int)var5_5, (boolean)var6_6, (int)var7_7);
    }

    @Deprecated(forRemoval=true)
    public static void addServerReloadListener(PreparableReloadListener listener, ResourceLocation location) {
        PlatHelper.addServerReloadListener((HolderLookup.Provider provider) -> listener, location);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addServerReloadListener(Function<HolderLookup.Provider, PreparableReloadListener> listener, ResourceLocation location) {
        void var1_1;
        PlatHelperImpl.addServerReloadListener(listener, (ResourceLocation)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void openCustomMenu(ServerPlayer player, MenuProvider menuProvider, Consumer<RegistryFriendlyByteBuf> extraDataProvider) {
        void var2_2;
        void var1_1;
        PlatHelperImpl.openCustomMenu(player, (MenuProvider)var1_1, (Consumer<RegistryFriendlyByteBuf>)var2_2);
    }

    @Deprecated(forRemoval=true)
    public static void openCustomMenu(ServerPlayer player, MenuProvider menuProvider, BlockPos pos) {
        PlatHelper.openCustomMenu(player, menuProvider, (RegistryFriendlyByteBuf buf) -> buf.writeBlockPos(pos));
    }

    public static <T extends Entity> void openCustomMenu(ServerPlayer player, T menuProvider) {
        TileOrEntityTarget target = TileOrEntityTarget.of(menuProvider);
        PlatHelper.openCustomMenu(player, (MenuProvider)menuProvider, target::write);
    }

    public static <T extends BlockEntity> void openCustomMenu(ServerPlayer player, T menuProvider) {
        TileOrEntityTarget target = TileOrEntityTarget.of(menuProvider);
        PlatHelper.openCustomMenu(player, (MenuProvider)menuProvider, target::write);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Player getFakeServerPlayer(GameProfile id, ServerLevel level) {
        void var1_1;
        return PlatHelperImpl.getFakeServerPlayer(id, (ServerLevel)var1_1);
    }

    @FunctionalInterface
    public static interface BlockEntitySupplier<T extends BlockEntity> {
        @NotNull
        public T create(BlockPos var1, BlockState var2);
    }

    public static enum Side {
        CLIENT,
        SERVER;


        public boolean isClient() {
            return this == CLIENT;
        }

        public boolean isServer() {
            return this == SERVER;
        }

        public void ifClient(Runnable runnable) {
            if (this.isClient()) {
                runnable.run();
            }
        }

        public void ifServer(Runnable runnable) {
            if (this.isServer()) {
                runnable.run();
            }
        }
    }

    public static enum Platform {
        FORGE,
        FABRIC;

        private static boolean quilt;

        public boolean isForge() {
            return this == FORGE;
        }

        public boolean isFabric() {
            return this == FABRIC;
        }

        public boolean isQuilt() {
            return this.isFabric() && quilt;
        }

        public void ifForge(Runnable runnable) {
            if (this.isForge()) {
                runnable.run();
            }
        }

        public void ifFabric(Runnable runnable) {
            if (this.isFabric()) {
                runnable.run();
            }
        }

        static {
            quilt = false;
            try {
                Class.forName("org.quiltmc.loader.api.QuiltLoader");
                quilt = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

