/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.registration;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.ServerPaintingManager;
import net.conczin.immersive_paintings.network.payload.c2s.PaintingDeletePayload;
import net.conczin.immersive_paintings.util.PaintingArgumentType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class Command {
    private static final LiteralArgumentBuilder<CommandSourceStack> PAINTING_COMMAND = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"immersive_paintings").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"delete").then(Commands.argument((String)"author", (ArgumentType)PaintingArgumentType.single()).executes(context -> {
        String author = PaintingArgumentType.getAuthor((CommandContext<CommandSourceStack>)context, "author");
        Optional<Map.Entry> e = ServerPaintingManager.getCustomPaintings(((CommandSourceStack)context.getSource()).getServer()).entrySet().stream().filter(entry -> ((Painting)entry.getValue()).author().equals(author)).findFirst();
        if (e.isEmpty()) {
            throw PaintingArgumentType.ERROR_INVALID_PLAYER.create((Object)author);
        }
        new PaintingDeletePayload((ResourceLocation)e.get().getKey(), true).handle((Player)((CommandSourceStack)context.getSource()).getPlayer(), Runnable::run);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"immersive_paintings.command.success.delete", (Object[])new Object[]{author}), true);
        return 1;
    })));

    public static void registerCommands(Consumer<LiteralArgumentBuilder<CommandSourceStack>> consumer) {
        consumer.accept(PAINTING_COMMAND);
    }
}

