/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.network.payload.c2s;

import java.util.Optional;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.ServerPaintingManager;
import net.conczin.immersive_paintings.network.LazyNetworkManager;
import net.conczin.immersive_paintings.network.NetworkHandler;
import net.conczin.immersive_paintings.network.payload.ImmersivePayload;
import net.conczin.immersive_paintings.network.payload.s2c.ImageResponsePayload;
import net.conczin.immersive_paintings.network.payload.s2c.PaintingSyncPayload;
import net.conczin.immersive_paintings.util.ImageManipulations;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.util.TriConsumer;

public record ImageRequestPayload(ResourceLocation identifier, boolean thumbnail) implements ImmersivePayload
{
    public static final CustomPacketPayload.Type<ImageRequestPayload> TYPE = new CustomPacketPayload.Type(Main.locate("image_request"));
    public static final StreamCodec<FriendlyByteBuf, ImageRequestPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ImageRequestPayload::identifier, (StreamCodec)ByteBufCodecs.BOOL, ImageRequestPayload::thumbnail, ImageRequestPayload::new);

    @Override
    public void handle(Player player, ImmersivePayload.Runner runner) {
        ResourceLocation id = this.identifier();
        boolean thumbnail = this.thumbnail();
        runner.run(() -> {
            Optional<byte[]> image = ServerPaintingManager.getImageData(id, thumbnail);
            if (image.isPresent()) {
                ImageManipulations.processByteArrayInChunks(image.get(), (TriConsumer<byte[], Integer, Integer>)((TriConsumer)(bytes, split, count) -> LazyNetworkManager.sendToClient(new ImageResponsePayload(id, thumbnail, (byte[])bytes, (int)split, (int)count), (ServerPlayer)player)));
            } else if (!thumbnail && player.getServer() != null) {
                NetworkHandler.sendToAllClients(player.getServer(), new PaintingSyncPayload(id, null));
            }
        });
    }

    public CustomPacketPayload.Type<ImageRequestPayload> type() {
        return TYPE;
    }
}

