/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.rei.ingredient;

import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import net.mehvahdjukaar.jeed.plugin.rei.REIPlugin;
import net.mehvahdjukaar.jeed.plugin.rei.ingredient.EffectInstanceRenderer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class EffectInstanceDefinition
implements EntryDefinition<MobEffectInstance>,
EntrySerializer<MobEffectInstance> {
    public void fillCrashReport(CrashReport report, CrashReportCategory category, EntryStack<MobEffectInstance> entry) {
        super.fillCrashReport(report, category, entry);
        MobEffect effect = (MobEffect)((MobEffectInstance)entry.getValue()).getEffect().value();
        Component displayName = effect.getDisplayName();
        category.setDetail("Effect", () -> ((Component)displayName).getString());
        category.setDetail("Duration", () -> String.valueOf(((MobEffectInstance)entry.getValue()).getDuration()));
        category.setDetail("Amplifier", () -> String.valueOf(((MobEffectInstance)entry.getValue()).getAmplifier()));
    }

    public Class<MobEffectInstance> getValueType() {
        return MobEffectInstance.class;
    }

    public EntryType<MobEffectInstance> getType() {
        return REIPlugin.EFFECT_ENTRY_TYPE;
    }

    public EntryRenderer<MobEffectInstance> getRenderer() {
        return EffectInstanceRenderer.INSTANCE;
    }

    @Nullable
    public ResourceLocation getIdentifier(EntryStack<MobEffectInstance> entry, MobEffectInstance value) {
        return ((ResourceKey)value.getEffect().unwrapKey().get()).location();
    }

    public boolean isEmpty(EntryStack<MobEffectInstance> entry, MobEffectInstance value) {
        return false;
    }

    public MobEffectInstance copy(EntryStack<MobEffectInstance> entry, MobEffectInstance value) {
        return new MobEffectInstance(value.getEffect(), value.getDuration(), value.getAmplifier(), value.isAmbient(), value.isVisible(), value.showIcon(), value.hiddenEffect);
    }

    public MobEffectInstance normalize(EntryStack<MobEffectInstance> entry, MobEffectInstance value) {
        return new MobEffectInstance(value.getEffect(), 600, 0, value.isAmbient(), value.isVisible(), value.showIcon(), value.hiddenEffect);
    }

    public MobEffectInstance wildcard(EntryStack<MobEffectInstance> entry, MobEffectInstance value) {
        return new MobEffectInstance(value.getEffect(), 600);
    }

    public long hash(EntryStack<MobEffectInstance> entry, MobEffectInstance value, ComparisonContext context) {
        int i = value.getEffect().hashCode();
        if (context.isExact()) {
            i = 31 * i + value.getAmplifier();
            i = 31 * i + (value.isAmbient() ? 1 : 0);
        }
        return i;
    }

    public boolean equals(MobEffectInstance o1, MobEffectInstance o2, ComparisonContext context) {
        if (o1.getEffect() != o2.getEffect()) {
            return false;
        }
        if (context.isExact()) {
            if (o1.getAmplifier() != o2.getAmplifier()) {
                return false;
            }
            return o1.isAmbient() == o2.isAmbient();
        }
        return true;
    }

    @Nullable
    public ItemStack cheatsAs(EntryStack<MobEffectInstance> entry, MobEffectInstance value) {
        ItemStack item = new ItemStack((ItemLike)Items.POTION);
        PotionContents potionContents = new PotionContents(Optional.empty(), Optional.of(((MobEffect)value.getEffect().value()).getColor()), Collections.singletonList(this.normalize(entry, value)));
        item.set(DataComponents.POTION_CONTENTS, (Object)potionContents);
        return item;
    }

    @Nullable
    public EntrySerializer<MobEffectInstance> getSerializer() {
        return this;
    }

    public Component asFormattedText(EntryStack<MobEffectInstance> entry, MobEffectInstance value) {
        return ((MobEffect)value.getEffect().value()).getDisplayName();
    }

    public Stream<? extends TagKey<?>> getTagsFor(EntryStack<MobEffectInstance> entry, MobEffectInstance value) {
        return value.getEffect().tags();
    }

    public boolean supportReading() {
        return true;
    }

    public boolean supportSaving() {
        return true;
    }

    public boolean acceptsNull() {
        return false;
    }

    public CompoundTag save(EntryStack<MobEffectInstance> entry, MobEffectInstance value) {
        return (CompoundTag)value.save();
    }

    public MobEffectInstance read(CompoundTag tag) {
        return MobEffectInstance.load((CompoundTag)tag);
    }
}

