/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.mixin.foundation.copycat;

import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.decoration.bracket.BracketBlock;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Block.class})
public class BlockMixin {
    @WrapOperation(method={"shouldRenderFace(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;canOcclude()Z")})
    private static boolean canCopycatOcclude(BlockState instance, Operation<Boolean> original, @Local(argsOnly=true) BlockGetter level, @Local(argsOnly=true, ordinal=1) BlockPos pos) {
        if (AllBlocks.COPYCAT_BASE.has(instance)) {
            return false;
        }
        if (instance.getBlock() instanceof BracketBlock) {
            return false;
        }
        Block block = instance.getBlock();
        if (block instanceof ICopycatBlock) {
            ICopycatBlock copycatBlock = (ICopycatBlock)block;
            return copycatBlock.canOcclude(level, instance, pos);
        }
        return (Boolean)original.call(new Object[]{instance});
    }

    @Inject(method={"shouldRenderFace(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="NEW", target="Lnet/minecraft/world/level/block/Block$BlockStatePairKey;")}, cancellable=true)
    private static void calculateOcclusionShape(BlockState state, BlockGetter level, BlockPos offset, Direction face, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (block instanceof ICopycatBlock) {
            ICopycatBlock copycatBlock = (ICopycatBlock)block;
            Optional<Boolean> result = copycatBlock.shapeCanOccludeNeighbor(level, pos, blockState, offset, face.getOpposite()).map(b -> b == false);
            result.ifPresent(arg_0 -> cir.setReturnValue(arg_0));
        }
    }
}

