/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.fluid_pipe.neoforge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.function.Function;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.FluidRenderHelper;
import net.createmod.catnip.render.PonderRenderTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;

public class ExpandedFluidRenderer {
    public static VertexConsumer getFluidBuilder(MultiBufferSource buffer) {
        return buffer.getBuffer(PonderRenderTypes.fluid());
    }

    public static void renderFluidStream(FluidStack fluidStack, Direction direction, float radius, float progress, float centerOffset, boolean inbound, MultiBufferSource buffer, PoseStack ms, int light) {
        ExpandedFluidRenderer.renderFluidStream(fluidStack, direction, radius, progress, centerOffset, inbound, ExpandedFluidRenderer.getFluidBuilder(buffer), ms, light);
    }

    public static void renderFluidStream(FluidStack fluidStack, Direction direction, float radius, float progress, float centerOffset, boolean inbound, VertexConsumer builder, PoseStack ms, int light) {
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)fluid);
        FluidType fluidAttributes = fluid.getFluidType();
        Function spriteAtlas = Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS);
        TextureAtlasSprite flowTexture = (TextureAtlasSprite)spriteAtlas.apply(clientFluid.getFlowingTexture(fluidStack));
        TextureAtlasSprite stillTexture = (TextureAtlasSprite)spriteAtlas.apply(clientFluid.getStillTexture(fluidStack));
        int color = clientFluid.getTintColor(fluidStack);
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, fluidAttributes.getLightLevel(fluidStack));
        light = light & 0xF00000 | luminosity << 4;
        if (inbound) {
            direction = direction.getOpposite();
        }
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        ms.pushPose();
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)msr.center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)direction))).rotateXDegrees(direction == Direction.UP ? 180.0f : (direction == Direction.DOWN ? 0.0f : 270.0f))).uncenter();
        ms.translate(0.5, 0.0, 0.5);
        float h = radius;
        float hMin = -radius;
        float hMax = radius;
        float y = inbound ? 1.0f : 0.5f + centerOffset;
        float yMin = y - Mth.clamp((float)(progress * (0.5f + centerOffset)), (float)0.0f, (float)1.0f);
        float yMax = y;
        for (int i = 0; i < 4; ++i) {
            ms.pushPose();
            FluidRenderer.renderFlowingTiledFace((Direction)Direction.SOUTH, (float)hMin, (float)yMin, (float)hMax, (float)yMax, (float)h, (VertexConsumer)builder, (PoseStack)ms, (int)light, (int)color, (TextureAtlasSprite)flowTexture);
            ms.popPose();
            msr.rotateYDegrees(90.0f);
        }
        if (progress != 1.0f) {
            FluidRenderHelper.renderStillTiledFace((Direction)Direction.DOWN, (float)hMin, (float)hMin, (float)hMax, (float)hMax, (float)yMin, (VertexConsumer)builder, (PoseStack)ms, (int)light, (int)color, (TextureAtlasSprite)stillTexture);
        }
        ms.popPose();
    }
}

