/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.config;

import java.util.Locale;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum FeatureCategory implements StringRepresentable
{
    SLOPES("All copycats with a sloped surface"),
    MULTISTATES("All copycats that support multiple materials in a single block"),
    STACKABLES("All copycats that can be resized by putting in more of the same copycat"),
    REDSTONE("All copycats that can emit a redstone signal"),
    FUNCTIONAL("All copycats with extra functions/interactions"),
    CREATE("All copycats mimicking blocks from Create");

    private final String description;

    private FeatureCategory(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    @NotNull
    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static FeatureCategory byName(String name) {
        for (FeatureCategory category : FeatureCategory.values()) {
            if (!category.getSerializedName().equalsIgnoreCase(name)) continue;
            return category;
        }
        return null;
    }
}

