/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.searchstats.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.terminalmc.searchstats.SearchStats;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.achievement.StatsScreen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StatsScreen.class})
public abstract class MixinStatsScreen
extends Screen {
    @Shadow
    @Nullable
    private ObjectSelectionList<?> activeList;
    @Shadow
    @Nullable
    private StatsScreen.GeneralStatisticsList statsList;
    @Shadow
    @Nullable
    StatsScreen.ItemStatisticsList itemStatsList;
    @Shadow
    @Nullable
    private StatsScreen.MobsStatisticsList mobsStatsList;
    @Unique
    private EditBox searchstats$searchField;

    @Shadow
    public abstract void setActiveList(@Nullable ObjectSelectionList<?> var1);

    @Shadow
    public abstract void initLists();

    public MixinStatsScreen(Component text) {
        super(text);
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    private void resetSearch(CallbackInfo ci) {
        SearchStats.setSearchString("");
    }

    @WrapOperation(method={"initButtons"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/Button;builder(Lnet/minecraft/network/chat/Component;Lnet/minecraft/client/gui/components/Button$OnPress;)Lnet/minecraft/client/gui/components/Button$Builder;")})
    private Button.Builder wrapBuilder(Component message, Button.OnPress onPress, Operation<Button.Builder> original) {
        return Button.builder((Component)message, button -> {
            ObjectSelectionList<?> oldActiveList = this.activeList;
            onPress.onPress(button);
            if (this.searchstats$searchField != null && this.activeList != oldActiveList) {
                this.searchstats$searchField.setValue("");
                SearchStats.setSearchString(this.searchstats$searchField.getValue());
                this.searchstats$recreateStatsLists();
            }
        });
    }

    @WrapOperation(method={"initButtons"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/layouts/HeaderAndFooterLayout;addTitleHeader(Lnet/minecraft/network/chat/Component;Lnet/minecraft/client/gui/Font;)V")})
    public void createSearchField(HeaderAndFooterLayout instance, Component message, Font font, Operation<Void> original) {
        int height = 18;
        LinearLayout layout = ((LinearLayout)instance.addToHeader((LayoutElement)LinearLayout.horizontal())).spacing(5);
        layout.addChild((LayoutElement)new StringWidget(font.width(message.getString()), height, message, font));
        this.searchstats$searchField = new EditBox(font, 145, height, (Component)Component.empty());
        this.searchstats$searchField.setCanLoseFocus(false);
        this.searchstats$searchField.setFocused(true);
        layout.addChild((LayoutElement)this.searchstats$searchField);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.searchstats$searchField != null && this.searchstats$searchField.keyPressed(keyCode, scanCode, modifiers)) {
            SearchStats.setSearchString(this.searchstats$searchField.getValue());
            this.searchstats$recreateStatsLists();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.searchstats$searchField != null && this.searchstats$searchField.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean charTyped(char chr, int keyCode) {
        if (this.searchstats$searchField.charTyped(chr, keyCode)) {
            SearchStats.setSearchString(this.searchstats$searchField.getValue());
            this.searchstats$recreateStatsLists();
            return true;
        }
        return super.charTyped(chr, keyCode);
    }

    @Unique
    private void searchstats$recreateStatsLists() {
        if (this.activeList == this.statsList) {
            this.initLists();
            this.setActiveList((ObjectSelectionList<?>)this.statsList);
        } else if (this.activeList == this.itemStatsList) {
            this.initLists();
            this.setActiveList((ObjectSelectionList<?>)this.itemStatsList);
        } else if (this.activeList == this.mobsStatsList) {
            this.initLists();
            this.setActiveList((ObjectSelectionList<?>)this.mobsStatsList);
        }
    }
}

