/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsextras.world.feature.swamp;

import com.yungnickyoung.minecraft.yungsextras.world.config.ResourceLocationFeatureConfiguration;
import com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.AbstractSwampFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class SwampOgreFeature
extends AbstractSwampFeature<ResourceLocationFeatureConfiguration> {
    public SwampOgreFeature() {
        super(ResourceLocationFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<ResourceLocationFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        RandomSource randomSource = context.random();
        BlockPos pos = context.origin();
        ResourceLocation location = ((ResourceLocationFeatureConfiguration)context.config()).getLocation();
        BlockPos.MutableBlockPos mutable = pos.mutable();
        while (level.isEmptyBlock((BlockPos)mutable) && mutable.getY() > 2) {
            mutable.move(Direction.DOWN);
        }
        BlockPos surfacePos = mutable.immutable();
        BlockPos cornerPos = surfacePos.offset(-2, 0, -2);
        mutable.set((Vec3i)cornerPos);
        if (level.isEmptyBlock((BlockPos)mutable)) {
            return false;
        }
        mutable.set((Vec3i)cornerPos).move(Direction.SOUTH, 3);
        if (level.isEmptyBlock((BlockPos)mutable)) {
            return false;
        }
        mutable.set((Vec3i)cornerPos).move(Direction.EAST, 3);
        if (level.isEmptyBlock((BlockPos)mutable)) {
            return false;
        }
        mutable.set((Vec3i)cornerPos).move(Direction.SOUTH, 3).move(Direction.EAST, 3);
        if (level.isEmptyBlock((BlockPos)mutable)) {
            return false;
        }
        StructureTemplate template = this.createTemplateFromCenter(location, level, randomSource, surfacePos);
        return template != null;
    }
}

