/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.chloride.impl.sodium.pages;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import me.srrapero720.chloride.ChlorideConfig;
import me.srrapero720.chloride.impl.sodium.SodiumFeatures;
import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.OptionGroup;
import net.caffeinemc.mods.sodium.client.gui.options.OptionImpl;
import net.caffeinemc.mods.sodium.client.gui.options.OptionPage;
import net.caffeinemc.mods.sodium.client.gui.options.control.TickBoxControl;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;

public class ParticlesPage
extends OptionPage {
    public ParticlesPage() {
        super((Component)Component.translatable((String)"chloride.particles"), ParticlesPage.create());
    }

    private static ImmutableList<OptionGroup> create() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        OptionGroup.Builder particles = OptionGroup.createBuilder();
        OptionGroup.Builder base = OptionGroup.createBuilder();
        base.add((Option)OptionImpl.createBuilder(Boolean.TYPE, SodiumFeatures.STORAGE).setName((Component)Component.translatable((String)"chloride.particles.rain.title")).setTooltip((Component)Component.translatable((String)"chloride.particles.rain.desc")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            ChlorideConfig.rainParticles = value;
        }, opts -> ChlorideConfig.rainParticles).build());
        base.add((Option)OptionImpl.createBuilder(Boolean.TYPE, SodiumFeatures.STORAGE).setName((Component)Component.translatable((String)"chloride.particles.rain.drop.title")).setTooltip((Component)Component.translatable((String)"chloride.particles.rain.drop.desc")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            ChlorideConfig.rainDropParticles = value;
        }, opts -> ChlorideConfig.rainDropParticles).build());
        base.add((Option)OptionImpl.createBuilder(Boolean.TYPE, SodiumFeatures.STORAGE).setName((Component)Component.translatable((String)"chloride.particles.block.cracking.title")).setTooltip((Component)Component.translatable((String)"chloride.particles.block.cracking.desc")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            ChlorideConfig.crackingBlockParticles = value;
        }, opts -> ChlorideConfig.crackingBlockParticles).build());
        base.add((Option)OptionImpl.createBuilder(Boolean.TYPE, SodiumFeatures.STORAGE).setName((Component)Component.translatable((String)"chloride.particles.block.destroy.title")).setTooltip((Component)Component.translatable((String)"chloride.particles.block.destroy.desc")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            ChlorideConfig.destroyedBlockParticles = value;
        }, opts -> ChlorideConfig.destroyedBlockParticles).build());
        OptionGroup.Builder enabled = OptionGroup.createBuilder();
        OptionGroup.Builder disabled = OptionGroup.createBuilder();
        boolean hasEnabled = false;
        boolean hasDisabled = false;
        HashMap<String, String> cachedDisplayNames = new HashMap<String, String>();
        for (ResourceLocation key : BuiltInRegistries.PARTICLE_TYPE.keySet()) {
            String displayName = cachedDisplayNames.computeIfAbsent(key.getNamespace(), k -> {
                IModFileInfo mod = ModList.get().getModFileById(k);
                if (mod != null) {
                    return ((IModInfo)mod.getMods().get(0)).getDisplayName();
                }
                return I18n.get((String)"chloride.particles.provider.unknown", (Object[])new Object[0]);
            });
            boolean contains = ChlorideConfig.disabledParticles.contains(key);
            if (contains) {
                hasDisabled = true;
            } else {
                hasEnabled = true;
            }
            (contains ? disabled : enabled).add((Option)OptionImpl.createBuilder(Boolean.TYPE, SodiumFeatures.STORAGE).setName((Component)Component.literal((String)key.toString())).setTooltip((Component)Component.translatable((String)"chloride.particles.provider", (Object[])new Object[]{Component.literal((String)displayName).withStyle(ChatFormatting.GOLD)})).setControl(TickBoxControl::new).setBinding((opts, value) -> {
                if (value.booleanValue()) {
                    ChlorideConfig.disabledParticles.remove(key);
                } else {
                    ChlorideConfig.disabledParticles.add(key);
                }
            }, opts -> !ChlorideConfig.disabledParticles.contains(key)).build());
        }
        groups.add(base.build());
        if (hasDisabled) {
            groups.add(disabled.build());
        }
        if (hasEnabled) {
            groups.add(enabled.build());
        }
        return ImmutableList.copyOf(groups);
    }
}

