/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.chloride.impl;

import com.mojang.blaze3d.platform.InputConstants;
import me.srrapero720.chloride.ChlorideConfig;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;

@EventBusSubscriber(modid="chloride", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class Zoom {
    private static final double EASE_DELTA = 0.15;
    private static final double DEFAULT = 3.0;
    private static double value = -1.0;
    private static double mouseSensitivity = -1.0;
    public static final KeyMapping KEY = new KeyMapping("chloride.zoom", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 67, "Chloride");

    public static double zoom(double fov) {
        OptionInstance mouseSetting = Minecraft.getInstance().options.sensitivity();
        if (value == -1.0) {
            value = 3.0;
        }
        if (!KEY.isDown()) {
            value = 3.0;
            if (mouseSensitivity != -1.0) {
                mouseSetting.set((Object)mouseSensitivity);
                mouseSensitivity = -1.0;
            }
            return fov;
        }
        if (mouseSensitivity == -1.0) {
            mouseSensitivity = (Double)mouseSetting.get();
        }
        mouseSetting.set((Object)(mouseSensitivity * (1.0 / value)));
        return fov / value;
    }

    public static boolean scroll(double amount) {
        if (!KEY.isDown()) {
            return false;
        }
        if (value == -1.0) {
            value = 3.0;
        }
        value = Math.max(Math.min(amount > 0.0 ? value * 1.1 : (amount < 0.0 ? value * 0.9 : value), ChlorideConfig.maxZoom), 1.0);
        return true;
    }

    public static boolean canUseZoom() {
        return !ModList.get().isLoaded("justzoom") && !ModList.get().isLoaded("zume");
    }

    @SubscribeEvent
    public static void onMouseScrolling(InputEvent.MouseScrollingEvent e) {
        if (Zoom.canUseZoom() && ChlorideConfig.enableZoom) {
            e.setCanceled(Zoom.scroll(e.getScrollDeltaY()));
        }
    }

    @SubscribeEvent
    public static void onGetFovEvent(ViewportEvent.ComputeFov e) {
        if (Zoom.canUseZoom() && ChlorideConfig.enableZoom) {
            e.setFOV(Zoom.zoom(e.getFOV()));
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD, modid="chloride")
    public static final class ModEvents {
        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void registerKeys(RegisterKeyMappingsEvent event) {
            event.register(KEY);
        }
    }
}

