/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.util;

import immersive_melodies.Config;
import immersive_melodies.Items;
import java.util.Random;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class EntityEquiper {
    public static void equip(LivingEntity entity) {
        if (EntityEquiper.shouldEquip((Entity)entity)) {
            Item item = Items.items.values().stream().skip(new Random().nextInt(Items.items.size())).findFirst().orElse(Items.LUTE);
            entity.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)item));
            if (entity instanceof Mob) {
                Mob mobEntity = (Mob)entity;
                mobEntity.setDropChance(EquipmentSlot.MAINHAND, Config.getInstance().mobInstrumentDropFactor);
            }
        }
    }

    public static boolean shouldEquip(Entity entity) {
        String id = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString();
        return Config.getInstance().mobInstrumentFactors.containsKey(id) && entity.level().getRandom().nextFloat() < Config.getInstance().mobInstrumentFactors.get(id).floatValue();
    }

    public static boolean canPickUp(Entity entity) {
        String id = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString();
        return Config.getInstance().mobInstrumentFactors.containsKey(id) && Config.getInstance().mobInstrumentFactors.get(id).floatValue() > 0.0f;
    }
}

