/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.resources;

import immersive_melodies.network.Network;
import immersive_melodies.network.c2s.MelodyRequest;
import immersive_melodies.resources.Melody;
import immersive_melodies.resources.MelodyDescriptor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class ClientMelodyManager {
    static final Map<ResourceLocation, Melody> melodies = new HashMap<ResourceLocation, Melody>();
    static final Map<ResourceLocation, MelodyDescriptor> melodiesList = new HashMap<ResourceLocation, MelodyDescriptor>();
    static final Set<ResourceLocation> requested = new HashSet<ResourceLocation>();

    public static Map<ResourceLocation, MelodyDescriptor> getMelodiesList() {
        return melodiesList;
    }

    public static Melody getMelody(ResourceLocation identifier) {
        if (!melodies.containsKey(identifier) && !requested.contains(identifier)) {
            Network.sendToServer(new MelodyRequest(identifier));
            requested.add(identifier);
        }
        return melodies.getOrDefault(identifier, Melody.DEFAULT);
    }

    public static void setMelody(ResourceLocation identifier, Melody melody) {
        melodies.put(identifier, melody);
    }
}

