/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.network;

import immersive_melodies.network.ImmersivePayload;
import immersive_melodies.resources.Melody;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public interface FragmentedMessage
extends ImmersivePayload {
    public static final Map<String, Queue<byte[]>> buffer = new ConcurrentHashMap<String, Queue<byte[]>>();

    public String name();

    public byte[] fragment();

    public int length();

    @Override
    default public void handle(Player e) {
        String identifier = this.getClass().getSimpleName() + ":" + (e == null ? "local" : e.getStringUUID()) + ":" + this.name();
        Queue byteBuffer = buffer.computeIfAbsent(identifier, k -> new ConcurrentLinkedQueue());
        byteBuffer.add(this.fragment());
        if (byteBuffer.stream().mapToInt(f -> ((byte[])f).length).sum() >= this.length()) {
            FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
            for (byte[] b : byteBuffer) {
                buffer.writeBytes(b);
            }
            this.finish(e, this.name(), (Melody)Melody.STREAM_CODEC.decode((Object)buffer));
            FragmentedMessage.buffer.remove(identifier);
        }
    }

    public void finish(Player var1, String var2, Melody var3);
}

