/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;
import vectorwing.farmersdelight.common.block.state.CanvasSign;

public class HangingCanvasSignEditScreen
extends AbstractSignEditScreen {
    private static final Vector3f TEXT_SCALE = new Vector3f(0.9f, 0.9f, 0.9f);
    protected DyeColor dye;
    private final ResourceLocation texture;

    public HangingCanvasSignEditScreen(SignBlockEntity signBlockEntity, boolean isFrontText, boolean isTextFilteringEnabled) {
        super(signBlockEntity, isFrontText, isTextFilteringEnabled, (Component)Component.translatable((String)"hanging_sign.edit"));
        Block block = signBlockEntity.getBlockState().getBlock();
        if (block instanceof CanvasSign) {
            CanvasSign canvasSign = (CanvasSign)block;
            this.dye = canvasSign.getBackgroundColor();
        }
        String dyeName = this.dye != null ? "_" + this.dye.getName() : "";
        this.texture = ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)("canvas" + dyeName + ".png")).withPrefix("textures/gui/hanging_signs/");
    }

    protected void offsetSign(GuiGraphics gui, BlockState state) {
        gui.pose().translate((float)this.width / 2.0f, 125.0f, 50.0f);
    }

    protected void renderSignBackground(GuiGraphics gui, BlockState p_250054_) {
        gui.pose().translate(0.0f, -13.0f, 0.0f);
        gui.pose().scale(4.5f, 4.5f, 1.0f);
        gui.blit(this.texture, -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
    }

    protected Vector3f getSignTextScale() {
        return TEXT_SCALE;
    }
}

