/*
 * Decompiled with CFR 0.152.
 */
package fuzs.helditemtooltips.client.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.helditemtooltips.HeldItemTooltips;
import fuzs.helditemtooltips.client.gui.screens.inventory.tooltip.HoverTextManager;
import fuzs.helditemtooltips.config.ClientConfig;
import fuzs.helditemtooltips.mixin.client.accessor.GuiAccessor;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SelectedItemHandler {
    public static final SelectedItemHandler INSTANCE = new SelectedItemHandler();
    private int remainingHighlightTicks;
    private ItemStack highlightingItemStack = ItemStack.EMPTY;
    private int highlightingHotbarSlot = -1;
    private int maxLines;

    public void onEndClientTick(Minecraft minecraft) {
        if (minecraft.player == null || minecraft.isPaused()) {
            return;
        }
        ItemStack itemStack = minecraft.player.getInventory().getSelected();
        int selected = minecraft.player.getInventory().selected;
        if (!this.highlightingItemStack.isEmpty() && ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)this.highlightingItemStack) && itemStack.getHoverName().equals((Object)this.highlightingItemStack.getHoverName()) && selected == this.highlightingHotbarSlot) {
            if (this.highlightingItemStack != itemStack) {
                this.highlightingItemStack = itemStack;
                HoverTextManager.reset();
            }
            if (this.remainingHighlightTicks > 0) {
                --this.remainingHighlightTicks;
            }
        } else {
            this.highlightingItemStack = itemStack;
            this.highlightingHotbarSlot = selected;
            if (this.highlightingItemStack.isEmpty()) {
                this.remainingHighlightTicks = 0;
            } else {
                this.remainingHighlightTicks = ((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).displayTime;
                HoverTextManager.reset();
            }
        }
    }

    public EventResult onBeforeRenderGuiLayer(Minecraft minecraft, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        int alpha;
        if (this.highlightingItemStack.isEmpty()) {
            return EventResult.INTERRUPT;
        }
        minecraft.getProfiler().push("selectedItemName");
        int n = alpha = ((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).displayTime == 0 ? 255 : (int)Math.min(255.0f, (float)this.remainingHighlightTicks * 255.0f / 10.0f);
        if (alpha <= 0) {
            return EventResult.INTERRUPT;
        }
        List<Component> lines = this.getTooltipLines(minecraft);
        float currentScale = (float)((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).displayScale / 6.0f;
        int posX = this.getPosX(currentScale, guiGraphics.guiWidth());
        int posY = this.getPosY(currentScale, guiGraphics.guiHeight(), lines.size(), minecraft);
        Font font = minecraft.font;
        guiGraphics.pose().pushPose();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.pose().scale(currentScale, currentScale, 1.0f);
        this.drawBackground(guiGraphics, posX, posY, alpha, lines, minecraft);
        for (int i = 0; i < lines.size(); ++i) {
            int n2;
            Component component = lines.get(i);
            guiGraphics.drawCenteredString(font, component, posX, posY, 0xFFFFFF + (alpha << 24));
            if (i == 0) {
                Objects.requireNonNull(font);
                n2 = 9 + 3;
            } else {
                Objects.requireNonNull(font);
                n2 = 9 + 1;
            }
            posY += n2;
        }
        guiGraphics.pose().scale(1.0f / currentScale, 1.0f / currentScale, 1.0f);
        RenderSystem.disableBlend();
        guiGraphics.pose().popPose();
        minecraft.getProfiler().pop();
        return EventResult.INTERRUPT;
    }

    private int getPosX(float currentScale, int screenWidth) {
        int posX = (int)((float)screenWidth / (2.0f * currentScale));
        return posX += ((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).offsetX;
    }

    private int getPosY(float currentScale, int screenHeight, int allLines, Minecraft minecraft) {
        int posY = (int)((float)screenHeight / currentScale);
        posY = (int)((float)posY - (float)((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).offsetY / currentScale);
        if (!minecraft.gameMode.canHurtPlayer()) {
            posY += 14;
        }
        return posY -= allLines > 1 ? (allLines - 1) * 10 + 2 : (allLines - 1) * 10;
    }

    private List<Component> getTooltipLines(Minecraft minecraft) {
        int maxLines;
        ClientConfig clientConfig = (ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class);
        if (clientConfig.itemBlacklist.contains((Object)this.highlightingItemStack.getItem()) || clientConfig.respectHiddenTooltip && this.highlightingItemStack.has(DataComponents.HIDE_TOOLTIP)) {
            maxLines = 1;
        } else {
            int overlayMessageTime = ((GuiAccessor)minecraft.gui).helditemtooltips$getOverlayMessageTime();
            int n = overlayMessageTime > 0 ? (minecraft.gameMode.canHurtPlayer() ? 1 : 2) : (maxLines = clientConfig.maxLines);
        }
        if ((clientConfig.displayTime - this.remainingHighlightTicks) % clientConfig.updateInterval == 0 || this.maxLines != maxLines) {
            HoverTextManager.reset();
        }
        this.maxLines = maxLines;
        return HoverTextManager.getTooltipLines(this.highlightingItemStack, (Level)minecraft.level, this.maxLines);
    }

    private void drawBackground(GuiGraphics guiGraphics, int posX, int posY, int alpha, List<Component> lines, Minecraft minecraft) {
        ClientConfig.HoverTextBackground background = ((ClientConfig)HeldItemTooltips.CONFIG.get(ClientConfig.class)).background;
        Font font = minecraft.font;
        alpha = (int)((double)alpha * (Double)minecraft.options.textBackgroundOpacity().get());
        if (background == ClientConfig.HoverTextBackground.RECTANGLE) {
            int maximumWidth = lines.stream().mapToInt(arg_0 -> ((Font)font).width(arg_0)).max().orElse(0) / 2;
            int size = lines.size();
            Objects.requireNonNull(font);
            guiGraphics.fill(posX - maximumWidth - 2, posY - 2, posX + maximumWidth + 2, posY + size * (9 + 1) + (size > 1 ? 1 : -1) + 2, alpha << 24);
        } else if (background == ClientConfig.HoverTextBackground.ADAPTIVE) {
            for (int i = 0; i < lines.size(); ++i) {
                int n;
                int top;
                int previousWidth = SelectedItemHandler.textWidth(font, lines, i - 1) / 2;
                int currentWidth = SelectedItemHandler.textWidth(font, lines, i) / 2;
                int nextWidth = SelectedItemHandler.textWidth(font, lines, i + 1) / 2;
                int n2 = currentWidth < previousWidth ? (i == 1 ? 1 : -1) : (top = 2);
                int bottom = currentWidth <= nextWidth ? (i == 0 ? 1 : -1) : 2;
                Objects.requireNonNull(font);
                guiGraphics.fill(posX - currentWidth - 2, posY - top, posX + currentWidth + 2, posY + 9 + bottom, alpha << 24);
                if (i == 0) {
                    Objects.requireNonNull(font);
                    n = 9 + 3;
                } else {
                    Objects.requireNonNull(font);
                    n = 9 + 1;
                }
                posY += n;
            }
        }
    }

    private static int textWidth(Font font, List<Component> lines, int index) {
        int clampedIndex = Mth.clamp((int)index, (int)0, (int)(lines.size() - 1));
        return clampedIndex == index ? font.width((FormattedText)lines.get(index)) : 0;
    }
}

