/*
 * Decompiled with CFR 0.152.
 */
package fuzs.helditemtooltips.client.gui.screens.inventory.tooltip;

import fuzs.helditemtooltips.client.gui.screens.inventory.tooltip.TooltipComponent;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.jetbrains.annotations.Nullable;

public final class AttributeTooltipComponent
implements TooltipComponent {
    @Override
    public void addToTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltipLines, TooltipFlag tooltipFlag) {
        Minecraft minecraft = Minecraft.getInstance();
        this.addAttributeTooltips(itemStack, tooltipLines::add, (Player)minecraft.player);
    }

    private void addAttributeTooltips(ItemStack itemStack, Consumer<Component> tooltipAdder, @Nullable Player player) {
        ItemAttributeModifiers itemAttributeModifiers = (ItemAttributeModifiers)itemStack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
        if (itemAttributeModifiers.showInTooltip()) {
            for (EquipmentSlotGroup equipmentSlotGroup : EquipmentSlotGroup.values()) {
                itemStack.forEachModifier(equipmentSlotGroup, (holder, attributeModifier) -> this.addModifierTooltip(tooltipAdder, player, (Holder<Attribute>)holder, (AttributeModifier)attributeModifier));
            }
        }
    }

    private void addModifierTooltip(Consumer<Component> tooltipAdder, @Nullable Player player, Holder<Attribute> attribute, AttributeModifier modifier) {
        double modifierAmount = modifier.amount();
        if (player != null) {
            if (modifier.is(Item.BASE_ATTACK_DAMAGE_ID)) {
                modifierAmount += player.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
            } else if (modifier.is(Item.BASE_ATTACK_SPEED_ID)) {
                modifierAmount += player.getAttributeBaseValue(Attributes.ATTACK_SPEED);
            }
        }
        double scaledModifierAmount = modifier.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE || modifier.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? modifierAmount * 100.0 : (attribute.is(Attributes.KNOCKBACK_RESISTANCE) ? modifierAmount * 10.0 : modifierAmount);
        if (modifierAmount > 0.0) {
            tooltipAdder.accept((Component)Component.translatable((String)("attribute.modifier.plus." + modifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(scaledModifierAmount), Component.translatable((String)((Attribute)attribute.value()).getDescriptionId())}).withStyle(((Attribute)attribute.value()).getStyle(true)));
        } else if (modifierAmount < 0.0) {
            tooltipAdder.accept((Component)Component.translatable((String)("attribute.modifier.take." + modifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(-scaledModifierAmount), Component.translatable((String)((Attribute)attribute.value()).getDescriptionId())}).withStyle(((Attribute)attribute.value()).getStyle(false)));
        }
    }
}

