/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class ScreenBase
extends Screen {
    public static final int FONT_COLOR = 0x404040;
    protected ResourceLocation texture;
    protected int guiLeft;
    protected int guiTop;
    protected int xSize;
    protected int ySize;

    protected ScreenBase(Component title) {
        super(title);
    }

    protected void init() {
        super.init();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(this.texture, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void drawCenteredString(GuiGraphics guiGraphics, Component text, int x, int y, int color) {
        guiGraphics.drawString(this.font, text, x - this.font.width((FormattedText)text) / 2, y, color, false);
    }
}

