/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.corelib.death.DeathManager;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseAdditionalItemsContainerProvider;
import de.maxhenkel.corpse.gui.CorpseContainerProvider;
import de.maxhenkel.corpse.gui.CorpseInventoryContainer;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;

public class Guis {
    public static void openAdditionalItems(ServerPlayer player, CorpseInventoryContainer container) {
        Guis.openAdditionalItems(player, container.getCorpse(), container.isEditable(), container.isHistory());
    }

    public static void openAdditionalItems(ServerPlayer player, CorpseEntity corpse, boolean editable, boolean history) {
        player.openMenu((MenuProvider)new CorpseAdditionalItemsContainerProvider(corpse, editable, history), packetBuffer -> {
            packetBuffer.writeBoolean(history);
            packetBuffer.writeBoolean(corpse.isAdditionalInventoryEmpty());
            if (history) {
                packetBuffer.writeNbt((Tag)corpse.getDeath().toNBT((HolderLookup.Provider)corpse.registryAccess(), false));
            } else {
                packetBuffer.writeUUID(corpse.getUUID());
            }
        });
    }

    public static void openCorpseGUI(ServerPlayer player, CorpseEntity corpse, boolean editable, boolean history) {
        if (corpse.isMainInventoryEmpty() && !corpse.isEmpty()) {
            Guis.openAdditionalItems(player, corpse, editable, history);
        } else {
            player.openMenu((MenuProvider)new CorpseContainerProvider(corpse, editable, history), packetBuffer -> {
                packetBuffer.writeBoolean(history);
                packetBuffer.writeBoolean(corpse.isAdditionalInventoryEmpty());
                if (history) {
                    packetBuffer.writeNbt((Tag)corpse.getDeath().toNBT((HolderLookup.Provider)corpse.registryAccess(), false));
                } else {
                    packetBuffer.writeUUID(corpse.getUUID());
                }
            });
        }
    }

    public static void openCorpseGUI(ServerPlayer player, CorpseEntity corpse) {
        Guis.openCorpseGUI(player, corpse, true, false);
    }

    public static void openCorpseGUI(ServerPlayer playerToShow, UUID player, UUID uuid) {
        Death death = DeathManager.getDeath(playerToShow.serverLevel(), player, uuid);
        if (death == null) {
            return;
        }
        CorpseEntity corpse = CorpseEntity.createFromDeath((Player)playerToShow, death);
        Guis.openCorpseGUI(playerToShow, corpse, playerToShow.getAbilities().instabuild, true);
    }
}

