/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumoptionsapi.mixin.sodium;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import net.caffeinemc.mods.sodium.client.gui.options.OptionGroup;
import net.caffeinemc.mods.sodium.client.gui.options.OptionPage;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import toni.sodiumoptionsapi.SodiumOptionsAPI;
import toni.sodiumoptionsapi.api.OptionIdentifier;
import toni.sodiumoptionsapi.api.OptionPageConstruction;
import toni.sodiumoptionsapi.util.IOptionGroupIdAccessor;
import toni.sodiumoptionsapi.util.OptionIdGenerator;

@Mixin(value={OptionPage.class})
public class OptionPageMixin
implements IOptionGroupIdAccessor {
    @Unique
    private static final OptionIdentifier<Void> sodiumOptionsAPI$DEFAULT_ID = OptionIdentifier.create("sodium", "empty");
    @Unique
    private OptionIdentifier<Void> sodiumOptionsAPI$id;
    @Mutable
    @Shadow
    @Final
    private ImmutableList<OptionGroup> groups;
    @Shadow
    @Final
    private Component name;

    @Inject(method={"<init>(Lnet/minecraft/network/chat/Component;Lcom/google/common/collect/ImmutableList;)V"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableList;builder()Lcom/google/common/collect/ImmutableList$Builder;")})
    public void onInit(Component name, ImmutableList<OptionGroup> groups, CallbackInfo ci) {
        this.groups = this.sodiumOptionsAPI$collectExtraGroups(groups);
        this.sodiumOptionsAPI$id = OptionPageMixin.sodiumOptionsAPI$tryMakeId(name);
    }

    @Unique
    private ImmutableList<OptionGroup> sodiumOptionsAPI$collectExtraGroups(ImmutableList<OptionGroup> groups) {
        ArrayList<OptionGroup> extraGroups = new ArrayList<OptionGroup>();
        ((OptionPageConstruction)OptionPageConstruction.EVENT.invoker()).onPageConstruction(this.sodiumOptionsAPI$id, this.name, extraGroups);
        return extraGroups.isEmpty() ? groups : ImmutableList.builder().addAll(groups).addAll(extraGroups).build();
    }

    @Override
    public OptionIdentifier<Void> sodiumOptionsAPI$getId() {
        if (this.sodiumOptionsAPI$id == null) {
            return sodiumOptionsAPI$DEFAULT_ID;
        }
        return this.sodiumOptionsAPI$id;
    }

    @Override
    public void sodiumOptionsAPI$setId(OptionIdentifier<Void> id) {
        this.sodiumOptionsAPI$id = id;
    }

    @Override
    public void sodiumOptionsAPI$setId(ResourceLocation id) {
        this.sodiumOptionsAPI$id = OptionIdentifier.create(id);
    }

    @Unique
    private static OptionIdentifier<Void> sodiumOptionsAPI$tryMakeId(Component name) {
        OptionIdentifier<Void> id;
        ComponentContents componentContents = name.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)componentContents;
            String key = translatableContents.getKey();
            id = name.getSiblings().isEmpty() ? OptionIdGenerator.generateId(key) : OptionIdGenerator.generateId(key);
        } else {
            id = OptionIdGenerator.generateId(name.getString());
        }
        if (id != null) {
            SodiumOptionsAPI.LOGGER.debug("Guessed ID for legacy OptionPage: '{}': {}", (Object)name.getString(), id);
            return id;
        }
        SodiumOptionsAPI.LOGGER.warn("Id must be specified in OptionPage: '{}'", (Object)name.getString());
        return sodiumOptionsAPI$DEFAULT_ID;
    }
}

