/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.kineticbridge;

import com.hlysine.create_connected.CCBlockEntityTypes;
import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.content.kineticbridge.KineticBridgeBlock;
import com.hlysine.create_connected.content.kineticbridge.KineticBridgeDestinationBlockEntity;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class KineticBridgeDestinationBlock
extends DirectionalKineticBlock
implements IBE<KineticBridgeDestinationBlockEntity> {
    public KineticBridgeDestinationBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public Direction getPreferredFacing(BlockPlaceContext context) {
        for (Direction side : Iterate.directions) {
            BlockState blockState = context.getLevel().getBlockState(context.getClickedPos().relative(side));
            if (!(blockState.getBlock() instanceof KineticBridgeBlock) || blockState.getValue((Property)FACING) != side.getOpposite()) continue;
            return side.getOpposite();
        }
        return null;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState stateForPlacement = super.getStateForPlacement(context);
        if (stateForPlacement == null) {
            return null;
        }
        Direction preferredFacing = this.getPreferredFacing(context);
        if (preferredFacing == null) {
            return null;
        }
        return (BlockState)stateForPlacement.setValue((Property)FACING, (Comparable)preferredFacing);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.PASS;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return CCBlocks.KINETIC_BRIDGE.asStack();
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        BlockPos clickedPos = context.getClickedPos();
        Level level = context.getLevel();
        if (this.stillValid((BlockGetter)level, clickedPos, state)) {
            BlockPos sourcePos = KineticBridgeDestinationBlock.getSource(clickedPos, state);
            if (!context.getLevel().getBlockState(sourcePos).is((Block)CCBlocks.KINETIC_BRIDGE.get())) {
                return super.onSneakWrenched(state, context);
            }
            context = new UseOnContext(level, context.getPlayer(), context.getHand(), context.getItemInHand(), new BlockHitResult(context.getClickLocation(), context.getClickedFace(), sourcePos, context.isInside()));
            state = level.getBlockState(sourcePos);
        }
        return super.onSneakWrenched(state, context);
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (this.stillValid((BlockGetter)pLevel, pPos, pState)) {
            BlockPos sourcePos = KineticBridgeDestinationBlock.getSource(pPos, pState);
            if (!pLevel.getBlockState(sourcePos).is((Block)CCBlocks.KINETIC_BRIDGE.get())) {
                return;
            }
            pLevel.destroyBlock(sourcePos, true);
        }
    }

    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (this.stillValid((BlockGetter)pLevel, pPos, pState)) {
            BlockPos sourcePos = KineticBridgeDestinationBlock.getSource(pPos, pState);
            if (!pLevel.getBlockState(sourcePos).is((Block)CCBlocks.KINETIC_BRIDGE.get())) {
                return super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
            }
            pLevel.destroyBlockProgress(sourcePos.hashCode(), sourcePos, -1);
            if (!pLevel.isClientSide() && pPlayer.isCreative()) {
                pLevel.destroyBlock(sourcePos, false);
            }
        }
        return super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        Level level;
        if (this.stillValid((BlockGetter)pLevel, pCurrentPos, pState)) {
            BlockPos sourcePos = KineticBridgeDestinationBlock.getSource(pCurrentPos, pState);
            if (pLevel.getBlockState(sourcePos).is((Block)CCBlocks.KINETIC_BRIDGE.get()) && !pLevel.getBlockTicks().hasScheduledTick(sourcePos, (Object)((Block)CCBlocks.KINETIC_BRIDGE.get()))) {
                pLevel.scheduleTick(sourcePos, (Block)CCBlocks.KINETIC_BRIDGE.get(), 1);
            }
            return pState;
        }
        if (!(pLevel instanceof Level) || (level = (Level)pLevel).isClientSide()) {
            return pState;
        }
        if (!level.getBlockTicks().hasScheduledTick(pCurrentPos, (Object)this)) {
            level.scheduleTick(pCurrentPos, (Block)this, 1);
        }
        return pState;
    }

    public static BlockPos getSource(BlockPos pos, BlockState state) {
        Direction direction = state.getOptionalValue((Property)FACING).orElse(Direction.NORTH);
        return pos.relative(direction.getOpposite());
    }

    public boolean stillValid(BlockGetter level, BlockPos pos, BlockState state) {
        if (!state.is((Block)this)) {
            return false;
        }
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos sourcePos = pos.relative(direction.getOpposite());
        BlockState sourceState = level.getBlockState(sourcePos);
        return sourceState.getBlock() instanceof KineticBridgeBlock && sourceState.getValue((Property)KineticBridgeBlock.FACING) == direction;
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!this.stillValid((BlockGetter)pLevel, pPos, pState)) {
            pLevel.setBlockAndUpdate(pPos, Blocks.AIR.defaultBlockState());
        }
    }

    public BlockEntityType<? extends KineticBridgeDestinationBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CCBlockEntityTypes.KINETIC_BRIDGE_DESTINATION.get();
    }

    public Class<KineticBridgeDestinationBlockEntity> getBlockEntityClass() {
        return KineticBridgeDestinationBlockEntity.class;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == state.getValue((Property)FACING);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue((Property)FACING)).getAxis();
    }
}

