/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.attributefilter;

import com.hlysine.create_connected.CCItemAttributes;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record ItemIdAttribute(String word) implements ItemAttribute
{
    public static final MapCodec<ItemIdAttribute> CODEC = Codec.STRING.xmap(ItemIdAttribute::new, ItemIdAttribute::word).fieldOf("value");
    public static final StreamCodec<ByteBuf, ItemIdAttribute> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(ItemIdAttribute::new, ItemIdAttribute::word);

    public boolean appliesTo(ItemStack stack, Level world) {
        return stack.getItem().toString().contains(this.word);
    }

    public ItemAttributeType getType() {
        return CCItemAttributes.ID_CONTAINS;
    }

    public String getTranslationKey() {
        return "id_contains";
    }

    public Object[] getTranslationParameters() {
        return new Object[]{this.word};
    }

    public static class Type
    implements ItemAttributeType {
        @NotNull
        public ItemAttribute createAttribute() {
            return new ItemIdAttribute("dummy");
        }

        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            String[] words = stack.getItem().toString().split("[_:]");
            ArrayList<ItemAttribute> attributes = new ArrayList<ItemAttribute>();
            for (String word : words) {
                if (word.length() <= 2) continue;
                attributes.add(new ItemIdAttribute(word));
            }
            return attributes;
        }

        public MapCodec<? extends ItemAttribute> codec() {
            return CODEC;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, ? extends ItemAttribute> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

