/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.config.gui.modules;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import me.cominixo.betterf3.config.gui.modules.ModulesScreen;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.modules.CoordsModule;
import me.cominixo.betterf3.modules.FpsModule;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ModuleListWidget
extends ObjectSelectionList<ModuleEntry> {
    final ModulesScreen modulesScreen;
    final List<ModuleEntry> moduleEntries = new ArrayList<ModuleEntry>();

    public ModuleListWidget(ModulesScreen modulesScreen, Minecraft client, int width, int height, int y, int itemHeight) {
        super(client, width, height, y, itemHeight);
        this.modulesScreen = modulesScreen;
    }

    protected int scrollbarPositionX() {
        return super.getScrollbarPosition() + 30;
    }

    public int rowWidth() {
        return super.getRowWidth() + 85;
    }

    public ModuleEntry entry(int index) {
        return this.moduleEntries.get(index);
    }

    public void modules(List<BaseModule> modules) {
        this.moduleEntries.clear();
        this.clearEntries();
        for (BaseModule module : modules) {
            this.addModule(module);
        }
    }

    public void updateModules() {
        this.clearEntries();
        this.moduleEntries.forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
    }

    public void addModule(BaseModule module) {
        ModuleEntry entry = new ModuleEntry(this.modulesScreen, module);
        this.moduleEntries.add(entry);
        this.addEntry((AbstractSelectionList.Entry)entry);
    }

    public void removeModule(int index) {
        ModuleEntry entry = this.moduleEntries.get(index);
        this.moduleEntries.remove((Object)entry);
        this.removeEntry((AbstractSelectionList.Entry)entry);
        this.modulesScreen.updateButtons();
        if (this.getScrollAmount() > (double)this.getMaxScroll()) {
            this.setScrollAmount(this.getMaxScroll());
        }
    }

    public class ModuleEntry
    extends ObjectSelectionList.Entry<ModuleEntry> {
        private final ModulesScreen modulesScreen;
        private final Minecraft client;
        public final BaseModule module;

        protected ModuleEntry(ModulesScreen modulesScreen, BaseModule module) {
            this.modulesScreen = modulesScreen;
            this.module = module;
            this.client = Minecraft.getInstance();
        }

        public Component getNarration() {
            return Component.nullToEmpty((String)this.module.toString());
        }

        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Object exampleText;
            context.drawString(this.client.font, this.module.toString(), x + 35, y + 1, 0xFFFFFF, true);
            BaseModule baseModule = this.module;
            if (baseModule instanceof CoordsModule) {
                CoordsModule coordsModule = (CoordsModule)baseModule;
                exampleText = Utils.styledText("X", coordsModule.colorX).append((Component)Utils.styledText("Y", coordsModule.colorY)).append((Component)Utils.styledText("Z", coordsModule.colorZ)).append((Component)Utils.styledText(": ", coordsModule.nameColor)).append((Component)Utils.styledText("100 ", coordsModule.colorX).append((Component)Utils.styledText("200 ", coordsModule.colorY)).append((Component)Utils.styledText("300", coordsModule.colorZ)));
            } else {
                baseModule = this.module;
                if (baseModule instanceof FpsModule) {
                    FpsModule fpsModule = (FpsModule)baseModule;
                    exampleText = Utils.styledText("60 fps  ", fpsModule.colorHigh).append((Component)Utils.styledText("40 fps  ", fpsModule.colorMed)).append((Component)Utils.styledText("10 fps", fpsModule.colorLow));
                } else {
                    exampleText = this.module.nameColor != null && this.module.valueColor != null ? Utils.styledText("Name: ", this.module.nameColor).append((Component)Utils.styledText("Value", this.module.valueColor)) : Component.nullToEmpty((String)"");
                }
            }
            context.drawString(this.client.font, exampleText, x + 43, y + 13, 0xFFFFFF, true);
            if (((Boolean)this.client.options.touchscreen().get()).booleanValue() || hovered) {
                context.fill(x, y, x + 32, y + 32, -1601138544);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int v = mouseX - x;
                int w = mouseY - y;
                if (index > 0) {
                    if (v < 16 && w < 16) {
                        context.blitSprite(ResourceLocation.parse((String)"server_list/move_up_highlighted"), x, y, 32, 32);
                    } else {
                        context.blitSprite(ResourceLocation.parse((String)"server_list/move_up"), x, y, 32, 32);
                    }
                }
                if (index < ModuleListWidget.this.moduleEntries.size() - 1) {
                    if (v < 16 && w > 16) {
                        context.blitSprite(ResourceLocation.parse((String)"server_list/move_down_highlighted"), x, y, 32, 32);
                    } else {
                        context.blitSprite(ResourceLocation.parse((String)"server_list/move_down"), x, y, 32, 32);
                    }
                }
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            double d = mouseX - (double)this.modulesScreen.modulesListWidget.getRowLeft();
            double e = mouseY - (double)ModuleListWidget.this.getRowTop(ModuleListWidget.this.children().indexOf((Object)this));
            if (d <= 32.0) {
                int i = this.modulesScreen.modulesListWidget.children().indexOf((Object)this);
                if (d < 16.0 && e < 16.0 && i > 0) {
                    this.swapEntries(i, i - 1);
                    return true;
                }
                if (d < 16.0 && e > 16.0 && i < ModuleListWidget.this.moduleEntries.size() - 1) {
                    this.swapEntries(i, i + 1);
                    return true;
                }
            }
            this.modulesScreen.select(this);
            return false;
        }

        private void swapEntries(int i, int j) {
            ModuleEntry temp = ModuleListWidget.this.moduleEntries.get(i);
            ModuleListWidget.this.moduleEntries.set(i, ModuleListWidget.this.moduleEntries.get(j));
            ModuleListWidget.this.moduleEntries.set(j, temp);
            this.modulesScreen.modulesListWidget.setSelected((AbstractSelectionList.Entry)temp);
            this.modulesScreen.updateButtons();
            this.modulesScreen.modulesListWidget.updateModules();
        }
    }
}

