/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import snownee.jade.gui.config.OptionsList;

public class OptionsNav
extends ObjectSelectionList<Entry> {
    private final OptionsList options;
    private int current;

    public OptionsNav(OptionsList options, int width, int height, int top, int itemHeight) {
        super(Minecraft.getInstance(), width, height, top, itemHeight);
        this.options = options;
    }

    protected void renderListItems(GuiGraphics guiGraphics, int i, int j, float f) {
        super.renderListItems(guiGraphics, i, j, f);
        if (this.children().isEmpty()) {
            return;
        }
        Entry focused = (Entry)this.getFocused();
        if (focused != null && this.minecraft.getLastInputType().isKeyboard()) {
            this.current = this.children().indexOf((Object)focused);
        }
        double top = (double)(this.getY() + 4) - this.getScrollAmount() + (double)(this.current * this.itemHeight) + (double)this.headerHeight;
        int left = this.getRowLeft() + 2;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0, top, 0.0);
        guiGraphics.fill(left, 0, left + 2, this.itemHeight - 4, -1);
        guiGraphics.pose().popPose();
    }

    protected void renderListSeparators(GuiGraphics guiGraphics) {
    }

    protected void renderSelection(GuiGraphics guiGraphics, int i, int j, int k, int l, int m) {
    }

    public void addEntry(OptionsList.Title entry) {
        super.addEntry((AbstractSelectionList.Entry)new Entry(this, entry));
    }

    public int getRowWidth() {
        return this.width;
    }

    protected int getScrollbarPosition() {
        return this.getRowLeft() + this.getRowWidth() - 8;
    }

    public void refresh() {
        this.clearEntries();
        if (this.options.children().size() <= 1) {
            return;
        }
        for (OptionsList.Entry child : this.options.children()) {
            if (!(child instanceof OptionsList.Title)) continue;
            OptionsList.Title titleEntry = (OptionsList.Title)child;
            this.addEntry(titleEntry);
        }
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent event) {
        FocusNavigationEvent.ArrowNavigation nav;
        if (!this.isFocused() && event instanceof FocusNavigationEvent.ArrowNavigation && (nav = (FocusNavigationEvent.ArrowNavigation)event).direction() == ScreenDirection.LEFT) {
            for (Entry entry : this.children()) {
                if (entry.title != this.options.currentTitle) continue;
                return ComponentPath.path((GuiEventListener)entry, (ContainerEventHandler[])new ContainerEventHandler[]{this});
            }
        }
        return super.nextFocusPath(event);
    }

    public void setFocused(@Nullable GuiEventListener listener) {
        AbstractSelectionList.Entry entry;
        super.setFocused(listener);
        if (this.minecraft.getLastInputType().isKeyboard() && (entry = this.getFocused()) instanceof Entry) {
            Entry entry2 = (Entry)entry;
            this.options.showOnTop(entry2.title);
        }
    }

    public static class Entry
    extends ObjectSelectionList.Entry<Entry> {
        private final OptionsList.Title title;
        private final OptionsNav parent;

        public Entry(OptionsNav parent, OptionsList.Title title) {
            this.parent = parent;
            this.title = title;
        }

        public void render(GuiGraphics guiGraphics, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            Font font = this.title.client.font;
            String string = this.title.getTitle().getString();
            int n = rowTop + height / 2;
            Objects.requireNonNull(this.title.client.font);
            guiGraphics.drawString(font, string, rowLeft + 10, n - 9 / 2, 0xFFFFFF);
            if (this.isFocused() && this.parent.minecraft.getLastInputType().isKeyboard()) {
                int color = -5592406;
                int left = rowLeft + 2;
                int right = rowLeft + width - 2;
                int bottom = rowTop + height;
                guiGraphics.fill(left, rowTop, right, rowTop + 1, color);
                guiGraphics.fill(left, bottom, right, bottom - 1, color);
                guiGraphics.fill(left, rowTop, left + 1, bottom, color);
                guiGraphics.fill(right, rowTop, right - 1, bottom, color);
            } else if (this.parent.options.currentTitle == this.title) {
                if (!this.parent.isMouseOver(mouseX, mouseY)) {
                    this.parent.ensureVisible((AbstractSelectionList.Entry)this);
                }
                this.parent.current = index;
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.onPress();
            }
            return true;
        }

        public boolean keyPressed(int i, int j, int k) {
            if (CommonInputs.selected((int)i)) {
                this.onPress();
                return true;
            }
            return false;
        }

        public Component getNarration() {
            return this.title.narration;
        }

        public void onPress() {
            this.parent.playDownSound(Minecraft.getInstance().getSoundManager());
            this.parent.options.showOnTop(this.title);
        }

        public OptionsList.Title getTitle() {
            return this.title;
        }
    }
}

