/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.handrails;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.engine_room.flywheel.lib.visualization.VisualizationHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import rbasamoyai.escalated.handrails.AbstractHandrailBlock;
import rbasamoyai.escalated.platform.EnvExecute;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;

public class HandrailBlockEntity
extends SmartBlockEntity {
    public int width = 1;
    public boolean propagateBreak = true;
    private DyeColor handrailColor = null;

    public HandrailBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public float getSpeed() {
        float f;
        BlockEntity blockEntity;
        if (this.level != null && (blockEntity = this.level.getBlockEntity(this.worldPosition.below())) instanceof WalkwayBlockEntity) {
            WalkwayBlockEntity walkway = (WalkwayBlockEntity)blockEntity;
            f = walkway.getWalkwayMovementSpeed();
        } else {
            f = 0.0f;
        }
        return f;
    }

    public float getVisualProgress() {
        float f;
        BlockEntity blockEntity;
        if (this.level != null && (blockEntity = this.level.getBlockEntity(this.worldPosition.below())) instanceof WalkwayBlockEntity) {
            WalkwayBlockEntity walkway = (WalkwayBlockEntity)blockEntity;
            f = walkway.getVisualProgress();
        } else {
            f = 0.0f;
        }
        return f;
    }

    public boolean setHandrailColor(@Nullable DyeColor colorIn) {
        Direction offsetDir;
        BlockEntity blockEntity;
        if (colorIn == this.handrailColor) {
            return false;
        }
        if (this.level.isClientSide) {
            return true;
        }
        int MAX_ITER = 1100;
        Direction facing = (Direction)this.getBlockState().getValue((Property)AbstractHandrailBlock.FACING);
        Direction left = facing.getCounterClockWise();
        AbstractHandrailBlock.Side side = (AbstractHandrailBlock.Side)((Object)this.getBlockState().getValue(AbstractHandrailBlock.SIDE));
        this.handrailColor = colorIn;
        this.notifyUpdate();
        BlockPos offset = BlockPos.ZERO;
        if (this.width > 1 && (blockEntity = this.level.getBlockEntity(this.worldPosition.offset((Vec3i)(offset = BlockPos.ZERO.relative(offsetDir = side == AbstractHandrailBlock.Side.LEFT ? left.getOpposite() : left, this.width - 1))))) instanceof HandrailBlockEntity) {
            HandrailBlockEntity other = (HandrailBlockEntity)blockEntity;
            other.handrailColor = colorIn;
            other.notifyUpdate();
        }
        for (boolean forward : Iterate.trueAndFalse) {
            BlockPos iterPos = this.worldPosition;
            BlockState iterState = this.getBlockState();
            for (int i = 0; i < MAX_ITER && (iterPos = AbstractHandrailBlock.nextSegmentPosition(iterState, iterPos, forward)) != null && (iterState = this.level.getBlockState(iterPos)).getBlock() instanceof AbstractHandrailBlock; ++i) {
                HandrailBlockEntity other;
                BlockEntity blockEntity2 = this.level.getBlockEntity(iterPos);
                if (blockEntity2 instanceof HandrailBlockEntity) {
                    other = (HandrailBlockEntity)blockEntity2;
                    other.handrailColor = colorIn;
                    other.notifyUpdate();
                }
                if (this.width <= 1 || !((blockEntity2 = this.level.getBlockEntity(iterPos.offset((Vec3i)offset))) instanceof HandrailBlockEntity)) continue;
                other = (HandrailBlockEntity)blockEntity2;
                other.handrailColor = colorIn;
                other.notifyUpdate();
            }
        }
        return true;
    }

    @Nullable
    public DyeColor getHandrailColor() {
        return this.handrailColor;
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.width = tag.getInt("Width");
        DyeColor dyeColor = this.handrailColor = tag.contains("Dye", 8) ? (DyeColor)NBTHelper.readEnum((CompoundTag)tag, (String)"Dye", DyeColor.class) : null;
        if (clientPacket) {
            EnvExecute.executeOnClient(() -> () -> VisualizationHelper.queueUpdate((BlockEntity)this));
        }
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.putInt("Width", this.width);
        if (this.handrailColor != null) {
            NBTHelper.writeEnum((CompoundTag)tag, (String)"Dye", (Enum)this.handrailColor);
        }
    }
}

