/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.my_util;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import qouteall.q_misc_util.my_util.Circle;
import qouteall.q_misc_util.my_util.Plane;

public record Sphere(Vec3 center, double radius) {
    @Nullable
    public Vec3 projectToSphere(Vec3 pos) {
        Vec3 delta = pos.subtract(this.center());
        if (delta.lengthSqr() < 0.001) {
            return null;
        }
        return this.center().add(delta.normalize().scale(this.radius()));
    }

    @Nullable
    public Circle getIntersectionWithPlane(Plane plane) {
        double distance = plane.getDistanceTo(this.center());
        if (distance > this.radius()) {
            return null;
        }
        Vec3 circleCenter = plane.getProjection(this.center());
        double newRadius = Math.sqrt(this.radius() * this.radius() - distance * distance);
        return new Circle(plane, circleCenter, newRadius);
    }

    @Nullable
    public Vec3 rayTrace(Vec3 lineOrigin, Vec3 lineVec) {
        double c;
        Vec3 delta = lineOrigin.subtract(this.center());
        double a = lineVec.lengthSqr();
        double b = delta.dot(lineVec) * 2.0;
        double discriminant = b * b - 4.0 * a * (c = delta.lengthSqr() - this.radius() * this.radius());
        if (discriminant < 0.0) {
            return null;
        }
        double sqrtDiscriminant = Math.sqrt(discriminant);
        double t1 = (-b + sqrtDiscriminant) / (2.0 * a);
        double t2 = (-b - sqrtDiscriminant) / (2.0 * a);
        if (t1 < 0.0 && t2 < 0.0) {
            return null;
        }
        if (t1 < 0.0) {
            return lineOrigin.add(lineVec.scale(t2));
        }
        if (t2 < 0.0) {
            return lineOrigin.add(lineVec.scale(t1));
        }
        return lineOrigin.add(lineVec.scale(Math.min(t1, t2)));
    }

    public static Sphere interpolate(Sphere a, Sphere b, double progress) {
        return new Sphere(a.center().lerp(b.center(), progress), Mth.lerp((double)progress, (double)a.radius(), (double)b.radius()));
    }
}

