/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.my_util;

import com.mojang.math.OctahedralGroup;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.DQuaternion;

public class IntMatrix3 {
    public final Vec3i x;
    public final Vec3i y;
    public final Vec3i z;

    public IntMatrix3(Vec3i x, Vec3i y, Vec3i z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public IntMatrix3(OctahedralGroup t) {
        Direction d1 = t.rotate(Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.X, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
        Direction d2 = t.rotate(Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.Y, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
        Direction d3 = t.rotate(Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.Z, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
        this.x = d1.getNormal();
        this.y = d2.getNormal();
        this.z = d3.getNormal();
    }

    public BlockPos transform(Vec3i p) {
        return Helper.scale(this.x, p.getX()).offset((Vec3i)Helper.scale(this.y, p.getY())).offset((Vec3i)Helper.scale(this.z, p.getZ()));
    }

    public IntMatrix3 multiply(IntMatrix3 m) {
        return new IntMatrix3((Vec3i)m.transform(this.x), (Vec3i)m.transform(this.y), (Vec3i)m.transform(this.z));
    }

    public Direction transformDirection(Direction direction) {
        BlockPos vec = this.transform(direction.getNormal());
        return Direction.fromDelta((int)vec.getX(), (int)vec.getY(), (int)vec.getZ());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntMatrix3 that = (IntMatrix3)o;
        return this.x.equals((Object)that.x) && this.y.equals((Object)that.y) && this.z.equals((Object)that.z);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public static IntMatrix3 getIdentity() {
        return new IntMatrix3((Vec3i)new BlockPos(1, 0, 0), (Vec3i)new BlockPos(0, 1, 0), (Vec3i)new BlockPos(0, 0, 1));
    }

    public Matrix3f toMatrix() {
        Matrix3f matrix = new Matrix3f();
        matrix.set(0, 0, (float)this.x.getX());
        matrix.set(0, 1, (float)this.x.getY());
        matrix.set(0, 2, (float)this.x.getZ());
        matrix.set(1, 0, (float)this.y.getX());
        matrix.set(1, 1, (float)this.y.getY());
        matrix.set(1, 2, (float)this.y.getZ());
        matrix.set(2, 0, (float)this.z.getX());
        matrix.set(2, 1, (float)this.z.getY());
        matrix.set(2, 2, (float)this.z.getZ());
        return matrix;
    }

    public DQuaternion toQuaternion() {
        return DQuaternion.matrixToQuaternion(Vec3.atLowerCornerOf((Vec3i)this.x), Vec3.atLowerCornerOf((Vec3i)this.y), Vec3.atLowerCornerOf((Vec3i)this.z));
    }
}

