/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.my_util;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.q_misc_util.Helper;

public class IntBox {
    public final BlockPos l;
    public final BlockPos h;

    public IntBox(BlockPos l, BlockPos h) {
        this.l = Helper.min(l, h);
        this.h = Helper.max(l, h);
    }

    public static IntBox fromBasePointAndSize(BlockPos basePoint, BlockPos areaSize) {
        return new IntBox(basePoint, basePoint.offset((Vec3i)areaSize).offset(-1, -1, -1));
    }

    public static IntBox fromPosAndOffset(BlockPos pos, BlockPos offset) {
        return new IntBox(pos, pos.offset((Vec3i)offset));
    }

    public IntBox expandOrShrink(Vec3i offset) {
        return new IntBox(this.l.subtract(offset), this.h.offset(offset));
    }

    public IntBox getExpanded(Direction.Axis axis, int n) {
        return this.expandOrShrink((Vec3i)Helper.scale(Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).getNormal(), n));
    }

    public IntBox getExpanded(Direction direction, int n) {
        if (direction.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
            return new IntBox(this.l, this.h.offset((Vec3i)Helper.scale(direction.getNormal(), n)));
        }
        return new IntBox(this.l.offset((Vec3i)Helper.scale(direction.getNormal(), n)), this.h);
    }

    public Stream<BlockPos> stream() {
        return IntStream.range(this.l.getX(), this.h.getX() + 1).boxed().flatMap(x -> IntStream.range(this.l.getY(), this.h.getY() + 1).boxed().flatMap(y -> IntStream.range(this.l.getZ(), this.h.getZ() + 1).boxed().map(z -> new BlockPos(x.intValue(), y.intValue(), z.intValue()))));
    }

    public Stream<BlockPos> fastStream() {
        return BlockPos.betweenClosedStream((BlockPos)this.l, (BlockPos)this.h);
    }

    public BlockPos getSize() {
        return this.h.offset(1, 1, 1).subtract((Vec3i)this.l);
    }

    public BlockPos getDiagonalOffset() {
        return this.h.subtract((Vec3i)this.l);
    }

    public IntBox getSurfaceLayer(Direction.Axis axis, Direction.AxisDirection axisDirection) {
        if (axisDirection == Direction.AxisDirection.NEGATIVE) {
            IntBox result = new IntBox(this.l, new BlockPos((axis == Direction.Axis.X ? this.l : this.h).getX(), (axis == Direction.Axis.Y ? this.l : this.h).getY(), (axis == Direction.Axis.Z ? this.l : this.h).getZ()));
            return result;
        }
        IntBox result = new IntBox(new BlockPos((axis == Direction.Axis.X ? this.h : this.l).getX(), (axis == Direction.Axis.Y ? this.h : this.l).getY(), (axis == Direction.Axis.Z ? this.h : this.l).getZ()), this.h);
        return result;
    }

    public IntBox getSurfaceLayer(Direction facing) {
        return this.getSurfaceLayer(facing.getAxis(), facing.getAxisDirection());
    }

    @Nullable
    public static IntBox getIntersect(IntBox a, IntBox b) {
        BlockPos l = Helper.max(a.l, b.l);
        BlockPos h = Helper.min(a.h, b.h);
        if (l.getX() > h.getX()) {
            return null;
        }
        if (l.getY() > h.getY()) {
            return null;
        }
        if (l.getZ() > h.getZ()) {
            return null;
        }
        return new IntBox(l, h);
    }

    public IntBox map(Function<BlockPos, BlockPos> func1, Function<BlockPos, BlockPos> func2) {
        return new IntBox(func1.apply(this.l), func2.apply(this.h));
    }

    public BlockPos getCenter() {
        return Helper.divide((Vec3i)this.l.offset((Vec3i)this.h), 2);
    }

    public Vec3 getCenterVec() {
        return new Vec3((double)(this.l.getX() + this.h.getX() + 1) / 2.0, (double)(this.l.getY() + this.h.getY() + 1) / 2.0, (double)(this.l.getZ() + this.h.getZ() + 1) / 2.0);
    }

    public IntBox getAdjusted(int dxa, int dya, int dza, int dxb, int dyb, int dzb) {
        return new IntBox(this.l.offset(dxa, dya, dza), this.h.offset(dxb, dyb, dzb));
    }

    public Stream<BlockPos> forSixSurfaces(Function<Stream<IntBox>, Stream<IntBox>> mapper) {
        IntBox[] array = new IntBox[]{this.getSurfaceLayer(Direction.DOWN), this.getSurfaceLayer(Direction.NORTH).getAdjusted(0, 1, 0, 0, 0, 0), this.getSurfaceLayer(Direction.SOUTH).getAdjusted(0, 1, 0, 0, 0, 0), this.getSurfaceLayer(Direction.WEST).getAdjusted(0, 1, 1, 0, 0, -1), this.getSurfaceLayer(Direction.EAST).getAdjusted(0, 1, 1, 0, 0, -1), this.getSurfaceLayer(Direction.UP).getAdjusted(1, 0, 1, -1, 0, -1)};
        return mapper.apply(Arrays.stream(array).filter(intBox -> true)).flatMap(IntBox::stream);
    }

    public IntBox getMoved(Vec3i offset) {
        return new IntBox(this.l.offset(offset), this.h.offset(offset));
    }

    public static IntBox getContainingBox(IntBox box1, IntBox box2) {
        return new IntBox(Helper.min(box1.l, box2.l), Helper.max(box1.h, box2.h));
    }

    public IntBox getSubBoxInCenter(BlockPos subBoxSize) {
        BlockPos thisSize = this.getSize();
        Validate.isTrue((thisSize.getX() >= subBoxSize.getX() ? 1 : 0) != 0);
        Validate.isTrue((thisSize.getY() >= subBoxSize.getY() ? 1 : 0) != 0);
        Validate.isTrue((thisSize.getZ() >= subBoxSize.getZ() ? 1 : 0) != 0);
        return IntBox.fromBasePointAndSize(Helper.divide((Vec3i)thisSize.subtract((Vec3i)subBoxSize), 2).offset((Vec3i)this.l), subBoxSize);
    }

    public BlockPos[] getEightVertices() {
        return new BlockPos[]{new BlockPos(this.l.getX(), this.l.getY(), this.l.getZ()), new BlockPos(this.l.getX(), this.l.getY(), this.h.getZ()), new BlockPos(this.l.getX(), this.h.getY(), this.l.getZ()), new BlockPos(this.l.getX(), this.h.getY(), this.h.getZ()), new BlockPos(this.h.getX(), this.l.getY(), this.l.getZ()), new BlockPos(this.h.getX(), this.l.getY(), this.h.getZ()), new BlockPos(this.h.getX(), this.h.getY(), this.l.getZ()), new BlockPos(this.h.getX(), this.h.getY(), this.h.getZ())};
    }

    public AABB toRealNumberBox() {
        return new AABB((double)this.l.getX(), (double)this.l.getY(), (double)this.l.getZ(), (double)(this.h.getX() + 1), (double)(this.h.getY() + 1), (double)(this.h.getZ() + 1));
    }

    public static IntBox fromRealNumberBox(AABB aabb) {
        int minX = (int)Math.floor(aabb.minX + 1.0E-5);
        int minY = (int)Math.floor(aabb.minY + 1.0E-5);
        int minZ = (int)Math.floor(aabb.minZ + 1.0E-5);
        int maxX = (int)Math.ceil(aabb.maxX - 1.0E-5);
        int maxY = (int)Math.ceil(aabb.maxY - 1.0E-5);
        int maxZ = (int)Math.ceil(aabb.maxZ - 1.0E-5);
        return new IntBox(new BlockPos(minX, minY, minZ), new BlockPos(maxX - 1, maxY - 1, maxZ - 1));
    }

    public IntBox getExpanded(BlockPos newPoint) {
        return new IntBox(Helper.min(this.l, newPoint), Helper.max(this.h, newPoint));
    }

    public boolean contains(BlockPos pos) {
        return pos.getX() >= this.l.getX() && pos.getX() <= this.h.getX() && pos.getY() >= this.l.getY() && pos.getY() <= this.h.getY() && pos.getZ() >= this.l.getZ() && pos.getZ() <= this.h.getZ();
    }

    public boolean contains(IntBox box) {
        return this.contains(box.l) && this.contains(box.h);
    }

    public BlockPos selectCoordinateFromBox(boolean high) {
        return high ? this.h : this.l;
    }

    public IntBox[] get12Edges() {
        return new IntBox[]{new IntBox(this.selectCoordinateFromBox(false, false, false), this.selectCoordinateFromBox(false, false, true)), new IntBox(this.selectCoordinateFromBox(false, true, false), this.selectCoordinateFromBox(false, true, true)), new IntBox(this.selectCoordinateFromBox(true, false, false), this.selectCoordinateFromBox(true, false, true)), new IntBox(this.selectCoordinateFromBox(true, true, false), this.selectCoordinateFromBox(true, true, true)), new IntBox(this.selectCoordinateFromBox(false, false, false), this.selectCoordinateFromBox(false, true, false)), new IntBox(this.selectCoordinateFromBox(false, false, true), this.selectCoordinateFromBox(false, true, true)), new IntBox(this.selectCoordinateFromBox(true, false, false), this.selectCoordinateFromBox(true, true, false)), new IntBox(this.selectCoordinateFromBox(true, false, true), this.selectCoordinateFromBox(true, true, true)), new IntBox(this.selectCoordinateFromBox(false, false, false), this.selectCoordinateFromBox(true, false, false)), new IntBox(this.selectCoordinateFromBox(false, false, true), this.selectCoordinateFromBox(true, false, true)), new IntBox(this.selectCoordinateFromBox(false, true, false), this.selectCoordinateFromBox(true, true, false)), new IntBox(this.selectCoordinateFromBox(false, true, true), this.selectCoordinateFromBox(true, true, true))};
    }

    public BlockPos selectCoordinateFromBox(boolean xUp, boolean yUp, boolean zUp) {
        return new BlockPos(this.selectCoordinateFromBox(xUp).getX(), this.selectCoordinateFromBox(yUp).getY(), this.selectCoordinateFromBox(zUp).getZ());
    }

    public static IntBox getBoxByPosAndSignedSize(BlockPos basePos, BlockPos signedSize) {
        return new IntBox(basePos, new BlockPos(IntBox.getEndCoordWithSignedSize(basePos.getX(), signedSize.getX()), IntBox.getEndCoordWithSignedSize(basePos.getY(), signedSize.getY()), IntBox.getEndCoordWithSignedSize(basePos.getZ(), signedSize.getZ())));
    }

    private static int getEndCoordWithSignedSize(int base, int signedSize) {
        if (signedSize > 0) {
            return base + signedSize - 1;
        }
        if (signedSize < 0) {
            return base + signedSize + 1;
        }
        throw new IllegalArgumentException("Signed size cannot be zero");
    }

    public boolean isOnSurface(BlockPos pos) {
        boolean xOnEnd = pos.getX() == this.l.getX() || pos.getX() == this.h.getX();
        boolean yOnEnd = pos.getY() == this.l.getY() || pos.getY() == this.h.getY();
        boolean zOnEnd = pos.getZ() == this.l.getZ() || pos.getZ() == this.h.getZ();
        return xOnEnd || yOnEnd || zOnEnd;
    }

    public boolean isOnEdge(BlockPos pos) {
        boolean xOnEnd = pos.getX() == this.l.getX() || pos.getX() == this.h.getX();
        boolean yOnEnd = pos.getY() == this.l.getY() || pos.getY() == this.h.getY();
        boolean zOnEnd = pos.getZ() == this.l.getZ() || pos.getZ() == this.h.getZ();
        return xOnEnd && yOnEnd || yOnEnd && zOnEnd || zOnEnd && xOnEnd;
    }

    public boolean isOnVertex(BlockPos pos) {
        boolean xOnEnd = pos.getX() == this.l.getX() || pos.getX() == this.h.getX();
        boolean yOnEnd = pos.getY() == this.l.getY() || pos.getY() == this.h.getY();
        boolean zOnEnd = pos.getZ() == this.l.getZ() || pos.getZ() == this.h.getZ();
        return xOnEnd && yOnEnd && zOnEnd;
    }

    public IntBox confineInnerBox(IntBox innerBox) {
        int offsetX = IntBox.getOffsetForConfiningIntegerRange(this.l.getX(), this.h.getX(), innerBox.l.getX(), innerBox.h.getX());
        int offsetY = IntBox.getOffsetForConfiningIntegerRange(this.l.getY(), this.h.getY(), innerBox.l.getY(), innerBox.h.getY());
        int offsetZ = IntBox.getOffsetForConfiningIntegerRange(this.l.getZ(), this.h.getZ(), innerBox.l.getZ(), innerBox.h.getZ());
        return innerBox.getMoved((Vec3i)new BlockPos(offsetX, offsetY, offsetZ));
    }

    public static int getOffsetForConfiningIntegerRange(int outerRangeStart, int outerRangeEnd, int innerRangeStart, int innerRangeEnd) {
        int outerRangeSize = outerRangeEnd - outerRangeStart + 1;
        int innerRangeSize = innerRangeEnd - innerRangeStart + 1;
        Validate.isTrue((outerRangeSize >= innerRangeSize ? 1 : 0) != 0, (String)"cannot confine range (%d %d) to (%d %d)", (Object[])new Object[]{innerRangeStart, innerRangeEnd, outerRangeStart, outerRangeEnd});
        if (innerRangeStart >= outerRangeStart && innerRangeEnd <= outerRangeEnd) {
            return 0;
        }
        if (innerRangeStart < outerRangeStart) {
            return outerRangeStart - innerRangeStart;
        }
        return outerRangeEnd - innerRangeEnd;
    }

    public BlockPos getVertex(boolean xPosi, boolean yPosi, boolean zPosi) {
        return new BlockPos(xPosi ? this.h.getX() : this.l.getX(), yPosi ? this.h.getY() : this.l.getY(), zPosi ? this.h.getZ() : this.l.getZ());
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("lX", this.l.getX());
        tag.putInt("lY", this.l.getY());
        tag.putInt("lZ", this.l.getZ());
        tag.putInt("hX", this.h.getX());
        tag.putInt("hY", this.h.getY());
        tag.putInt("hZ", this.h.getZ());
        return tag;
    }

    public static IntBox fromTag(CompoundTag tag) {
        return new IntBox(new BlockPos(tag.getInt("lX"), tag.getInt("lY"), tag.getInt("lZ")), new BlockPos(tag.getInt("hX"), tag.getInt("hY"), tag.getInt("hZ")));
    }

    public String toString() {
        return String.format("(%d %d %d)-(%d %d %d)", this.l.getX(), this.l.getY(), this.l.getZ(), this.h.getX(), this.h.getY(), this.h.getZ());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntBox intBox = (IntBox)o;
        return this.l.equals((Object)intBox.l) && this.h.equals((Object)intBox.h);
    }

    public int hashCode() {
        return Objects.hash(this.l, this.h);
    }
}

