/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.dimension;

import com.mojang.logging.LogUtils;
import de.nick1st.imm_ptl.events.ClientExitEvent;
import java.util.HashSet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.IPPerServerInfo;
import qouteall.q_misc_util.MiscNetworking;
import qouteall.q_misc_util.dimension.DimIntIdMap;

public class DimensionIntId {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static DimIntIdMap clientRecord;

    public static void init() {
    }

    public static void initClient() {
        NeoForge.EVENT_BUS.addListener(ClientExitEvent.class, e -> DimensionIntId.onClientExit());
    }

    private static void onClientExit() {
        clientRecord = null;
    }

    @NotNull
    public static DimIntIdMap getClientMap() {
        Validate.notNull((Object)clientRecord, (String)"Client dim id record is not yet synced. This should not be used in networking thread.", (Object[])new Object[0]);
        return clientRecord;
    }

    @NotNull
    public static DimIntIdMap getServerMap(MinecraftServer server) {
        IPPerServerInfo perServerInfo = IPPerServerInfo.of(server);
        DimIntIdMap rec = perServerInfo.dimIntIdMap;
        Validate.notNull((Object)rec, (String)"Server dim id record is not yet initialized", (Object[])new Object[0]);
        return rec;
    }

    public static void onServerStarted(MinecraftServer server) {
        DimIntIdMap rec = new DimIntIdMap();
        DimensionIntId.fillInVanillaDimIds(rec);
        for (ServerLevel world : server.getAllLevels()) {
            ResourceKey dimId = world.dimension();
            if (rec.containsDimId((ResourceKey<Level>)dimId)) continue;
            rec.add((ResourceKey<Level>)dimId, rec.getNextIntegerId());
        }
        IPPerServerInfo perServerInfo = IPPerServerInfo.of(server);
        perServerInfo.dimIntIdMap = rec;
        LOGGER.info("Server dimension integer id mapping:\n{}", (Object)rec);
    }

    private static void fillInVanillaDimIds(DimIntIdMap rec) {
        if (!rec.containsDimId((ResourceKey<Level>)Level.OVERWORLD)) {
            rec.add((ResourceKey<Level>)Level.OVERWORLD, 0);
        }
        if (!rec.containsDimId((ResourceKey<Level>)Level.NETHER)) {
            rec.add((ResourceKey<Level>)Level.NETHER, -1);
        }
        if (!rec.containsDimId((ResourceKey<Level>)Level.END)) {
            rec.add((ResourceKey<Level>)Level.END, 1);
        }
    }

    public static void onServerDimensionChanged(MinecraftServer server) {
        DimIntIdMap map = DimensionIntId.getServerMap(server);
        for (ResourceKey levelKey : server.levelKeys()) {
            if (map.containsDimId((ResourceKey<Level>)levelKey)) continue;
            map.add((ResourceKey<Level>)levelKey, map.getNextIntegerId());
        }
        HashSet<ResourceKey<Level>> usedDimKeys = new HashSet<ResourceKey<Level>>(server.levelKeys());
        usedDimKeys.add(Level.OVERWORLD);
        usedDimKeys.add(Level.NETHER);
        usedDimKeys.add(Level.END);
        map.removeUnused(usedDimKeys);
        LOGGER.info("Current dimension integer id mapping:\n{}", (Object)map);
        MiscNetworking.DimIdSyncPacket packet = MiscNetworking.DimIdSyncPacket.createPacket(server);
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            player.connection.send((CustomPacketPayload)packet);
        }
    }
}

