/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.McHelper;
import qouteall.q_misc_util.dimension.DimIntIdMap;
import qouteall.q_misc_util.dimension.DimensionIntId;

public class MiscNetworking {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation id_stcRemote = ResourceLocation.fromNamespaceAndPath((String)"q_misc_util", (String)"remote_stc");
    public static final ResourceLocation id_ctsRemote = ResourceLocation.fromNamespaceAndPath((String)"q_misc_util", (String)"remote_cts");
    public static final CustomPacketPayload.Type<CustomPacketPayload> TYPE_STC_REMOTE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"q_misc_util:remote_stc"));
    public static final CustomPacketPayload.Type<CustomPacketPayload> TYPE_CTS_REMOTE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"q_misc_util:remote_cts"));

    public record DimIdSyncPacket(CompoundTag dimIntIdTag, CompoundTag dimTypeTag) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<DimIdSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"imm_ptl:dim_int_id_sync"));
        public static final StreamCodec<FriendlyByteBuf, DimIdSyncPacket> CODEC = StreamCodec.of((b, p) -> p.write((FriendlyByteBuf)b), DimIdSyncPacket::read);

        public static DimIdSyncPacket createFromServer(MinecraftServer server) {
            DimIntIdMap rec = DimensionIntId.getServerMap(server);
            CompoundTag dimIntIdTag = rec.toTag(dim -> true);
            RegistryAccess.Frozen registryManager = server.registryAccess();
            Registry dimensionTypes = registryManager.registryOrThrow(Registries.DIMENSION_TYPE);
            CompoundTag dimIdToDimTypeIdTag = new CompoundTag();
            for (ServerLevel world : server.getAllLevels()) {
                ResourceKey dimId = world.dimension();
                DimensionType dimType = world.dimensionType();
                ResourceLocation dimTypeId = dimensionTypes.getKey((Object)dimType);
                if (dimTypeId == null) {
                    LOGGER.error("Cannot find dimension type for {}", (Object)dimId.location());
                    LOGGER.error("Registered dimension types {}", (Object)dimensionTypes.keySet());
                    dimTypeId = BuiltinDimensionTypes.OVERWORLD.location();
                }
                dimIdToDimTypeIdTag.putString(dimId.location().toString(), dimTypeId.toString());
            }
            return new DimIdSyncPacket(dimIntIdTag, dimIdToDimTypeIdTag);
        }

        public static DimIdSyncPacket createPacket(MinecraftServer server) {
            return DimIdSyncPacket.createFromServer(server);
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeNbt((Tag)this.dimIntIdTag);
            buf.writeNbt((Tag)this.dimTypeTag);
        }

        public static DimIdSyncPacket read(FriendlyByteBuf buf) {
            CompoundTag idMapTag = buf.readNbt();
            CompoundTag typeTag = buf.readNbt();
            return new DimIdSyncPacket(idMapTag, typeTag);
        }

        public void handleOnNetworkingThread() {
            ImmutableMap dimTypeMap;
            DimIntIdMap rec = DimIntIdMap.fromTag(this.dimIntIdTag);
            LOGGER.info("Client received dim intId sync packet\n{}", (Object)rec);
            DimensionIntId.clientRecord = rec;
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (String key : this.dimTypeTag.getAllKeys()) {
                ResourceKey dimId = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)McHelper.newResourceLocation(key));
                String dimTypeId = this.dimTypeTag.getString(key);
                ResourceKey dimType = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)McHelper.newResourceLocation(dimTypeId));
                builder.put((Object)dimId, (Object)dimType);
            }
            ClientWorldLoader.dimIdToDimTypeId = dimTypeMap = builder.build();
            LOGGER.info("Client accepted dimension type mapping {}", (Object)dimTypeMap);
        }
    }
}

