/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscGlobals;
import qouteall.q_misc_util.ducks.IEMinecraftServer_Misc;
import qouteall.q_misc_util.mixin.IELevelStorageAccess_Misc;

public class MiscHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Gson gson;

    public static void executeOnRenderThread(Runnable runnable) {
        Minecraft client = Minecraft.getInstance();
        if (client.isSameThread()) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOGGER.error("Processing task on render thread", (Throwable)e);
            }
        } else {
            client.execute(runnable);
        }
    }

    @Deprecated
    public static MinecraftServer getServer() {
        return (MinecraftServer)MiscGlobals.refMinecraftServer.get();
    }

    public static void executeOnServerThread(MinecraftServer server, Runnable runnable) {
        if (server.isSameThread()) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOGGER.error("Processing task on server thread", (Throwable)e);
            }
        } else {
            server.execute(runnable);
        }
    }

    public static boolean isDedicatedServer() {
        return FMLLoader.getDist() == Dist.DEDICATED_SERVER;
    }

    public static Path getWorldSavingDirectory(MinecraftServer server) {
        Validate.notNull((Object)server);
        Path saveDir = ((IELevelStorageAccess_Misc)((IEMinecraftServer_Misc)server).ip_getStorageSource()).ip_getLevelPath().path();
        return saveDir;
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.registerTypeAdapter(new TypeToken<ResourceKey<Level>>(){}.getType(), (Object)new DimensionIDJsonAdapter());
        gson = gsonBuilder.create();
    }

    private static class DimensionIDJsonAdapter
    implements JsonSerializer<ResourceKey<Level>>,
    JsonDeserializer<ResourceKey<Level>> {
        private DimensionIDJsonAdapter() {
        }

        public ResourceKey<Level> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String str = json.getAsString();
            return Helper.dimIdToKey(str);
        }

        public JsonElement serialize(ResourceKey<Level> src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.location().toString());
        }
    }
}

