/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.CountDownInt;
import qouteall.q_misc_util.my_util.DQuaternion;

public class ImplRemoteProcedureCall {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final CountDownInt LOGGING_LIMIT = new CountDownInt(100);
    private static final CountDownInt ERROR_MESSAGE_LIMIT = new CountDownInt(10);
    public static final Gson gson = MiscHelper.gson;
    private static final ConcurrentHashMap<String, Method> methodCache = new ConcurrentHashMap();
    private static final ImmutableMap<Class, BiConsumer<RegistryFriendlyByteBuf, Object>> serializerMap = ImmutableMap.builder().put(ResourceLocation.class, (buf, o) -> buf.writeResourceLocation((ResourceLocation)o)).put(ResourceKey.class, (buf, o) -> buf.writeResourceLocation(((ResourceKey)o).location())).put(BlockPos.class, (buf, o) -> buf.writeBlockPos((BlockPos)o)).put(Vec3.class, (buf, o) -> {
        Vec3 vec = (Vec3)o;
        buf.writeDouble(vec.x);
        buf.writeDouble(vec.y);
        buf.writeDouble(vec.z);
    }).put(UUID.class, (buf, o) -> buf.writeUUID((UUID)o)).put(Block.class, (buf, o) -> ImplRemoteProcedureCall.serializeByCodec((FriendlyByteBuf)buf, BuiltInRegistries.BLOCK.byNameCodec(), o)).put(Item.class, (buf, o) -> ImplRemoteProcedureCall.serializeByCodec((FriendlyByteBuf)buf, BuiltInRegistries.ITEM.byNameCodec(), o)).put(BlockState.class, (buf, o) -> ImplRemoteProcedureCall.serializeByCodec((FriendlyByteBuf)buf, BlockState.CODEC, o)).put(ItemStack.class, (buf, o) -> ImplRemoteProcedureCall.serializeByCodec((FriendlyByteBuf)buf, ItemStack.CODEC, o)).put(CompoundTag.class, (buf, o) -> buf.writeNbt((Tag)((CompoundTag)o))).put(Component.class, (buf, o) -> ComponentSerialization.TRUSTED_STREAM_CODEC.encode(buf, (Object)((Component)o))).put(DQuaternion.class, (buf, o) -> {
        DQuaternion dQuaternion = (DQuaternion)o;
        buf.writeDouble(dQuaternion.x);
        buf.writeDouble(dQuaternion.y);
        buf.writeDouble(dQuaternion.z);
        buf.writeDouble(dQuaternion.w);
    }).put(byte[].class, (buf, o) -> buf.writeByteArray((byte[])o)).build();
    private static final ImmutableMap<Type, Function<RegistryFriendlyByteBuf, Object>> deserializerMap = ImmutableMap.builder().put(ResourceLocation.class, FriendlyByteBuf::readResourceLocation).put((Object)new TypeToken<ResourceKey<Level>>(){}.getType(), buf -> ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)buf.readResourceLocation())).put((Object)new TypeToken<ResourceKey<Biome>>(){}.getType(), buf -> ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)buf.readResourceLocation())).put(BlockPos.class, buf -> buf.readBlockPos()).put(Vec3.class, buf -> new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble())).put(UUID.class, buf -> buf.readUUID()).put(Block.class, buf -> ImplRemoteProcedureCall.deserializeByCodec((FriendlyByteBuf)buf, BuiltInRegistries.BLOCK.byNameCodec())).put(Item.class, buf -> ImplRemoteProcedureCall.deserializeByCodec((FriendlyByteBuf)buf, BuiltInRegistries.ITEM.byNameCodec())).put(BlockState.class, buf -> ImplRemoteProcedureCall.deserializeByCodec((FriendlyByteBuf)buf, BlockState.CODEC)).put(ItemStack.class, buf -> ImplRemoteProcedureCall.deserializeByCodec((FriendlyByteBuf)buf, ItemStack.CODEC)).put(CompoundTag.class, buf -> buf.readNbt()).put(Component.class, arg_0 -> ((StreamCodec)ComponentSerialization.TRUSTED_STREAM_CODEC).decode(arg_0)).put(DQuaternion.class, buf -> new DQuaternion(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble())).put(byte[].class, buf -> buf.readByteArray()).build();

    private static Object deserializeByCodec(FriendlyByteBuf buf, Codec codec) {
        String jsonString = buf.readUtf();
        JsonElement jsonElement = JsonParser.parseString((String)jsonString);
        return codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow();
    }

    private static Object deserializeArgument(RegistryFriendlyByteBuf buf, Type type) {
        Function deserializer = (Function)deserializerMap.get((Object)type);
        if (deserializer == null) {
            String json = buf.readUtf();
            return gson.fromJson(json, type);
        }
        return deserializer.apply(buf);
    }

    private static void serializeArgument(RegistryFriendlyByteBuf buf, Object object) {
        BiConsumer serializer = (BiConsumer)serializerMap.get(object.getClass());
        if (serializer == null) {
            serializer = serializerMap.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(object.getClass())).findFirst().map(Map.Entry::getValue).orElse(null);
        }
        if (serializer == null) {
            String json = gson.toJson(object);
            buf.writeUtf(json);
            return;
        }
        serializer.accept(buf, object);
    }

    private static void serializeByCodec(FriendlyByteBuf buf, Codec codec, Object object) {
        JsonElement result = (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, object).getOrThrow();
        String jsonString = gson.toJson(result);
        buf.writeUtf(jsonString);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void clientTellFailure() {
        Minecraft.getInstance().gui.getChat().addMessage((Component)Component.literal((String)"The client failed to process a packet from server. See the log for details.").withStyle(ChatFormatting.RED));
    }

    private static void serverTellFailure(ServerPlayer player) {
        player.sendSystemMessage((Component)Component.literal((String)"The server failed to process a packet sent from client.").withStyle(ChatFormatting.RED));
    }

    private static Method getMethodByPath(String methodPath) {
        Method result = methodCache.get(methodPath);
        if (result != null) {
            return result;
        }
        Method method = ImplRemoteProcedureCall.findMethodByPath(methodPath);
        Validate.notNull((Object)method);
        methodCache.put(methodPath, method);
        return method;
    }

    private static Method findMethodByPath(String methodPath) {
        Class<?> aClass;
        int lastDotIndex = methodPath.lastIndexOf(46);
        Validate.isTrue((lastDotIndex != -1 ? 1 : 0) != 0);
        String classPath = methodPath.substring(0, lastDotIndex);
        String methodName = methodPath.substring(lastDotIndex + 1);
        if (!classPath.contains("RemoteCallable")) {
            throw new RuntimeException("The class path must contain \"RemoteCallable\"");
        }
        try {
            aClass = Class.forName(classPath);
        }
        catch (ClassNotFoundException e) {
            int dotIndex = classPath.lastIndexOf(46);
            if (dotIndex != -1) {
                String newClassPath = classPath.substring(0, dotIndex) + "$" + classPath.substring(dotIndex + 1);
                try {
                    aClass = Class.forName(newClassPath);
                }
                catch (ClassNotFoundException e1) {
                    throw new RuntimeException("Cannot find class " + classPath, e);
                }
            }
            throw new RuntimeException("Cannot find class " + classPath, e);
        }
        Method method = Arrays.stream(aClass.getMethods()).filter(m -> m.getName().equals(methodName)).findFirst().orElseThrow(() -> new RuntimeException("Cannot find method " + methodPath + " . If it's a private method, make it public."));
        return method;
    }

    public record C2SRPCPayload(boolean deserializeSuccess, @Nullable String methodPath, @Nullable Method method, @Nullable List<Object> args) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<C2SRPCPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"iportal:remote_c2s"));
        public static final StreamCodec<RegistryFriendlyByteBuf, C2SRPCPayload> CODEC = StreamCodec.of((b, p) -> p.write((RegistryFriendlyByteBuf)b), C2SRPCPayload::read);

        public static C2SRPCPayload read(RegistryFriendlyByteBuf buf) {
            String methodPath = null;
            try {
                methodPath = buf.readUtf();
                Method method = ImplRemoteProcedureCall.getMethodByPath(methodPath);
                Type[] genericParameterTypes = method.getGenericParameterTypes();
                ArrayList<Object> args = new ArrayList<Object>();
                for (int i = 1; i < genericParameterTypes.length; ++i) {
                    Type parameterType = genericParameterTypes[i];
                    Object obj = ImplRemoteProcedureCall.deserializeArgument(buf, parameterType);
                    args.add(obj);
                }
                return new C2SRPCPayload(true, methodPath, method, args);
            }
            catch (Exception e) {
                if (LOGGING_LIMIT.tryDecrement()) {
                    LOGGER.error("Failed to parse remote procedure call {}", (Object)methodPath, (Object)e);
                }
                return new C2SRPCPayload(false, methodPath, null, null);
            }
        }

        public void write(RegistryFriendlyByteBuf buf) {
            Validate.notNull(this.args, (String)"args must not be null", (Object[])new Object[0]);
            Validate.notNull((Object)this.methodPath, (String)"methodPath must not be null", (Object[])new Object[0]);
            buf.writeUtf(this.methodPath);
            for (Object arg : this.args) {
                ImplRemoteProcedureCall.serializeArgument(buf, arg);
            }
        }

        public void handle(IPayloadContext c) {
            block6: {
                if (!(c.player() instanceof ServerPlayer)) {
                    return;
                }
                ServerPlayer player = (ServerPlayer)c.player();
                if (!this.deserializeSuccess) {
                    if (ERROR_MESSAGE_LIMIT.tryDecrement()) {
                        ImplRemoteProcedureCall.serverTellFailure(player);
                    }
                    return;
                }
                Validate.notNull(this.args, (String)"args must not be null", (Object[])new Object[0]);
                Validate.notNull((Object)this.method, (String)"method must not be null", (Object[])new Object[0]);
                try {
                    Object[] argArray = new Object[this.args.size() + 1];
                    argArray[0] = player;
                    for (int i = 0; i < this.args.size(); ++i) {
                        argArray[i + 1] = this.args.get(i);
                    }
                    this.method.invoke(null, argArray);
                }
                catch (Exception e) {
                    if (!LOGGING_LIMIT.tryDecrement()) break block6;
                    LOGGER.error("Failed to invoke remote procedure call {} {}", new Object[]{this.methodPath, player, e});
                    ImplRemoteProcedureCall.serverTellFailure(player);
                }
            }
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record S2CRPCPayload(boolean deserializeSuccess, @Nullable String methodPath, @Nullable Method method, @Nullable List<Object> args) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<S2CRPCPayload> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"iportal:remote_s2c"));
        public static final StreamCodec<RegistryFriendlyByteBuf, S2CRPCPayload> CODEC = StreamCodec.of((b, p) -> p.write((RegistryFriendlyByteBuf)b), S2CRPCPayload::read);

        public static S2CRPCPayload read(RegistryFriendlyByteBuf buf) {
            String methodPath = null;
            try {
                methodPath = buf.readUtf();
                Method method = ImplRemoteProcedureCall.getMethodByPath(methodPath);
                Type[] genericParameterTypes = method.getGenericParameterTypes();
                ArrayList<Object> args = new ArrayList<Object>();
                for (Type parameterType : genericParameterTypes) {
                    Object obj = ImplRemoteProcedureCall.deserializeArgument(buf, parameterType);
                    args.add(obj);
                }
                return new S2CRPCPayload(true, methodPath, method, args);
            }
            catch (Exception e) {
                if (LOGGING_LIMIT.tryDecrement()) {
                    LOGGER.error("Failed to parse remote procedure call {}", (Object)methodPath, (Object)e);
                }
                return new S2CRPCPayload(false, methodPath, null, null);
            }
        }

        public void write(RegistryFriendlyByteBuf buf) {
            Validate.notNull(this.args, (String)"args must not be null", (Object[])new Object[0]);
            Validate.notNull((Object)this.methodPath, (String)"methodPath must not be null", (Object[])new Object[0]);
            buf.writeUtf(this.methodPath);
            for (Object arg : this.args) {
                ImplRemoteProcedureCall.serializeArgument(buf, arg);
            }
        }

        public void handle(IPayloadContext c) {
            block4: {
                if (!this.deserializeSuccess) {
                    if (ERROR_MESSAGE_LIMIT.tryDecrement()) {
                        ImplRemoteProcedureCall.clientTellFailure();
                    }
                    return;
                }
                Validate.notNull(this.args, (String)"args must not be null", (Object[])new Object[0]);
                Validate.notNull((Object)this.method, (String)"method must not be null", (Object[])new Object[0]);
                try {
                    Object[] argArray = this.args.toArray(new Object[0]);
                    this.method.invoke(null, argArray);
                }
                catch (Exception e) {
                    if (!LOGGING_LIMIT.tryDecrement()) break block4;
                    LOGGER.error("Failed to invoke remote procedure call {}", (Object)this.methodPath, (Object)e);
                    ImplRemoteProcedureCall.clientTellFailure();
                }
            }
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

