/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util;

import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.IntBox;
import qouteall.q_misc_util.my_util.LongBlockPos;
import qouteall.q_misc_util.my_util.RayTraceResult;

public class Helper {
    public static final Logger LOGGER = LogManager.getLogger((String)"iPortal");
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();

    public static double getCollidingT(Vec3 planeCenter, Vec3 planeNormal, Vec3 lineOrigin, Vec3 lineDirection) {
        return planeCenter.subtract(lineOrigin).dot(planeNormal) / lineDirection.dot(planeNormal);
    }

    public static double getCollidingT(double planeOriginX, double planeOriginY, double planeOriginZ, double planeNormalX, double planeNormalY, double planeNormalZ, double lineOriginX, double lineOriginY, double lineOriginZ, double lineDeltaX, double lineDeltaY, double lineDeltaZ) {
        double denom = lineDeltaX * planeNormalX + lineDeltaY * planeNormalY + lineDeltaZ * planeNormalZ;
        if (Math.abs(denom) < 1.0E-6) {
            return Double.NaN;
        }
        return ((planeOriginX - lineOriginX) * planeNormalX + (planeOriginY - lineOriginY) * planeNormalY + (planeOriginZ - lineOriginZ) * planeNormalZ) / denom;
    }

    @Nullable
    public static RayTraceResult raytraceAABB(boolean boxFacingOutwards, double boxMinX, double boxMinY, double boxMinZ, double boxMaxX, double boxMaxY, double boxMaxZ, double lineOriginX, double lineOriginY, double lineOriginZ, double lineDeltaX, double lineDeltaY, double lineDeltaZ) {
        double tZ;
        double tY;
        boolean originInBox;
        boolean bl = originInBox = lineOriginX > boxMinX && lineOriginX < boxMaxX && lineOriginY > boxMinY && lineOriginY < boxMaxY && lineOriginZ > boxMinZ && lineOriginZ < boxMaxZ;
        if (boxFacingOutwards && originInBox) {
            return null;
        }
        boolean testXPosi = lineDeltaX > 0.0 ^ boxFacingOutwards;
        boolean testYPosi = lineDeltaY > 0.0 ^ boxFacingOutwards;
        boolean testZPosi = lineDeltaZ > 0.0 ^ boxFacingOutwards;
        boolean normalXPosi = lineDeltaX <= 0.0;
        boolean normalYPosi = lineDeltaY <= 0.0;
        boolean normalZPosi = lineDeltaZ <= 0.0;
        double tX = Helper.getCollidingT(testXPosi ? boxMaxX : boxMinX, 0.0, 0.0, normalXPosi ? 1.0 : -1.0, 0.0, 0.0, lineOriginX, lineOriginY, lineOriginZ, lineDeltaX, lineDeltaY, lineDeltaZ);
        if (!Double.isNaN(tX) && tX >= 0.0 && tX <= 1.0) {
            double y = lineOriginY + tX * lineDeltaY;
            double z = lineOriginZ + tX * lineDeltaZ;
            if (y >= boxMinY && y <= boxMaxY && z >= boxMinZ && z <= boxMaxZ) {
                return new RayTraceResult(tX, new Vec3(testXPosi ? boxMaxX : boxMinX, y, z), new Vec3(testXPosi ? 1.0 : -1.0, 0.0, 0.0));
            }
        }
        if (!Double.isNaN(tY = Helper.getCollidingT(0.0, testYPosi ? boxMaxY : boxMinY, 0.0, 0.0, normalYPosi ? 1.0 : -1.0, 0.0, lineOriginX, lineOriginY, lineOriginZ, lineDeltaX, lineDeltaY, lineDeltaZ)) && tY >= 0.0 && tY <= 1.0) {
            double x = lineOriginX + tY * lineDeltaX;
            double z = lineOriginZ + tY * lineDeltaZ;
            if (x >= boxMinX && x <= boxMaxX && z >= boxMinZ && z <= boxMaxZ) {
                return new RayTraceResult(tY, new Vec3(x, testYPosi ? boxMaxY : boxMinY, z), new Vec3(0.0, testYPosi ? 1.0 : -1.0, 0.0));
            }
        }
        if (!Double.isNaN(tZ = Helper.getCollidingT(0.0, 0.0, testZPosi ? boxMaxZ : boxMinZ, 0.0, 0.0, normalZPosi ? 1.0 : -1.0, lineOriginX, lineOriginY, lineOriginZ, lineDeltaX, lineDeltaY, lineDeltaZ)) && tZ >= 0.0 && tZ <= 1.0) {
            double x = lineOriginX + tZ * lineDeltaX;
            double y = lineOriginY + tZ * lineDeltaY;
            if (x >= boxMinX && x <= boxMaxX && y >= boxMinY && y <= boxMaxY) {
                return new RayTraceResult(tZ, new Vec3(x, y, testZPosi ? boxMaxZ : boxMinZ), new Vec3(0.0, 0.0, testZPosi ? 1.0 : -1.0));
            }
        }
        return null;
    }

    public static boolean isInFrontOfPlane(Vec3 pos, Vec3 planePos, Vec3 planeNormal) {
        return pos.subtract(planePos).dot(planeNormal) > 0.0;
    }

    public static Vec3 fallPointOntoPlane(Vec3 point, Vec3 planePos, Vec3 planeNormal) {
        double t = Helper.getCollidingT(planePos, planeNormal, point, planeNormal);
        return point.add(planeNormal.scale(t));
    }

    public static Vec3i getUnitFromAxis(Direction.Axis axis) {
        return Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).getNormal();
    }

    public static int getCoordinate(Vec3i v, Direction.Axis axis) {
        return axis.choose(v.getX(), v.getY(), v.getZ());
    }

    public static double getCoordinate(Vec3 v, Direction.Axis axis) {
        return axis.choose(v.x, v.y, v.z);
    }

    public static int getCoordinate(Vec3i v, Direction direction) {
        return Helper.getCoordinate(v, direction.getAxis()) * (direction.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1 : -1);
    }

    public static Vec3 putCoordinate(Vec3 v, Direction.Axis axis, double value) {
        return switch (axis) {
            case Direction.Axis.X -> new Vec3(value, v.y, v.z);
            case Direction.Axis.Y -> new Vec3(v.x, value, v.z);
            default -> new Vec3(v.x, v.y, value);
        };
    }

    public static BlockPos putCoordinate(Vec3i v, Direction.Axis axis, int value) {
        return switch (axis) {
            case Direction.Axis.X -> new BlockPos(value, v.getY(), v.getZ());
            case Direction.Axis.Y -> new BlockPos(v.getX(), value, v.getZ());
            default -> new BlockPos(v.getX(), v.getY(), value);
        };
    }

    public static Vec3 putSignedCoordinate(Vec3 vec, Direction direction, double value) {
        return switch (direction) {
            case Direction.DOWN -> new Vec3(vec.x, -value, vec.z);
            case Direction.UP -> new Vec3(vec.x, value, vec.z);
            case Direction.NORTH -> new Vec3(vec.x, vec.y, -value);
            case Direction.SOUTH -> new Vec3(vec.x, vec.y, value);
            case Direction.WEST -> new Vec3(-value, vec.y, vec.z);
            case Direction.EAST -> new Vec3(value, vec.y, vec.z);
            default -> throw new RuntimeException();
        };
    }

    public static double getSignedCoordinate(Vec3 vec, Direction direction) {
        return switch (direction) {
            case Direction.DOWN -> -vec.y;
            case Direction.UP -> vec.y;
            case Direction.NORTH -> -vec.z;
            case Direction.SOUTH -> vec.z;
            case Direction.WEST -> -vec.x;
            case Direction.EAST -> vec.x;
            default -> throw new RuntimeException();
        };
    }

    public static double getDistanceSqrOnAxisPlane(Vec3 vec, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> vec.y * vec.y + vec.z * vec.z;
            case Direction.Axis.Y -> vec.x * vec.x + vec.z * vec.z;
            case Direction.Axis.Z -> vec.x * vec.x + vec.y * vec.y;
        };
    }

    public static double getBoxCoordinate(AABB box, Direction direction) {
        switch (direction) {
            case DOWN: {
                return box.minY;
            }
            case UP: {
                return box.maxY;
            }
            case NORTH: {
                return box.minZ;
            }
            case SOUTH: {
                return box.maxZ;
            }
            case WEST: {
                return box.minX;
            }
            case EAST: {
                return box.maxX;
            }
        }
        throw new RuntimeException();
    }

    public static AABB replaceBoxCoordinate(AABB box, Direction direction, double coordinate) {
        switch (direction) {
            case DOWN: {
                return new AABB(box.minX, coordinate, box.minZ, box.maxX, box.maxY, box.maxZ);
            }
            case UP: {
                return new AABB(box.minX, box.minY, box.minZ, box.maxX, coordinate, box.maxZ);
            }
            case NORTH: {
                return new AABB(box.minX, box.minY, coordinate, box.maxX, box.maxY, box.maxZ);
            }
            case SOUTH: {
                return new AABB(box.minX, box.minY, box.minZ, box.maxX, box.maxY, coordinate);
            }
            case WEST: {
                return new AABB(coordinate, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ);
            }
            case EAST: {
                return new AABB(box.minX, box.minY, box.minZ, coordinate, box.maxY, box.maxZ);
            }
        }
        throw new RuntimeException();
    }

    public static <A, B> Tuple<B, A> swaped(Tuple<A, B> p) {
        return new Tuple(p.getB(), p.getA());
    }

    public static <T> T uniqueOfThree(T a, T b, T c) {
        if (a.equals(b)) {
            return c;
        }
        if (b.equals(c)) {
            return a;
        }
        assert (a.equals(c));
        return b;
    }

    public static BlockPos max(BlockPos a, BlockPos b) {
        return new BlockPos(Math.max(a.getX(), b.getX()), Math.max(a.getY(), b.getY()), Math.max(a.getZ(), b.getZ()));
    }

    public static BlockPos min(BlockPos a, BlockPos b) {
        return new BlockPos(Math.min(a.getX(), b.getX()), Math.min(a.getY(), b.getY()), Math.min(a.getZ(), b.getZ()));
    }

    public static Tuple<Direction.Axis, Direction.Axis> getAnotherTwoAxis(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return new Tuple((Object)Direction.Axis.Y, (Object)Direction.Axis.Z);
            }
            case Y: {
                return new Tuple((Object)Direction.Axis.Z, (Object)Direction.Axis.X);
            }
            case Z: {
                return new Tuple((Object)Direction.Axis.X, (Object)Direction.Axis.Y);
            }
        }
        throw new IllegalArgumentException();
    }

    public static BlockPos scale(Vec3i v, int m) {
        return new BlockPos(v.getX() * m, v.getY() * m, v.getZ() * m);
    }

    public static BlockPos divide(Vec3i v, int d) {
        return new BlockPos(v.getX() / d, v.getY() / d, v.getZ() / d);
    }

    public static BlockPos floorDiv(Vec3i v, int d) {
        return new BlockPos(Math.floorDiv(v.getX(), d), Math.floorDiv(v.getY(), d), Math.floorDiv(v.getZ(), d));
    }

    public static Direction[] getAnotherFourDirections(Direction.Axis axisOfNormal) {
        Tuple<Direction.Axis, Direction.Axis> anotherTwoAxis = Helper.getAnotherTwoAxis(axisOfNormal);
        return new Direction[]{Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)anotherTwoAxis.getA())), Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)anotherTwoAxis.getB())), Direction.get((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)((Direction.Axis)anotherTwoAxis.getA())), Direction.get((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)((Direction.Axis)anotherTwoAxis.getB()))};
    }

    public static Tuple<Direction, Direction> getPerpendicularDirections(Direction facing) {
        Tuple axises = Helper.getAnotherTwoAxis(facing.getAxis());
        if (facing.getAxisDirection() == Direction.AxisDirection.NEGATIVE) {
            axises = new Tuple((Object)((Direction.Axis)axises.getB()), (Object)((Direction.Axis)axises.getA()));
        }
        return new Tuple((Object)Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)axises.getA())), (Object)Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)axises.getB())));
    }

    public static Vec3 getBoxSize(AABB box) {
        return new Vec3(box.getXsize(), box.getYsize(), box.getZsize());
    }

    public static AABB getBoxSurfaceInversed(AABB box, Direction direction) {
        double size = Helper.getCoordinate(Helper.getBoxSize(box), direction.getAxis());
        Vec3 shrinkVec = Vec3.atLowerCornerOf((Vec3i)direction.getNormal()).scale(size);
        return box.contract(shrinkVec.x, shrinkVec.y, shrinkVec.z);
    }

    public static AABB getBoxSurface(AABB box, Direction direction) {
        return Helper.getBoxSurfaceInversed(box, direction.getOpposite());
    }

    public static IntBox expandRectangle(BlockPos startingPos, Predicate<BlockPos> blockPosPredicate, Direction.Axis axis) {
        IntBox wallArea = new IntBox(startingPos, startingPos);
        for (Direction direction : Helper.getAnotherFourDirections(axis)) {
            wallArea = Helper.expandArea(wallArea, blockPosPredicate, direction);
        }
        return wallArea;
    }

    public static IntBox expandBoxArea(BlockPos startingPos, Predicate<BlockPos> blockPosPredicate) {
        IntBox box = new IntBox(startingPos, startingPos);
        for (Direction direction : Direction.values()) {
            box = Helper.expandArea(box, blockPosPredicate, direction);
        }
        return box;
    }

    public static int getChebyshevDistance(int x1, int z1, int x2, int z2) {
        return Math.max(Math.abs(x1 - x2), Math.abs(z1 - z2));
    }

    public static AABB getBoxByBottomPosAndSize(Vec3 boxBottomCenter, Vec3 viewBoxSize) {
        return new AABB(boxBottomCenter.subtract(viewBoxSize.x / 2.0, 0.0, viewBoxSize.z / 2.0), boxBottomCenter.add(viewBoxSize.x / 2.0, viewBoxSize.y, viewBoxSize.z / 2.0));
    }

    public static Vec3 getBoxBottomCenter(AABB box) {
        return new Vec3((box.maxX + box.minX) / 2.0, box.minY, (box.maxZ + box.minZ) / 2.0);
    }

    public static double getDistanceToRectangle(double pointX, double pointY, double rectAX, double rectAY, double rectBX, double rectBY) {
        assert (rectAX <= rectBX);
        assert (rectAY <= rectBY);
        double wx1 = rectAX - pointX;
        double wx2 = rectBX - pointX;
        double dx = wx1 * wx2 < 0.0 ? 0.0 : Math.min(Math.abs(wx1), Math.abs(wx2));
        double wy1 = rectAY - pointY;
        double wy2 = rectBY - pointY;
        double dy = wy1 * wy2 < 0.0 ? 0.0 : Math.min(Math.abs(wy1), Math.abs(wy2));
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static <T> void swapListElement(List<T> entries, int i1, int i2) {
        T temp = entries.get(i1);
        entries.set(i1, entries.get(i2));
        entries.set(i2, temp);
    }

    public static double crossProduct2D(double x1, double y1, double x2, double y2) {
        return x1 * y2 - x2 * y1;
    }

    public static ResourceKey<Level> dimIdToKey(ResourceLocation identifier) {
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)identifier);
    }

    public static ResourceKey<Level> dimIdToKey(String str) {
        return Helper.dimIdToKey(McHelper.newResourceLocation(str));
    }

    public static void putWorldId(CompoundTag tag, String tagName, ResourceKey<Level> dim) {
        tag.putString(tagName, dim.location().toString());
    }

    public static ResourceKey<Level> getWorldId(CompoundTag tag, String tagName) {
        Tag term = tag.get(tagName);
        if (term instanceof StringTag) {
            String id = ((StringTag)term).getAsString();
            return Helper.dimIdToKey(id);
        }
        LOGGER.error("Cannot read world intId from {}. Fallback to overworld", (Object)tag);
        return Level.OVERWORLD;
    }

    @Nullable
    public static <T> T getLastSatisfying(Stream<T> stream, Predicate<T> predicate) {
        T last = null;
        Iterator iterator = stream.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (predicate.test(obj)) {
                last = obj;
                continue;
            }
            return last;
        }
        return last;
    }

    public static void doNotEatExceptionMessage(Runnable func) {
        try {
            func.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static <T> String myToString(Stream<T> stream) {
        StringBuilder stringBuilder = new StringBuilder();
        stream.forEach(obj -> {
            stringBuilder.append(obj.toString());
            stringBuilder.append('\n');
        });
        return stringBuilder.toString();
    }

    public static <A, B> Stream<Tuple<A, B>> composeTwoStreamsWithEqualLength(Stream<A> a, Stream<B> b) {
        final Iterator aIterator = a.iterator();
        final Iterator bIterator = b.iterator();
        Iterator iterator = new Iterator<Tuple<A, B>>(){

            @Override
            public boolean hasNext() {
                assert (aIterator.hasNext() == bIterator.hasNext());
                return aIterator.hasNext();
            }

            @Override
            public Tuple<A, B> next() {
                return new Tuple(aIterator.next(), bIterator.next());
            }
        };
        return Streams.stream((Iterator)iterator);
    }

    @Deprecated
    public static void log(Object str) {
        LOGGER.info(str);
    }

    @Deprecated
    public static void err(Object str) {
        LOGGER.error(str);
    }

    public static Vec3[] eightVerticesOf(AABB box) {
        return new Vec3[]{new Vec3(box.minX, box.minY, box.minZ), new Vec3(box.minX, box.minY, box.maxZ), new Vec3(box.minX, box.maxY, box.minZ), new Vec3(box.minX, box.maxY, box.maxZ), new Vec3(box.maxX, box.minY, box.minZ), new Vec3(box.maxX, box.minY, box.maxZ), new Vec3(box.maxX, box.maxY, box.minZ), new Vec3(box.maxX, box.maxY, box.maxZ)};
    }

    public static void putVec3d(CompoundTag compoundTag, String name, Vec3 vec3d) {
        compoundTag.putDouble(name + "X", vec3d.x);
        compoundTag.putDouble(name + "Y", vec3d.y);
        compoundTag.putDouble(name + "Z", vec3d.z);
    }

    public static Vec3 getVec3d(CompoundTag compoundTag, String name) {
        return new Vec3(compoundTag.getDouble(name + "X"), compoundTag.getDouble(name + "Y"), compoundTag.getDouble(name + "Z"));
    }

    @Nullable
    public static Vec3 getVec3dOptional(CompoundTag compoundTag, String name) {
        if (compoundTag.contains(name + "X")) {
            return Helper.getVec3d(compoundTag, name);
        }
        return null;
    }

    public static void putVec3i(CompoundTag compoundTag, String name, Vec3i vec3i) {
        compoundTag.putInt(name + "X", vec3i.getX());
        compoundTag.putInt(name + "Y", vec3i.getY());
        compoundTag.putInt(name + "Z", vec3i.getZ());
    }

    public static BlockPos getVec3i(CompoundTag compoundTag, String name) {
        return new BlockPos(compoundTag.getInt(name + "X"), compoundTag.getInt(name + "Y"), compoundTag.getInt(name + "Z"));
    }

    public static void putQuaternion(CompoundTag compoundTag, String name, @Nullable DQuaternion quaternion) {
        if (quaternion != null) {
            compoundTag.putDouble(name + "X", quaternion.getX());
            compoundTag.putDouble(name + "Y", quaternion.getY());
            compoundTag.putDouble(name + "Z", quaternion.getZ());
            compoundTag.putDouble(name + "W", quaternion.getW());
        }
    }

    @Nullable
    public static DQuaternion getQuaternion(CompoundTag compoundTag, String name) {
        if (compoundTag.contains(name + "X")) {
            return new DQuaternion(compoundTag.getDouble(name + "X"), compoundTag.getDouble(name + "Y"), compoundTag.getDouble(name + "Z"), compoundTag.getDouble(name + "W"));
        }
        return null;
    }

    public static ListTag getCompoundList(CompoundTag tag, String name) {
        return tag.getList(name, 10);
    }

    public static <X> ArrayList<X> listTagToList(ListTag listTag, Function<CompoundTag, X> deserializer) {
        return Helper.listTagDeserialize(listTag, deserializer, CompoundTag.class);
    }

    public static <X> ListTag listToListTag(List<X> list, Function<X, CompoundTag> serializer) {
        return Helper.listTagSerialize(list, serializer);
    }

    public static <X, TT extends Tag> ArrayList<X> listTagDeserialize(ListTag listTag, Function<TT, X> deserializer, Class<TT> tagClass) {
        ArrayList result = new ArrayList();
        listTag.forEach(tag -> {
            if (tag.getClass() == tagClass) {
                Object obj = deserializer.apply(tag);
                if (obj != null) {
                    result.add(obj);
                }
            } else {
                LOGGER.error("Unexpected tag class: {}", (Object)tag.getClass(), (Object)new Throwable());
            }
        });
        return result;
    }

    public static <X, TT extends Tag> ListTag listTagSerialize(List<X> list, Function<X, TT> serializer) {
        ListTag listTag = new ListTag();
        for (X x : list) {
            listTag.add((Object)((Tag)serializer.apply(x)));
        }
        return listTag;
    }

    public static <T> void compareOldAndNew(Set<T> oldSet, Set<T> newSet, Consumer<T> forRemoved, Consumer<T> forAdded) {
        oldSet.stream().filter(e -> !newSet.contains(e)).forEach(forRemoved);
        newSet.stream().filter(e -> !oldSet.contains(e)).forEach(forAdded);
    }

    public static long secondToNano(double second) {
        return (long)(second * 1.0E9);
    }

    public static double nanoToSecond(long nano) {
        return (double)nano / 1.0E9;
    }

    public static IntBox expandArea(IntBox originalArea, Predicate<BlockPos> predicate, Direction direction) {
        IntBox currentBox = originalArea;
        for (int i = 1; i < 42; ++i) {
            IntBox expanded = currentBox.getExpanded(direction, 1);
            if (!expanded.getSurfaceLayer(direction).stream().allMatch(predicate)) {
                return currentBox;
            }
            currentBox = expanded;
        }
        return currentBox;
    }

    public static <A, B> B reduce(B start, Stream<A> stream, BiFunction<B, A, B> func) {
        return stream.reduce(start, func, (a, b) -> {
            throw new IllegalStateException("combiner should only be used in parallel");
        });
    }

    public static <T> T noError(Callable<T> func) {
        try {
            return func.call();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> void removeIf(ObjectList<T> list, Predicate<T> predicate) {
        int placingIndex = 0;
        for (int i = 0; i < list.size(); ++i) {
            Object curr = list.get(i);
            if (predicate.test(curr)) continue;
            list.set(placingIndex, curr);
            ++placingIndex;
        }
        list.removeElements(placingIndex, list.size());
    }

    public static <T> void removeIfWithEarlyExit(ObjectList<T> list, BiPredicate<T, MutableBoolean> predicate) {
        MutableBoolean shouldStop = new MutableBoolean(false);
        int placingIndex = 0;
        for (int i = 0; i < list.size(); ++i) {
            Object curr = list.get(i);
            if (!shouldStop.booleanValue() && predicate.test(curr, shouldStop)) continue;
            list.set(placingIndex, curr);
            ++placingIndex;
        }
        list.removeElements(placingIndex, list.size());
    }

    public static <T, S> Stream<S> wrapAdjacentAndMap(Stream<T> stream, final BiFunction<T, T, S> function) {
        final Iterator iterator = stream.iterator();
        return Streams.stream((Iterator)new Iterator<S>(){
            private boolean isBuffered = false;
            private T buffer;

            private void fillBuffer() {
                if (!this.isBuffered) {
                    assert (iterator.hasNext());
                    this.isBuffered = true;
                    this.buffer = iterator.next();
                }
            }

            private T takeBuffer() {
                assert (this.isBuffered);
                this.isBuffered = false;
                return this.buffer;
            }

            @Override
            public boolean hasNext() {
                if (!iterator.hasNext()) {
                    return false;
                }
                this.fillBuffer();
                return iterator.hasNext();
            }

            @Override
            public S next() {
                this.fillBuffer();
                Object a = this.takeBuffer();
                this.fillBuffer();
                return function.apply(a, this.buffer);
            }
        });
    }

    public static <A, B> Stream<B> mapReduce(Stream<A> stream, BiFunction<B, A, B> func, SimpleBox<B> startValue) {
        return stream.map(a -> {
            startValue.obj = func.apply(startValue.obj, a);
            return startValue.obj;
        });
    }

    public static <T, S> Stream<S> wrapAdjacentAndMap1(Stream<T> stream, BiFunction<T, T, S> function) {
        Iterator iterator = stream.iterator();
        if (!iterator.hasNext()) {
            return Stream.empty();
        }
        Object firstValue = iterator.next();
        Stream newStream = Streams.stream(iterator);
        return Helper.mapReduce(newStream, (lastPair, curr) -> new Tuple(curr, function.apply(lastPair.getA(), curr)), new SimpleBox<Tuple>(new Tuple(firstValue, null))).map(pair -> pair.getB());
    }

    public static <T> T makeIntoExpression(T t, Consumer<T> func) {
        func.accept(t);
        return t;
    }

    public static void putUuid(CompoundTag tag, String key, UUID uuid) {
        tag.putLong(key + "Most", uuid.getMostSignificantBits());
        tag.putLong(key + "Least", uuid.getLeastSignificantBits());
    }

    @Nullable
    public static UUID getUuid(CompoundTag tag, String key) {
        String key1 = key + "Most";
        if (!tag.contains(key1)) {
            return null;
        }
        return new UUID(tag.getLong(key1), tag.getLong(key + "Least"));
    }

    public static Vec3 getFlippedVec(Vec3 vec, Vec3 flippingAxis) {
        Vec3 component = Helper.getProjection(vec, flippingAxis);
        return vec.subtract(component).scale(-1.0).add(component);
    }

    public static Vec3 getProjection(Vec3 vec, Vec3 direction) {
        return direction.scale(vec.dot(direction));
    }

    public static Direction getFacingExcludingAxis(Vec3 vec, Direction.Axis axis) {
        return Arrays.stream(Direction.values()).filter(d -> d.getAxis() != axis).max(Comparator.comparingDouble(dir -> vec.x * (double)dir.getStepX() + vec.y * (double)dir.getStepY() + vec.z * (double)dir.getStepZ())).orElse(null);
    }

    public static <T> Supplier<T> cached(final Supplier<T> supplier) {
        return new Supplier<T>(){
            T cache = null;

            @Override
            public T get() {
                if (this.cache == null) {
                    this.cache = supplier.get();
                }
                Validate.notNull(this.cache);
                return this.cache;
            }
        };
    }

    public static <T> int indexOf(List<T> list, Predicate<T> predicate) {
        for (int i = 0; i < list.size(); ++i) {
            T ele = list.get(i);
            if (!predicate.test(ele)) continue;
            return i;
        }
        return -1;
    }

    public static List<String> splitStringByLen(String str, int len) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i * len < str.length()) {
            result.add(str.substring(i * len, Math.min(str.length(), (i + 1) * len)));
            ++i;
        }
        return result;
    }

    public static AABB transformBox(AABB box, Function<Vec3, Vec3> function) {
        List result = Arrays.stream(Helper.eightVerticesOf(box)).map(function).collect(Collectors.toList());
        return new AABB(result.stream().mapToDouble(b -> b.x).min().getAsDouble(), result.stream().mapToDouble(b -> b.y).min().getAsDouble(), result.stream().mapToDouble(b -> b.z).min().getAsDouble(), result.stream().mapToDouble(b -> b.x).max().getAsDouble(), result.stream().mapToDouble(b -> b.y).max().getAsDouble(), result.stream().mapToDouble(b -> b.z).max().getAsDouble());
    }

    public static double getDistanceToRange(double start, double end, double pos) {
        Validate.isTrue((end >= start ? 1 : 0) != 0);
        if (pos >= start) {
            if (pos <= end) {
                return 0.0;
            }
            return pos - end;
        }
        return start - pos;
    }

    public static double getSignedDistanceToRange(double start, double end, double pos) {
        Validate.isTrue((end >= start ? 1 : 0) != 0);
        if (pos >= start) {
            if (pos <= end) {
                return -Math.min(pos - start, end - pos);
            }
            return pos - end;
        }
        return start - pos;
    }

    public static double getDistanceToBox(AABB box, Vec3 point) {
        double dx = Helper.getDistanceToRange(box.minX, box.maxX, point.x);
        double dy = Helper.getDistanceToRange(box.minY, box.maxY, point.y);
        double dz = Helper.getDistanceToRange(box.minZ, box.maxZ, point.z);
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double getSignedDistanceToBox(AABB aabb, Vec3 point) {
        double dx = Helper.getSignedDistanceToRange(aabb.minX, aabb.maxX, point.x);
        double dy = Helper.getSignedDistanceToRange(aabb.minY, aabb.maxY, point.y);
        double dz = Helper.getSignedDistanceToRange(aabb.minZ, aabb.maxZ, point.z);
        double l = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (dx < 0.0 && dy < 0.0 && dz < 0.0) {
            return -l;
        }
        return l;
    }

    public static <T> T firstOf(List<T> list) {
        Validate.isTrue((!list.isEmpty() ? 1 : 0) != 0);
        return list.get(0);
    }

    public static <T> T lastOf(List<T> list) {
        Validate.isTrue((!list.isEmpty() ? 1 : 0) != 0);
        return list.get(list.size() - 1);
    }

    @Nullable
    public static <T> T combineNullable(@Nullable T a, @Nullable T b, BiFunction<T, T, T> combiner) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return combiner.apply(a, b);
    }

    public static <T> T arrayListComputeIfAbsent(List<T> arrayList, int index, Supplier<T> supplier) {
        T value;
        if (arrayList.size() <= index) {
            while (arrayList.size() <= index) {
                arrayList.add(null);
            }
        }
        if ((value = arrayList.get(index)) == null) {
            value = supplier.get();
            arrayList.set(index, value);
        }
        return value;
    }

    public static <T> void arrayListKeyValueForeach(ArrayList<T> arrayList, IntObjectConsumer<T> func) {
        for (int i = 0; i < arrayList.size(); ++i) {
            T value = arrayList.get(i);
            if (value == null) continue;
            func.consume(i, value);
        }
    }

    public static Object reflectionInvoke(Object target, String methodName) {
        return Helper.noError(() -> {
            Method method = target.getClass().getDeclaredMethod(methodName, new Class[0]);
            return method.invoke(target, new Object[0]);
        });
    }

    public static Vec3 interpolatePos(Vec3 from, Vec3 to, double progress) {
        return from.lerp(to, progress);
    }

    public static <T> T getFirstNullable(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public static <T> T minBy(T a, T b, Comparator<T> comparator) {
        if (comparator.compare(a, b) <= 0) {
            return a;
        }
        return b;
    }

    public static <T> T maxBy(T a, T b, Comparator<T> comparator) {
        if (comparator.compare(a, b) >= 0) {
            return a;
        }
        return b;
    }

    public static boolean boxContains(AABB outer, AABB inner) {
        return outer.contains(inner.minX, inner.minY, inner.minZ) && outer.contains(inner.maxX, inner.maxY, inner.maxZ);
    }

    public static <A, B> List<B> mappedListView(final List<A> originalList, final Function<A, B> mapping) {
        return new AbstractList<B>(){

            @Override
            public B get(int index) {
                return mapping.apply(originalList.get(index));
            }

            @Override
            public int size() {
                return originalList.size();
            }
        };
    }

    public static OptionalDouble parseDouble(String str) {
        try {
            return OptionalDouble.of(Double.parseDouble(str));
        }
        catch (NumberFormatException e) {
            return OptionalDouble.empty();
        }
    }

    public static OptionalInt parseInt(String str) {
        try {
            return OptionalInt.of(Integer.parseInt(str));
        }
        catch (NumberFormatException e) {
            return OptionalInt.empty();
        }
    }

    public static List<Vec3> deduplicateWithPrecision(Collection<Vec3> points, int precision) {
        HashSet<LongBlockPos> set = new HashSet<LongBlockPos>();
        for (Vec3 point : points) {
            set.add(new LongBlockPos(Math.round(point.x * (double)precision), Math.round(point.y * (double)precision), Math.round(point.z * (double)precision)));
        }
        return set.stream().map(blockPos -> new Vec3((double)blockPos.x() / (double)precision, (double)blockPos.y() / (double)precision, (double)blockPos.z() / (double)precision)).collect(Collectors.toList());
    }

    public static double getDistanceFromPointToLine(Vec3 point, Vec3 lineOrigin, Vec3 lineDirection) {
        Vec3 lineDirectionNormalized = lineDirection.normalize();
        Vec3 pointToLineOrigin = lineOrigin.subtract(point);
        Vec3 pointToLineOriginProjected = pointToLineOrigin.subtract(lineDirectionNormalized.scale(pointToLineOrigin.dot(lineDirectionNormalized)));
        return pointToLineOriginProjected.length();
    }

    public static void traverseBoxEdge(BoxEdgeConsumer consumer) {
        int dz;
        int dx;
        for (dx = 0; dx <= 1; ++dx) {
            for (int dy = 0; dy <= 1; ++dy) {
                consumer.consume(dx, dy, 0, dx, dy, 1);
            }
        }
        for (dx = 0; dx <= 1; ++dx) {
            for (dz = 0; dz <= 1; ++dz) {
                consumer.consume(dx, 0, dz, dx, 1, dz);
            }
        }
        for (int dy = 0; dy <= 1; ++dy) {
            for (dz = 0; dz <= 1; ++dz) {
                consumer.consume(0, dy, dz, 1, dy, dz);
            }
        }
    }

    public static List<Vec3> verticesAndEdgeMidpoints(AABB box) {
        ArrayList<Vec3> result = new ArrayList<Vec3>();
        for (int xi = 0; xi <= 2; ++xi) {
            for (int yi = 0; yi <= 2; ++yi) {
                for (int zi = 0; zi <= 2; ++zi) {
                    if (xi == 1 && yi == 1 && zi == 1) continue;
                    double x = box.minX + (double)xi / 2.0 * (box.maxX - box.minX);
                    double y = box.minY + (double)yi / 2.0 * (box.maxY - box.minY);
                    double z = box.minZ + (double)zi / 2.0 * (box.maxZ - box.minZ);
                    result.add(new Vec3(x, y, z));
                }
            }
        }
        return result;
    }

    public static Vec3 alignToBoxSurface(AABB box, Vec3 pos, int gridCount) {
        double x = pos.x;
        double y = pos.y;
        double z = pos.z;
        if (x < box.minX) {
            x = box.minX;
        }
        if (y < box.minY) {
            y = box.minY;
        }
        if (z < box.minZ) {
            z = box.minZ;
        }
        if (x > box.maxX) {
            x = box.maxX;
        }
        if (y > box.maxY) {
            y = box.maxY;
        }
        if (z > box.maxZ) {
            z = box.maxZ;
        }
        double boxSizeX = box.getXsize();
        double boxSizeY = box.getYsize();
        double boxSizeZ = box.getZsize();
        double xOffset = x - box.minX;
        double yOffset = y - box.minY;
        double zOffset = z - box.minZ;
        xOffset = (double)Math.round(xOffset * (double)gridCount) / (double)gridCount;
        yOffset = (double)Math.round(yOffset * (double)gridCount) / (double)gridCount;
        zOffset = (double)Math.round(zOffset * (double)gridCount) / (double)gridCount;
        double distanceToXMin = xOffset;
        double distanceToXMax = boxSizeX - xOffset;
        double distanceToYMin = yOffset;
        double distanceToYMax = boxSizeY - yOffset;
        double distanceToZMin = zOffset;
        double distanceToZMax = boxSizeZ - zOffset;
        double minDistance = Math.min(Math.min(distanceToXMin, distanceToXMax), Math.min(Math.min(distanceToYMin, distanceToYMax), Math.min(distanceToZMin, distanceToZMax)));
        if (minDistance == distanceToXMin) {
            xOffset = 0.0;
        } else if (minDistance == distanceToXMax) {
            xOffset = boxSizeX;
        } else if (minDistance == distanceToYMin) {
            yOffset = 0.0;
        } else if (minDistance == distanceToYMax) {
            yOffset = boxSizeY;
        } else if (minDistance == distanceToZMin) {
            zOffset = 0.0;
        } else if (minDistance == distanceToZMax) {
            zOffset = boxSizeZ;
        }
        return new Vec3(box.minX + xOffset, box.minY + yOffset, box.minZ + zOffset);
    }

    public static int compactArrayStorage(int arraySize, IntPredicate isElementValid, SwappingFunc swap) {
        int validElementCount = 0;
        int invalidElementCount = 0;
        block0: while (validElementCount + invalidElementCount < arraySize) {
            if (isElementValid.test(validElementCount)) {
                ++validElementCount;
                continue;
            }
            int invalidElementIndex = arraySize - ++invalidElementCount;
            while (invalidElementIndex > validElementCount) {
                if (isElementValid.test(invalidElementIndex)) {
                    swap.swap(invalidElementIndex, validElementCount);
                    ++validElementCount;
                    continue block0;
                }
                invalidElementIndex = arraySize - ++invalidElementCount;
            }
        }
        return validElementCount;
    }

    public static <T> Stream<T> listReverseStream(final List<T> list) {
        return Streams.stream((Iterator)new Iterator<T>(){
            int index;
            {
                this.index = list.size() - 1;
            }

            @Override
            public boolean hasNext() {
                return this.index >= 0;
            }

            @Override
            public T next() {
                int i = this.index--;
                return list.get(i);
            }
        });
    }

    public static ListTag vec3ToListTag(Vec3 vec) {
        ListTag listTag = new ListTag();
        listTag.add((Object)DoubleTag.valueOf((double)vec.x));
        listTag.add((Object)DoubleTag.valueOf((double)vec.y));
        listTag.add((Object)DoubleTag.valueOf((double)vec.z));
        return listTag;
    }

    @Nullable
    public static Vec3 vec3FromListTag(Tag tag) {
        ListTag listTag;
        if (tag instanceof ListTag && (listTag = (ListTag)tag).getElementType() == 6 && listTag.size() == 3) {
            return new Vec3(listTag.getDouble(0), listTag.getDouble(1), listTag.getDouble(2));
        }
        return null;
    }

    public static AABB boundingBoxOfPoints(Vec3[] arr) {
        Validate.isTrue((arr.length != 0 ? 1 : 0) != 0, (String)"arr must not be empty", (Object[])new Object[0]);
        double minX = arr[0].x;
        double minY = arr[0].y;
        double minZ = arr[0].z;
        double maxX = arr[0].x;
        double maxY = arr[0].y;
        double maxZ = arr[0].z;
        for (int i = 1; i < arr.length; ++i) {
            Vec3 vec3 = arr[i];
            minX = Math.min(minX, vec3.x);
            minY = Math.min(minY, vec3.y);
            minZ = Math.min(minZ, vec3.z);
            maxX = Math.max(maxX, vec3.x);
            maxY = Math.max(maxY, vec3.y);
            maxZ = Math.max(maxZ, vec3.z);
        }
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static class SimpleBox<T> {
        public T obj;

        public SimpleBox(T obj) {
            this.obj = obj;
        }
    }

    public static interface IntObjectConsumer<T> {
        public void consume(int var1, T var2);
    }

    public static interface BoxEdgeConsumer {
        public void consume(int var1, int var2, int var3, int var4, int var5, int var6);
    }

    @FunctionalInterface
    public static interface SwappingFunc {
        public void swap(int var1, int var2);
    }
}

