/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util;

import java.util.TreeMap;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;
import qouteall.q_misc_util.Helper;

public class CustomTextOverlay {
    private static final TreeMap<String, Entry> ENTRIES = new TreeMap();
    private static final boolean renderAtBottomCenter = true;
    @Nullable
    private static MultiLineLabel multiLineLabelCache;

    public static void putText(Component component, double durationSeconds, String key) {
        ENTRIES.put(key, new Entry(component, System.nanoTime() + Helper.secondToNano(durationSeconds)));
        multiLineLabelCache = null;
    }

    public static void putText(Component component, double durationSeconds) {
        CustomTextOverlay.putText(component, durationSeconds, "5_defaultKey");
    }

    public static void putText(Component component, String key) {
        CustomTextOverlay.putText(component, 0.2, key);
    }

    public static void putText(Component component) {
        CustomTextOverlay.putText(component, 0.2, "5_defaultKey");
    }

    public static boolean remove(String key) {
        return ENTRIES.remove(key) != null;
    }

    public static void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        long currTime = System.nanoTime();
        boolean removes = ENTRIES.entrySet().removeIf(e -> ((Entry)e.getValue()).clearingTime < currTime);
        if (removes) {
            multiLineLabelCache = null;
        }
        if (ENTRIES.isEmpty()) {
            return;
        }
        if (multiLineLabelCache == null) {
            MutableComponent component = Component.empty();
            boolean isBeginning = true;
            for (Entry entry : ENTRIES.values()) {
                if (isBeginning) {
                    isBeginning = false;
                } else {
                    component.append("\n");
                }
                component.append(entry.component());
            }
            multiLineLabelCache = MultiLineLabel.create((Font)Minecraft.getInstance().font, (Component)component, (int)(Minecraft.getInstance().getWindow().getGuiScaledWidth() - 20));
            assert (multiLineLabelCache != null);
        }
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.pose().pushPose();
        int guiScaledWidth = minecraft.getWindow().getGuiScaledWidth();
        int guiScaledHeight = minecraft.getWindow().getGuiScaledHeight();
        Font font = minecraft.gui.getFont();
        minecraft.getProfiler().push("imm_ptl_custom_overlay");
        multiLineLabelCache.renderCentered(guiGraphics, guiScaledWidth / 2, (int)((double)guiScaledHeight * 0.75));
        guiGraphics.pose().popPose();
        minecraft.getProfiler().pop();
    }

    public record Entry(Component component, long clearingTime) {
    }
}

