/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.wand;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.mc_utils.WireRenderingHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.peripheral.wand.ProtoPortalSide;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.IntBox;

public class WandUtil {
    @Nullable
    public static Portal getClientPortalByUUID(UUID portalId) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return null;
        }
        Level world = player.level();
        return WandUtil.getPortalByUUID(world, portalId);
    }

    @Nullable
    public static Portal getPortalByUUID(Level world, UUID portalId) {
        if (portalId == null) {
            return null;
        }
        Entity entity = McHelper.getEntityByUUID(world, portalId);
        if (entity instanceof Portal) {
            Portal portal = (Portal)entity;
            return portal;
        }
        return null;
    }

    public static Vec3 alignOnBlocks(Level world, Vec3 vec3, int gridCount) {
        if (gridCount == 0) {
            return vec3;
        }
        BlockPos blockPos = BlockPos.containing((Position)vec3);
        return new IntBox(blockPos.offset(-1, -1, -1), blockPos.offset(1, 1, 1)).stream().flatMap(pos -> {
            BlockState blockState = world.getBlockState(pos);
            VoxelShape collisionShape = blockState.getCollisionShape((BlockGetter)world, pos).move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            List aabbs = collisionShape.toAabbs();
            if (aabbs.size() != 1) {
                aabbs.add(new AABB(pos));
            }
            return aabbs.stream();
        }).map(box -> Helper.alignToBoxSurface(box, vec3, gridCount)).min(Comparator.comparingDouble(p -> p.distanceToSqr(vec3))).orElse(null);
    }

    public static void renderPortalAreaGridNew(VertexConsumer vertexConsumer, Vec3 cameraPos, ProtoPortalSide protoPortalSide, int color1, int color2, PoseStack matrixStack) {
        int separation = 8;
        Vec3 leftBottom = protoPortalSide.leftBottom;
        Vec3 rightBottom = protoPortalSide.rightBottom;
        Vec3 leftTop = protoPortalSide.leftTop;
        Vec3 xAxis = rightBottom.subtract(leftBottom);
        Vec3 yAxis = leftTop.subtract(leftBottom);
        Vec3 normal = xAxis.cross(yAxis).normalize();
        matrixStack.pushPose();
        matrixStack.translate(leftBottom.x - cameraPos.x, leftBottom.y - cameraPos.y, leftBottom.z - cameraPos.z);
        Matrix4f matrix = matrixStack.last().pose();
        Matrix3f normalMatrix = matrixStack.last().normal();
        WireRenderingHelper.putLine(vertexConsumer, color1, matrix, normalMatrix, Vec3.ZERO, xAxis);
        WireRenderingHelper.putLine(vertexConsumer, color1, matrix, normalMatrix, yAxis, yAxis.add(xAxis));
        WireRenderingHelper.putLine(vertexConsumer, color1, matrix, normalMatrix, Vec3.ZERO, yAxis);
        WireRenderingHelper.putLine(vertexConsumer, color1, matrix, normalMatrix, xAxis, yAxis.add(xAxis));
        int flowCount = 3;
        Random random = new Random(color1);
        double scaling = 0.994;
        double offset1 = (1.0 - scaling) / 2.0;
        double offset2 = -offset1;
        for (int cx = 1; cx < separation; ++cx) {
            double lx = (double)cx / (double)separation;
            WireRenderingHelper.renderFlowLines(vertexConsumer, new Vec3[]{xAxis.scale(lx * scaling + offset1), xAxis.scale(lx * scaling + offset1).add(yAxis)}, flowCount, color1, 1, matrixStack, () -> random.nextInt(10, 100));
            WireRenderingHelper.renderFlowLines(vertexConsumer, new Vec3[]{xAxis.scale(lx * scaling + offset2), xAxis.scale(lx * scaling + offset2).add(yAxis)}, flowCount, color2, -1, matrixStack, () -> random.nextInt(10, 100));
        }
        for (int cy = 1; cy < separation; ++cy) {
            double ly = (double)cy / (double)separation;
            WireRenderingHelper.renderFlowLines(vertexConsumer, new Vec3[]{yAxis.scale(ly * scaling + offset1), yAxis.scale(ly * scaling + offset1).add(xAxis)}, flowCount, color1, 1, matrixStack, () -> random.nextInt(10, 100));
            WireRenderingHelper.renderFlowLines(vertexConsumer, new Vec3[]{yAxis.scale(ly * scaling + offset2), yAxis.scale(ly * scaling + offset2).add(xAxis)}, flowCount, color2, -1, matrixStack, () -> random.nextInt(10, 100));
        }
        matrixStack.popPose();
    }

    public static void renderPortalAreaGrid(VertexConsumer vertexConsumer, Vec3 cameraPos, ProtoPortalSide protoPortalSide, int color, PoseStack matrixStack) {
        Vec3 lineEnd;
        Vec3 lineStart;
        double ratio;
        int i;
        int separation = 8;
        Vec3 leftBottom = protoPortalSide.leftBottom;
        Vec3 rightBottom = protoPortalSide.rightBottom;
        Vec3 leftTop = protoPortalSide.leftTop;
        Vec3 xAxis = rightBottom.subtract(leftBottom);
        Vec3 yAxis = leftTop.subtract(leftBottom);
        Vec3 normal = xAxis.cross(yAxis).normalize();
        matrixStack.pushPose();
        matrixStack.translate(leftBottom.x - cameraPos.x, leftBottom.y - cameraPos.y, leftBottom.z - cameraPos.z);
        Matrix4f matrix = matrixStack.last().pose();
        Matrix3f normalMatrix = matrixStack.last().normal();
        for (i = 0; i <= separation; ++i) {
            ratio = (double)i / (double)separation;
            lineStart = xAxis.scale(ratio);
            lineEnd = xAxis.scale(ratio).add(yAxis);
            WireRenderingHelper.putLine(vertexConsumer, color, yAxis.normalize(), matrix, normalMatrix, lineStart, lineEnd);
        }
        for (i = 0; i <= separation; ++i) {
            ratio = (double)i / (double)separation;
            lineStart = yAxis.scale(ratio);
            lineEnd = yAxis.scale(ratio).add(xAxis);
            WireRenderingHelper.putLine(vertexConsumer, color, xAxis.normalize(), matrix, normalMatrix, lineStart, lineEnd);
        }
        matrixStack.popPose();
    }
}

