/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.wand;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.peripheral.wand.ProtoPortalSide;
import qouteall.q_misc_util.my_util.Circle;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.WithDim;

public class ProtoPortal {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    public ProtoPortalSide firstSide;
    @Nullable
    public ProtoPortalSide secondSide;

    public ProtoPortal copy() {
        ProtoPortal newPortal = new ProtoPortal();
        newPortal.firstSide = this.firstSide == null ? null : this.firstSide.copy();
        newPortal.secondSide = this.secondSide == null ? null : this.secondSide.copy();
        return newPortal;
    }

    public void reset() {
        this.firstSide = null;
        this.secondSide = null;
    }

    public boolean isComplete() {
        return this.firstSide != null && this.secondSide != null && this.secondSide.isComplete();
    }

    public boolean isValidPlacement() {
        if (this.firstSide != null) {
            if (!this.firstSide.isValidPlacement(null)) {
                return false;
            }
            if (this.secondSide != null) {
                Validate.isTrue((boolean)this.firstSide.isComplete());
                double heightDivWidth = this.firstSide.getHeightDivWidth();
                return this.secondSide.isValidPlacement(heightDivWidth);
            }
        }
        return true;
    }

    @Nullable
    public ResourceKey<Level> getCursorConstraintDim() {
        if (this.firstSide != null && !this.firstSide.isComplete()) {
            return this.firstSide.dimension;
        }
        if (this.secondSide != null && !this.secondSide.isComplete()) {
            return this.secondSide.dimension;
        }
        return null;
    }

    @Nullable
    public WithDim<Plane> getCursorConstraintPlane() {
        WithDim<Plane> plane;
        if (this.firstSide != null && (plane = this.firstSide.getCursorConstraintPlane()) != null) {
            return plane;
        }
        if (this.secondSide != null) {
            plane = this.secondSide.getCursorConstraintPlane();
            return plane;
        }
        return null;
    }

    @Nullable
    public WithDim<Circle> getCursorConstraintCircle() {
        if (this.firstSide != null && this.secondSide != null) {
            double heightDivWidth = this.firstSide.getHeightDivWidth();
            return this.secondSide.getCursorConstraintCircle(heightDivWidth);
        }
        return null;
    }

    public boolean tryPlaceCursor(ResourceKey<Level> dimension, Vec3 pos) {
        if (this.firstSide == null) {
            this.firstSide = new ProtoPortalSide(dimension, pos);
            return true;
        }
        if (!this.firstSide.isComplete()) {
            if (dimension != this.firstSide.dimension) {
                return false;
            }
            this.firstSide.placeCursor(pos);
            return true;
        }
        if (this.secondSide == null) {
            this.secondSide = new ProtoPortalSide(dimension, pos);
            return true;
        }
        if (!this.secondSide.isComplete()) {
            if (dimension != this.secondSide.dimension) {
                LOGGER.error("cursor dimension mismatch {} {}", dimension, this.secondSide.dimension);
                return false;
            }
            this.secondSide.placeCursor(pos);
            return true;
        }
        return false;
    }

    public void undo() {
        if (this.secondSide != null) {
            this.secondSide = this.secondSide.undo();
            return;
        }
        if (this.firstSide != null) {
            this.firstSide = this.firstSide.undo();
        }
    }

    @Nullable
    public MutableComponent getPromptMessage(@Nullable ProtoPortal pendingState) {
        if (this.firstSide == null) {
            return Component.translatable((String)"imm_ptl.wand.first_side_left_bottom", (Object[])new Object[]{Minecraft.getInstance().options.keyUse.getTranslatedKeyMessage()});
        }
        MutableComponent undoPrompt = Component.literal((String)"\n").append((Component)Component.translatable((String)"imm_ptl.wand.left_click_to_undo", (Object[])new Object[]{Minecraft.getInstance().options.keyAttack.getTranslatedKeyMessage()}));
        if (this.firstSide.rightBottom == null) {
            String widthStr = pendingState == null ? "?" : String.format("%.3f", Objects.requireNonNull(pendingState.firstSide).getWidth());
            return Component.translatable((String)"imm_ptl.wand.first_side_right_bottom", (Object[])new Object[]{widthStr}).append((Component)undoPrompt);
        }
        if (this.firstSide.leftTop == null) {
            String widthStr = pendingState == null ? "?" : String.format("%.3f", Objects.requireNonNull(pendingState.firstSide).getWidth());
            String heightStr = pendingState == null ? "?" : String.format("%.3f", Objects.requireNonNull(pendingState.firstSide).getHeight());
            return Component.translatable((String)"imm_ptl.wand.first_side_left_up", (Object[])new Object[]{widthStr, heightStr}).append((Component)undoPrompt);
        }
        if (this.secondSide == null) {
            return Component.translatable((String)"imm_ptl.wand.second_side_left_bottom").append((Component)undoPrompt);
        }
        if (this.secondSide.rightBottom == null) {
            String widthStr = "?";
            String heightStr = "?";
            String scaleStr = "?";
            if (pendingState != null) {
                Validate.notNull((Object)pendingState.firstSide);
                Validate.notNull((Object)pendingState.secondSide);
                double width = pendingState.secondSide.getWidth();
                double heightDivWidth = pendingState.firstSide.getHeightDivWidth();
                double height = width * heightDivWidth;
                double scale = width / pendingState.firstSide.getWidth();
                widthStr = String.format("%.3f", width);
                heightStr = String.format("%.3f", height);
                scaleStr = String.format("%.3f", scale);
            }
            return Component.translatable((String)"imm_ptl.wand.second_side_right_bottom", (Object[])new Object[]{widthStr, heightStr, scaleStr}).append((Component)undoPrompt);
        }
        if (this.secondSide.leftTop == null) {
            return Component.translatable((String)"imm_ptl.wand.second_side_left_up").append((Component)undoPrompt);
        }
        return null;
    }

    public Stage getStage() {
        if (this.firstSide == null) {
            return Stage.PlacingFirstSideLeftBottom;
        }
        if (this.firstSide.rightBottom == null) {
            return Stage.PlacingFirstSideRightBottom;
        }
        if (this.firstSide.leftTop == null) {
            return Stage.PlacingFirstSideLeftTop;
        }
        if (this.secondSide == null) {
            return Stage.PlacingSecondSideLeftBottom;
        }
        if (this.secondSide.rightBottom == null) {
            return Stage.PlacingSecondSideRightBottom;
        }
        if (this.secondSide.leftTop == null) {
            return Stage.PlacingSecondSideLeftTop;
        }
        return Stage.Completed;
    }

    public static enum Stage {
        PlacingFirstSideLeftBottom,
        PlacingFirstSideRightBottom,
        PlacingFirstSideLeftTop,
        PlacingSecondSideLeftBottom,
        PlacingSecondSideRightBottom,
        PlacingSecondSideLeftTop,
        Completed;

    }
}

