/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.wand;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.Codec;
import de.nick1st.imm_ptl.events.ClientCleanupEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.block_manipulation.BlockManipulationServer;
import qouteall.imm_ptl.peripheral.platform_specific.PeripheralModEntry;
import qouteall.imm_ptl.peripheral.wand.ClientPortalWandPortalCopy;
import qouteall.imm_ptl.peripheral.wand.ClientPortalWandPortalCreation;
import qouteall.imm_ptl.peripheral.wand.ClientPortalWandPortalDrag;
import qouteall.imm_ptl.peripheral.wand.PortalWandInteraction;

public class PortalWandItem
extends Item {
    public static PortalWandItem instance;
    public static final Codec<Mode> MODE_CODEC;
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Mode>> COMPONENT_TYPE;
    private static boolean instructionInformed;

    public static void init() {
        NeoForge.EVENT_BUS.addListener(PlayerInteractEvent.LeftClickBlock.class, event -> {
            if (event.getEntity().getMainHandItem().getItem() == instance) {
                event.setCanceled(true);
            }
        });
        NeoForge.EVENT_BUS.addListener(BlockManipulationServer.CrossPortalInteractionEvent.class, crossPortalInteractionEvent -> crossPortalInteractionEvent.setCanDo(crossPortalInteractionEvent.player.getMainHandItem().getItem() != instance));
    }

    public static void initClient() {
        NeoForge.EVENT_BUS.addListener(PlayerTickEvent.Post.class, event -> {
            if (event.getEntity() != null && event.getEntity().level().isClientSide()) {
                ItemStack itemStack = event.getEntity().getMainHandItem();
                if (itemStack.getItem() == instance) {
                    PortalWandItem.updateDisplay(itemStack);
                } else {
                    ClientPortalWandPortalCreation.clearCursorPointing();
                }
                ClientPortalWandPortalDrag.tick();
            }
        });
        NeoForge.EVENT_BUS.addListener(ClientCleanupEvent.class, e -> ClientPortalWandPortalCreation.reset());
        NeoForge.EVENT_BUS.addListener(ClientCleanupEvent.class, e -> ClientPortalWandPortalDrag.reset());
        NeoForge.EVENT_BUS.addListener(ClientCleanupEvent.class, e -> ClientPortalWandPortalCopy.reset());
    }

    public static void addIntoCreativeTag(CreativeModeTab.Output entries) {
        ItemStack w1 = new ItemStack((ItemLike)instance);
        w1.set(COMPONENT_TYPE, (Object)Mode.CREATE_PORTAL);
        entries.accept(w1);
        ItemStack w2 = new ItemStack((ItemLike)instance);
        w2.set(COMPONENT_TYPE, (Object)Mode.DRAG_PORTAL);
        entries.accept(w2);
        ItemStack w3 = new ItemStack((ItemLike)instance);
        w3.set(COMPONENT_TYPE, (Object)Mode.COPY_PORTAL);
        entries.accept(w3);
    }

    public PortalWandItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        Mode mode = (Mode)((Object)itemStack.getOrDefault(COMPONENT_TYPE, (Object)Mode.FALLBACK));
        if (player.isShiftKeyDown() && !world.isClientSide() && !PortalWandInteraction.isDragging((ServerPlayer)player)) {
            Mode nextMode = mode.next();
            itemStack.set(COMPONENT_TYPE, (Object)nextMode);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
        }
        if (!player.isShiftKeyDown() && world.isClientSide()) {
            this.onUseClient(mode);
        }
        return super.use(world, player, hand);
    }

    private void onUseClient(Mode mode) {
        switch (mode.ordinal()) {
            case 0: {
                ClientPortalWandPortalCreation.onRightClick();
                break;
            }
            case 1: {
                ClientPortalWandPortalDrag.onRightClick();
                break;
            }
            case 2: {
                ClientPortalWandPortalCopy.onRightClick();
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, tooltipContext, tooltip, tooltipFlag);
        tooltip.add((Component)Component.translatable((String)"imm_ptl.wand.item_desc_1", (Object[])new Object[]{Minecraft.getInstance().options.keyShift.getTranslatedKeyMessage(), Minecraft.getInstance().options.keyUse.getTranslatedKeyMessage()}));
        tooltip.add((Component)Component.translatable((String)"imm_ptl.wand.item_desc_2", (Object[])new Object[]{Minecraft.getInstance().options.keyShift.getTranslatedKeyMessage(), Minecraft.getInstance().options.keyAttack.getTranslatedKeyMessage()}));
    }

    public Component getName(ItemStack stack) {
        Mode mode = (Mode)((Object)stack.getOrDefault(COMPONENT_TYPE, (Object)Mode.FALLBACK));
        MutableComponent baseText = Component.translatable((String)"item.immersive_portals.portal_wand");
        return baseText.append((Component)Component.literal((String)" : ")).append((Component)mode.getText().withStyle(ChatFormatting.GOLD));
    }

    public static void showSettings(Player player) {
        player.sendSystemMessage((Component)Component.translatable((String)"imm_ptl.wand.settings_1"));
        player.sendSystemMessage((Component)Component.translatable((String)"imm_ptl.wand.settings_alignment"));
        int[] alignments = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 16, 32, 64};
        ArrayList<MutableComponent> alignmentSettingTexts = new ArrayList<MutableComponent>();
        for (int alignment : alignments) {
            MutableComponent textWithCommand = IPMcHelper.getTextWithCommand(Component.literal((String)("1/" + alignment)), "/imm_ptl_client_debug wand set_cursor_alignment " + alignment);
            alignmentSettingTexts.add(textWithCommand);
        }
        alignmentSettingTexts.add(IPMcHelper.getTextWithCommand(Component.translatable((String)"imm_ptl.wand.no_alignment"), "/imm_ptl_client_debug wand set_cursor_alignment 0"));
        player.sendSystemMessage((Component)alignmentSettingTexts.stream().reduce(Component.literal((String)""), (a, b) -> a.append(" ").append((Component)b)));
        player.sendSystemMessage((Component)Component.translatable((String)"imm_ptl.wand.settings_2", (Object[])new Object[]{Minecraft.getInstance().options.keyChat.getTranslatedKeyMessage()}));
    }

    private static void updateDisplay(ItemStack itemStack) {
        Mode mode = (Mode)((Object)itemStack.getOrDefault(COMPONENT_TYPE, (Object)Mode.FALLBACK));
        switch (mode.ordinal()) {
            case 0: {
                ClientPortalWandPortalCreation.updateDisplay();
                break;
            }
            case 1: {
                ClientPortalWandPortalDrag.updateDisplay();
                break;
            }
            case 2: {
                ClientPortalWandPortalCopy.updateDisplay();
            }
        }
    }

    public static void clientRender(LocalPlayer player, ItemStack itemStack, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, double camX, double camY, double camZ) {
        if (!instructionInformed) {
            instructionInformed = true;
        }
        Mode mode = (Mode)((Object)itemStack.getOrDefault(COMPONENT_TYPE, (Object)Mode.FALLBACK));
        switch (mode.ordinal()) {
            case 0: {
                ClientPortalWandPortalCreation.render(poseStack, bufferSource, camX, camY, camZ);
                break;
            }
            case 1: {
                ClientPortalWandPortalDrag.render(poseStack, bufferSource, camX, camY, camZ);
                break;
            }
            case 2: {
                ClientPortalWandPortalCopy.render(poseStack, bufferSource, camX, camY, camZ);
            }
        }
    }

    static {
        MODE_CODEC = Codec.STRING.xmap(Mode::fromStr, Mode::toStr);
        COMPONENT_TYPE = PeripheralModEntry.DATA_COMPONENTS_REGISTRAR.registerComponentType("portal_wand_data", b -> b.persistent(MODE_CODEC));
        instructionInformed = false;
    }

    public static enum Mode {
        CREATE_PORTAL,
        DRAG_PORTAL,
        COPY_PORTAL;

        public static final Mode FALLBACK;

        public static Mode fromTag(CompoundTag tag) {
            String mode = tag.getString("mode");
            return Mode.fromStr(mode);
        }

        public static Mode fromStr(String mode) {
            return switch (mode) {
                case "create_portal" -> CREATE_PORTAL;
                case "drag_portal" -> DRAG_PORTAL;
                case "copy_portal" -> COPY_PORTAL;
                default -> FALLBACK;
            };
        }

        public Mode next() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> DRAG_PORTAL;
                case 1 -> COPY_PORTAL;
                case 2 -> CREATE_PORTAL;
            };
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            String modeString = this.toStr();
            tag.putString("mode", modeString);
            return tag;
        }

        public String toStr() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "create_portal";
                case 1 -> "drag_portal";
                case 2 -> "copy_portal";
            };
        }

        public MutableComponent getText() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Component.translatable((String)"imm_ptl.wand.mode.create_portal");
                case 1 -> Component.translatable((String)"imm_ptl.wand.mode.drag_portal");
                case 2 -> Component.translatable((String)"imm_ptl.wand.mode.copy_portal");
            };
        }

        static {
            FALLBACK = CREATE_PORTAL;
        }
    }
}

