/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.wand;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.mc_utils.WireRenderingHelper;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.PortalUtils;
import qouteall.imm_ptl.core.portal.animation.ClientPortalAnimationManagement;
import qouteall.imm_ptl.core.portal.animation.TimingFunction;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.portal.util.PortalLocalXYNormalized;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.peripheral.wand.PortalCorner;
import qouteall.imm_ptl.peripheral.wand.PortalWandInteraction;
import qouteall.imm_ptl.peripheral.wand.PortalWandItem;
import qouteall.imm_ptl.peripheral.wand.WandUtil;
import qouteall.q_misc_util.CustomTextOverlay;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.api.McRemoteProcedureCallClient;
import qouteall.q_misc_util.my_util.Circle;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.RayTraceResult;
import qouteall.q_misc_util.my_util.Sphere;
import qouteall.q_misc_util.my_util.WithDim;
import qouteall.q_misc_util.my_util.animation.Animated;
import qouteall.q_misc_util.my_util.animation.RenderedPlane;
import qouteall.q_misc_util.my_util.animation.RenderedPoint;

public class ClientPortalWandPortalDrag {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private static UUID selectedPortalId;
    @Nullable
    private static PortalLocalXYNormalized lockedAnchor;
    private static boolean lockWidth;
    private static boolean lockHeight;
    @Nullable
    private static SelectionStatus selectionStatus;
    public static Animated<RenderedPoint> cursor;
    public static Animated<UnilateralPortalState> renderedRect;
    public static Animated<RenderedPlane> renderedPlane;
    public static Animated<RenderedPlane> renderedPrePlane;
    private static Animated<RenderedPoint> renderedLockedAnchor;
    private static Animated<Double> renderedWidthLineSegment;
    private static Animated<Double> renderedHeightLineSegment;
    private static Animated<Double> renderedWidthLock;
    private static Animated<Double> renderedHeightLock;
    @Nullable
    public static DraggingContext draggingContext;
    private static boolean isUndoing;
    private static final int colorOfCursor = -16515844;
    private static final int colorOfRect1 = -1309700;
    private static final int colorOfRect2 = -218877;
    private static final int colorOfPlane = -1;
    private static final int colorOfLock = -1;
    private static final int colorOfWidthLine = -16516018;
    private static final int colorOfHeightLine = -198653;
    private static final int colorOfCursorInLock = -384160;
    private static final int colorOfSphere = -1;
    private static final double renderedPreCircleRadius = 0.5;

    public static void init() {
        ClientPortalAnimationManagement.clientAnimationUpdateSignal.connect(ClientPortalWandPortalDrag::updateDraggedPortalAnimation);
    }

    public static void reset() {
        selectedPortalId = null;
        ClientPortalWandPortalDrag.clearLock();
        selectionStatus = null;
        cursor.clearTarget();
        renderedPrePlane.clearTarget();
        renderedPlane.clearTarget();
        renderedRect.clearTarget();
        draggingContext = null;
        isUndoing = false;
    }

    public static void onLeftClick() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (ClientPortalWandPortalDrag.isDragging()) {
            ClientPortalWandPortalDrag.undoDragging();
        } else if (selectionStatus != null) {
            if (ClientPortalWandPortalDrag.selectionStatus.selectsHorizontalEdge) {
                lockWidth = !lockWidth;
                CustomTextOverlay.putText((Component)Component.translatable((String)(lockWidth ? "imm_ptl.wand.width_locked" : "imm_ptl.wand.width_unlocked")).withStyle(ChatFormatting.GOLD), 3.0, "0_alert");
            } else if (ClientPortalWandPortalDrag.selectionStatus.selectsVerticalEdge) {
                lockHeight = !lockHeight;
                CustomTextOverlay.putText((Component)Component.translatable((String)(lockHeight ? "imm_ptl.wand.height_locked" : "imm_ptl.wand.height_unlocked")).withStyle(ChatFormatting.GOLD), 3.0, "0_alert");
            } else {
                PortalLocalXYNormalized selectedAnchor = ClientPortalWandPortalDrag.selectionStatus.selectedAnchor;
                if (lockedAnchor != null && lockedAnchor.isCloseTo(selectedAnchor, 0.01)) {
                    lockedAnchor = null;
                    CustomTextOverlay.putText((Component)Component.translatable((String)"imm_ptl.wand.anchor_unlocked").withStyle(ChatFormatting.GOLD), 3.0, "0_alert");
                } else {
                    CustomTextOverlay.putText((Component)Component.translatable((String)(lockedAnchor != null ? "imm_ptl.wand.anchor_lock_moved" : "imm_ptl.wand.anchor_locked")).withStyle(ChatFormatting.GOLD), 3.0, "0_alert");
                    lockedAnchor = selectedAnchor;
                }
            }
        }
    }

    public static void onRightClick() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (ClientPortalWandPortalDrag.isDragging()) {
            return;
        }
        if (isUndoing) {
            return;
        }
        ClientPortalWandPortalDrag.startDragging();
    }

    public static void tick() {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        if (ClientPortalWandPortalDrag.isDragging() && player.getItemInHand(InteractionHand.MAIN_HAND).getItem() != PortalWandItem.instance && player.getItemInHand(InteractionHand.OFF_HAND).getItem() != PortalWandItem.instance) {
            LOGGER.info("Undo dragging because the player is not holding the wand");
            ClientPortalWandPortalDrag.undoDragging();
        }
    }

    public static boolean isDragging() {
        return draggingContext != null;
    }

    public static void updateDisplay() {
        Pair<UnilateralPortalState.RectInvariant, UnilateralPortalState> rectTurning;
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        if (!minecraft.options.keyUse.isDown()) {
            isUndoing = false;
        }
        if (isUndoing) {
            return;
        }
        if (draggingContext != null) {
            ClientPortalWandPortalDrag.handleDragging(player, draggingContext);
            return;
        }
        Portal originalSelectedPortal = ClientPortalWandPortalDrag.getSelectedPortal();
        if (originalSelectedPortal == null) {
            ClientPortalWandPortalDrag.reset();
        }
        Vec3 eyePos = player.getEyePosition(RenderStates.getPartialTick());
        Vec3 viewVec = player.getLookAngle();
        Pair rayTraceResult = PortalUtils.lenientRayTracePortals(player.level(), eyePos, eyePos.add(viewVec.scale(64.0)), false, p -> true, 1.0).orElse(null);
        if (rayTraceResult == null) {
            selectionStatus = null;
            cursor.clearTarget();
            renderedPlane.clearTarget();
            renderedPrePlane.clearTarget();
            CustomTextOverlay.putText((Component)Component.translatable((String)"imm_ptl.wand.select_portal"));
            if (originalSelectedPortal == null) {
                renderedRect.clearTarget();
            } else {
                renderedRect.setTarget(originalSelectedPortal.getThisSideState(), Helper.secondToNano(1.0));
            }
            return;
        }
        Portal portal = (Portal)rayTraceResult.getFirst();
        Vec3 hitPos = ((RayTraceResult)rayTraceResult.getSecond()).hitPos();
        if (selectedPortalId == null) {
            selectedPortalId = portal.getUUID();
        } else if (!Objects.equals(selectedPortalId, portal.getUUID())) {
            if (originalSelectedPortal != null && Portal.isFlippedPortal(originalSelectedPortal, portal)) {
                Vec3 lockedAnchorPos;
                if (lockedAnchor != null && !(lockedAnchor = PortalLocalXYNormalized.fromPos(portal, lockedAnchorPos = lockedAnchor.getPos(originalSelectedPortal))).isValid()) {
                    lockedAnchor = null;
                }
            } else {
                selectionStatus = null;
                if (ClientPortalWandPortalDrag.hasLock()) {
                    CustomTextOverlay.putText((Component)Component.translatable((String)"imm_ptl.wand.lock_cleared").withStyle(ChatFormatting.GOLD), 5.0, "1_alert");
                    ClientPortalWandPortalDrag.clearLock();
                }
            }
            selectedPortalId = portal.getUUID();
        }
        PortalLocalXYNormalized rawSelection = PortalLocalXYNormalized.fromPos(portal, hitPos);
        int cursorAlignment = IPConfig.getConfig().portalWandCursorAlignment;
        PortalLocalXYNormalized selection = cursorAlignment == 0 ? rawSelection.clamp() : rawSelection.clamp().snapToGrid(cursorAlignment);
        boolean selectsHorizontalEdge = rawSelection.ny() < 0.0 || rawSelection.ny() > 1.0;
        boolean selectsVerticalEdge = rawSelection.nx() < 0.0 || rawSelection.nx() > 1.0;
        selectionStatus = new SelectionStatus(selection, selectsHorizontalEdge, selectsVerticalEdge);
        Vec3 cursorPos = selection.getPos(portal);
        cursor.setTarget(new RenderedPoint(new WithDim<Vec3>((ResourceKey<Level>)player.level().dimension(), cursorPos), 1.0), Helper.secondToNano(0.5));
        UnilateralPortalState lastRenderedRect = renderedRect.getCurrent();
        UnilateralPortalState newRenderedRect = portal.getThisSideState();
        if (lastRenderedRect != null && ((UnilateralPortalState.RectInvariant)((Object)(rectTurning = lastRenderedRect.turnToClosestTo(newRenderedRect.orientation())).getFirst())).switchesWidthAndHeight()) {
            Animated<Double> temp = renderedWidthLineSegment;
            renderedWidthLineSegment = renderedHeightLineSegment;
            renderedHeightLineSegment = temp;
        }
        renderedRect.setTarget(newRenderedRect, Helper.secondToNano(1.0));
        Pair<Plane, MutableComponent> planeInfo = ClientPortalWandPortalDrag.getPlayerFacingPlaneAligned((Player)player, cursorPos, portal);
        if (selectsHorizontalEdge) {
            CustomTextOverlay.putText((Component)Component.translatable((String)"imm_ptl.wand.lock_width", (Object[])new Object[]{minecraft.options.keyAttack.getTranslatedKeyMessage()}));
            renderedPrePlane.clearTarget();
        } else if (selectsVerticalEdge) {
            CustomTextOverlay.putText((Component)Component.translatable((String)"imm_ptl.wand.lock_height", (Object[])new Object[]{minecraft.options.keyAttack.getTranslatedKeyMessage()}));
            renderedPrePlane.clearTarget();
        } else {
            MutableComponent planeText = Component.translatable((String)"imm_ptl.wand.on_plane", (Object[])new Object[]{((MutableComponent)planeInfo.getSecond()).withStyle(ChatFormatting.GOLD)});
            CustomTextOverlay.putText((Component)Component.translatable((String)"imm_ptl.wand.pre_drag", (Object[])new Object[]{minecraft.options.keyAttack.getTranslatedKeyMessage(), minecraft.options.keyUse.getTranslatedKeyMessage(), planeText}));
            renderedPrePlane.setTarget(new RenderedPlane(new WithDim<Plane>((ResourceKey<Level>)player.level().dimension(), (Plane)planeInfo.getFirst()), 1.0), Helper.secondToNano(0.3));
        }
    }

    private static boolean hasLock() {
        return lockedAnchor != null || lockWidth || lockHeight;
    }

    private static void clearLock() {
        lockedAnchor = null;
        lockWidth = false;
        lockHeight = false;
        renderedLockedAnchor.clearTarget();
        renderedWidthLineSegment.clearTarget();
        renderedHeightLineSegment.clearTarget();
        renderedWidthLock.clearTarget();
        renderedHeightLock.clearTarget();
    }

    private static void handleDragging(LocalPlayer player, DraggingContext draggingContext) {
        Vec3 eyePos = player.getEyePosition(RenderStates.getPartialTick());
        Vec3 viewVec = player.getLookAngle();
        ResourceKey currDim = player.level().dimension();
        if (draggingContext.dimension != currDim) {
            ClientPortalWandPortalDrag.stopDragging();
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (!minecraft.options.keyUse.isDown()) {
            ClientPortalWandPortalDrag.stopDragging();
            return;
        }
        Vec3 cursorPos = null;
        Plane plane = draggingContext.limitingPlane();
        Sphere sphere = draggingContext.limitingSphere;
        int alignment = IPConfig.getConfig().portalWandCursorAlignment;
        if (plane != null) {
            cursorPos = plane.rayTrace(eyePos, viewVec);
            if (cursorPos != null) {
                cursorPos = ClientPortalWandPortalDrag.align(cursorPos, alignment);
                cursorPos = plane.getProjection(cursorPos);
            }
        } else if (sphere != null && (cursorPos = sphere.rayTrace(eyePos, viewVec)) != null) {
            cursorPos = ClientPortalWandPortalDrag.align(cursorPos, alignment);
            cursorPos = sphere.projectToSphere(cursorPos);
        }
        if (cursorPos != null) {
            Vec3 originalCursorTarget = cursor.getTarget().pos().value();
            if (originalCursorTarget == null) {
                return;
            }
            if (originalCursorTarget.distanceTo(cursorPos) > 1.0E-6) {
                cursor.setTarget(new RenderedPoint(new WithDim<Vec3>((ResourceKey<Level>)currDim, cursorPos), 1.0), Helper.secondToNano(0.2));
                ClientPortalWandPortalDrag.onDrag(cursorPos, draggingContext);
            }
        }
        MutableComponent draggingText = Component.translatable((String)"imm_ptl.wand.dragging");
        MutableComponent planeText = draggingContext.planeText() == null ? Component.literal((String)"") : Component.translatable((String)"imm_ptl.wand.on_plane", (Object[])new Object[]{draggingContext.planeText()});
        MutableComponent undoPrompt = Component.literal((String)"\n").append((Component)Component.translatable((String)"imm_ptl.wand.left_click_to_undo", (Object[])new Object[]{minecraft.options.keyAttack.getTranslatedKeyMessage()}));
        MutableComponent cursorPosText = cursorPos == null ? Component.literal((String)"") : Component.literal((String)"\n").append((Component)Component.translatable((String)"imm_ptl.wand.cursor_pos", (Object[])new Object[]{"%.3f".formatted(cursorPos.x), "%.3f".formatted(cursorPos.y), "%.3f".formatted(cursorPos.z)}));
        Portal portal = WandUtil.getClientPortalByUUID(draggingContext.portalId());
        boolean shouldDisplaySize = lockedAnchor != null;
        PortalState animationEndingState = ClientPortalWandPortalDrag.getAnimationEndingState();
        MutableComponent portalSizeText = portal != null && shouldDisplaySize && animationEndingState != null ? Component.literal((String)" ").append((Component)Component.translatable((String)"imm_ptl.wand.portal_size", (Object[])new Object[]{"%.3f".formatted(animationEndingState.width), "%.3f".formatted(animationEndingState.height), "%.3f".formatted(animationEndingState.scaling)})) : Component.literal((String)"");
        CustomTextOverlay.putText((Component)draggingText.append((Component)planeText).append((Component)undoPrompt).append((Component)cursorPosText).append((Component)portalSizeText));
    }

    private static Vec3 align(Vec3 pos, int alignment) {
        if (alignment == 0) {
            return pos;
        }
        return new Vec3((double)Math.round(pos.x() * (double)alignment) / (double)alignment, (double)Math.round(pos.y() * (double)alignment) / (double)alignment, (double)Math.round(pos.z() * (double)alignment) / (double)alignment);
    }

    private static void startDragging() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (ClientPortalWandPortalDrag.isDragging()) {
            LOGGER.error("start dragging when already dragging");
            return;
        }
        if (!Minecraft.getInstance().options.keyUse.isDown()) {
            LOGGER.error("start dragging when not right clicking");
            return;
        }
        Portal portal = ClientPortalWandPortalDrag.getSelectedPortal();
        if (portal == null) {
            return;
        }
        RenderedPoint cursorTarget = cursor.getTarget();
        if (cursorTarget == null) {
            return;
        }
        WithDim<Vec3> cursorTargetPos = cursorTarget.pos();
        if (cursorTargetPos == null) {
            return;
        }
        Vec3 cursorPos = cursorTargetPos.value();
        if (cursorPos == null) {
            return;
        }
        if (selectionStatus == null) {
            return;
        }
        PortalLocalXYNormalized selectedAnchor = ClientPortalWandPortalDrag.selectionStatus.selectedAnchor;
        if (lockedAnchor != null && lockedAnchor.isCloseTo(selectedAnchor, 0.01)) {
            return;
        }
        PortalWandInteraction.DraggingInfo draggingInfo = new PortalWandInteraction.DraggingInfo(lockedAnchor, selectedAnchor, null, lockWidth, lockHeight);
        ResourceKey currDim = player.level().dimension();
        Pair<Plane, MutableComponent> info = ClientPortalWandPortalDrag.getPlayerFacingPlaneAligned((Player)player, cursorPos, portal);
        Plane plane = (Plane)info.getFirst();
        renderedPlane.setTarget(new RenderedPlane(new WithDim<Plane>((ResourceKey<Level>)currDim, plane), 1.0), Helper.secondToNano(0.5));
        renderedPrePlane.clearTarget();
        draggingContext = new DraggingContext((ResourceKey<Level>)currDim, portal.getUUID(), plane, null, draggingInfo, ((MutableComponent)info.getSecond()).withStyle(ChatFormatting.GOLD), portal.getPortalState());
    }

    private static void stopDragging() {
        draggingContext = null;
        renderedPlane.clearTarget();
        renderedRect.clearTarget();
        McRemoteProcedureCallClient.tellServerToInvoke("qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.finishDragging", new Object[0]);
    }

    private static void undoDragging() {
        McRemoteProcedureCallClient.tellServerToInvoke("qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.undoDrag", new Object[0]);
        renderedPlane.clearTarget();
        renderedRect.clearTarget();
        draggingContext = null;
        isUndoing = true;
    }

    private static void onDrag(Vec3 cursorPos, DraggingContext draggingContext) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        Portal portal = WandUtil.getClientPortalByUUID(draggingContext.portalId());
        if (portal == null) {
            LOGGER.error("cannot find portal to drag {}", (Object)selectedPortalId);
            ClientPortalWandPortalDrag.reset();
            return;
        }
        PortalWandInteraction.DraggingInfo draggingInfo = draggingContext.draggingInfo();
        UnilateralPortalState newThisSideState = PortalWandInteraction.applyDrag(draggingContext.originalPortalState().getThisSideState(), cursorPos, draggingInfo, true);
        boolean isValid = PortalWandInteraction.validateDraggedPortalState(draggingContext.originalPortalState(), newThisSideState, (Player)player);
        if (isValid) {
            McRemoteProcedureCallClient.tellServerToInvoke("qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.requestApplyDrag", selectedPortalId, cursorPos, draggingInfo);
            CustomTextOverlay.remove("1_invalid_dragging");
        } else {
            CustomTextOverlay.putText((Component)Component.translatable((String)"imm_ptl.wand.invalid_dragging").withStyle(ChatFormatting.RED), 3.0, "1_invalid_dragging");
        }
    }

    @Nullable
    private static Portal getSelectedPortal() {
        return WandUtil.getClientPortalByUUID(selectedPortalId);
    }

    private static Pair<Plane, MutableComponent> getPlayerFacingPlaneAligned(Player player, Vec3 cursorPos, Portal portal) {
        ArrayList<Pair> candidates = new ArrayList<Pair>();
        Vec3 X = new Vec3(1.0, 0.0, 0.0);
        Vec3 Y = new Vec3(0.0, 1.0, 0.0);
        Vec3 Z = new Vec3(0.0, 0.0, 1.0);
        candidates.add(Pair.of((Object)new Plane(cursorPos, X), (Object)Component.translatable((String)"imm_ptl.wand.plane.x")));
        candidates.add(Pair.of((Object)new Plane(cursorPos, Y), (Object)Component.translatable((String)"imm_ptl.wand.plane.y")));
        candidates.add(Pair.of((Object)new Plane(cursorPos, Z), (Object)Component.translatable((String)"imm_ptl.wand.plane.z")));
        Predicate<Vec3> isOrthodox = p -> Math.abs(p.dot(X)) > 0.9999 || Math.abs(p.dot(Y)) > 0.9999 || Math.abs(p.dot(Z)) > 0.9999;
        if (!isOrthodox.test(portal.getAxisW())) {
            candidates.add(Pair.of((Object)new Plane(cursorPos, portal.getAxisW()), (Object)Component.translatable((String)"imm_ptl.wand.plane.portal_x")));
        }
        if (!isOrthodox.test(portal.getAxisH())) {
            candidates.add(Pair.of((Object)new Plane(cursorPos, portal.getAxisH()), (Object)Component.translatable((String)"imm_ptl.wand.plane.portal_y")));
        }
        if (!isOrthodox.test(portal.getNormal())) {
            candidates.add(Pair.of((Object)new Plane(cursorPos, portal.getNormal()), (Object)Component.translatable((String)"imm_ptl.wand.plane.portal_z")));
        }
        Vec3 viewVec = player.getLookAngle();
        return Stream.concat(candidates.stream(), candidates.stream().map(p -> Pair.of((Object)((Plane)p.getFirst()).getOpposite(), (Object)((MutableComponent)p.getSecond())))).min(Comparator.comparingDouble(p -> ((Plane)p.getFirst()).normal().dot(viewVec))).orElseThrow();
    }

    public static void render(PoseStack matrixStack, MultiBufferSource.BufferSource bufferSource, double camX, double camY, double camZ) {
        RenderedPlane prePlane;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (PortalRendering.isRendering()) {
            return;
        }
        renderedWidthLock.setTarget(lockWidth ? 1.0 : 0.0, Helper.secondToNano(0.5));
        renderedHeightLock.setTarget(lockHeight ? 1.0 : 0.0, Helper.secondToNano(0.5));
        renderedWidthLineSegment.setTarget(lockWidth || selectionStatus != null && ClientPortalWandPortalDrag.selectionStatus.selectsHorizontalEdge && draggingContext == null ? 1.0 : 0.0, Helper.secondToNano(0.5));
        renderedHeightLineSegment.setTarget(lockHeight || selectionStatus != null && ClientPortalWandPortalDrag.selectionStatus.selectsVerticalEdge && draggingContext == null ? 1.0 : 0.0, Helper.secondToNano(0.5));
        ResourceKey currDim = player.level().dimension();
        Vec3 cameraPos = new Vec3(camX, camY, camZ);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.lines());
        Vec3 renderedCursor = ClientPortalWandPortalDrag.getCursorToRender();
        if (renderedCursor != null) {
            WireRenderingHelper.renderSmallCubeFrame(vertexConsumer, cameraPos, renderedCursor, -16515844, cursor.getCurrent().scale(), matrixStack);
        }
        Portal portal = null;
        if (draggingContext != null) {
            portal = WandUtil.getClientPortalByUUID(ClientPortalWandPortalDrag.draggingContext.portalId);
        }
        if (portal == null && selectedPortalId != null) {
            portal = ClientPortalWandPortalDrag.getSelectedPortal();
        }
        UnilateralPortalState rect = null;
        if (draggingContext != null) {
            if (portal != null) {
                rect = portal.getThisSideState();
                ClientPortalWandPortalDrag.renderRect(matrixStack, cameraPos, vertexConsumer, rect);
                renderedRect.setTarget(rect, 0L);
            }
        } else {
            rect = renderedRect.getCurrent();
            if (rect != null && rect.dimension() == currDim) {
                ClientPortalWandPortalDrag.renderRect(matrixStack, cameraPos, vertexConsumer, rect);
            }
        }
        if (lockedAnchor != null && portal != null) {
            renderedLockedAnchor.setTarget(new RenderedPoint(new WithDim<Vec3>((ResourceKey<Level>)portal.getOriginDim(), lockedAnchor.getPos(portal)), 1.0), Helper.secondToNano(0.5));
        } else {
            renderedLockedAnchor.clearTarget();
        }
        if (portal != null) {
            RenderedPoint current = renderedLockedAnchor.getCurrent();
            if (current != null && current.pos() != null && current.pos().dimension() == currDim) {
                Vec3 lockPos = current.pos().value();
                if (draggingContext != null && lockedAnchor != null) {
                    lockPos = lockedAnchor.getPos(portal);
                }
                double lockExtraScale = ClientPortalWandPortalDrag.getLockExtraScale(portal.getThisSideState());
                matrixStack.pushPose();
                matrixStack.scale(0.5f, 0.5f, 0.5f);
                WireRenderingHelper.renderLockShape(vertexConsumer, cameraPos, lockPos, current.scale() * lockExtraScale, -1, matrixStack);
                matrixStack.popPose();
                WireRenderingHelper.renderSmallCubeFrame(vertexConsumer, cameraPos, lockPos, -384160, current.scale() * lockExtraScale, matrixStack);
            }
            ClientPortalWandPortalDrag.renderWidthHeightLock(matrixStack, cameraPos, vertexConsumer, portal.getThisSideState());
        }
        if (rect != null) {
            ClientPortalWandPortalDrag.renderWidthHeightLineSegment(matrixStack, cameraPos, vertexConsumer, rect);
        }
        VertexConsumer debugLineStripConsumer = bufferSource.getBuffer(RenderType.debugLineStrip((double)1.0));
        RenderedPlane plane = renderedPlane.getCurrent();
        if (plane != null && plane.plane() != null && plane.plane().dimension() == currDim) {
            Plane planeValue = plane.plane().value();
            if (renderedCursor != null) {
                planeValue = planeValue.getParallelPlane(renderedCursor);
            }
            WireRenderingHelper.renderPlane(debugLineStripConsumer, cameraPos, planeValue, plane.scale(), -1, matrixStack, true);
        }
        if ((prePlane = renderedPrePlane.getCurrent()) != null && prePlane.plane() != null && prePlane.plane().dimension() == currDim) {
            Plane planeValue = prePlane.plane().value();
            if (renderedCursor != null) {
                planeValue = planeValue.getParallelPlane(renderedCursor);
            }
            WireRenderingHelper.renderCircle(debugLineStripConsumer, cameraPos, new Circle(planeValue, planeValue.pos(), prePlane.scale() * 0.5), -1, matrixStack);
        }
    }

    @Nullable
    private static Vec3 getCursorToRender() {
        if (draggingContext != null) {
            Portal portal = WandUtil.getClientPortalByUUID(ClientPortalWandPortalDrag.draggingContext.portalId);
            if (portal != null) {
                return ClientPortalWandPortalDrag.draggingContext.draggingInfo().draggingAnchor.getPos(portal);
            }
            return null;
        }
        RenderedPoint renderedPoint = cursor.getCurrent();
        assert (renderedPoint != null);
        WithDim<Vec3> pos = renderedPoint.pos();
        if (pos == null) {
            return null;
        }
        return pos.value();
    }

    public static void renderRect(PoseStack matrixStack, Vec3 cameraPos, VertexConsumer vertexConsumer, UnilateralPortalState rect) {
        WireRenderingHelper.renderRectFrameFlow(matrixStack, cameraPos, vertexConsumer, rect, -1309700, -218877);
    }

    private static double getLockExtraScale(UnilateralPortalState rect) {
        return Math.sqrt(rect.width() * rect.height()) * 0.2;
    }

    private static void renderWidthHeightLock(PoseStack matrixStack, Vec3 cameraPos, VertexConsumer vertexConsumer, UnilateralPortalState rect) {
        Double heightLockAnim;
        matrixStack.pushPose();
        matrixStack.scale(0.5f, 0.5f, 0.5f);
        double lockPadding = 0.1;
        double lockExtraScale = ClientPortalWandPortalDrag.getLockExtraScale(rect);
        Double widthLockAnim = renderedWidthLock.getCurrent();
        if (widthLockAnim != null && widthLockAnim > 0.001) {
            WireRenderingHelper.renderLockShape(vertexConsumer, cameraPos, new PortalLocalXYNormalized(0.5, -lockPadding).getPos(rect), widthLockAnim * lockExtraScale, -16516018, matrixStack);
            WireRenderingHelper.renderLockShape(vertexConsumer, cameraPos, new PortalLocalXYNormalized(0.5, 1.0 + lockPadding).getPos(rect), widthLockAnim * lockExtraScale, -16516018, matrixStack);
        }
        if ((heightLockAnim = renderedHeightLock.getCurrent()) != null && heightLockAnim > 0.001) {
            WireRenderingHelper.renderLockShape(vertexConsumer, cameraPos, new PortalLocalXYNormalized(-lockPadding, 0.5).getPos(rect), heightLockAnim * lockExtraScale, -198653, matrixStack);
            WireRenderingHelper.renderLockShape(vertexConsumer, cameraPos, new PortalLocalXYNormalized(1.0 + lockPadding, 0.5).getPos(rect), heightLockAnim * lockExtraScale, -198653, matrixStack);
        }
        matrixStack.popPose();
    }

    private static void renderWidthHeightLineSegment(PoseStack matrixStack, Vec3 cameraPos, VertexConsumer vertexConsumer, UnilateralPortalState rect) {
        Double heightLineAnim;
        matrixStack.pushPose();
        matrixStack.scale(0.5f, 0.5f, 0.5f);
        double padding1 = 0.04;
        double padding2 = padding1 + 0.02;
        double padding3 = padding2 + 0.03;
        Double widthLineAnim = renderedWidthLineSegment.getCurrent();
        if (widthLineAnim != null && widthLineAnim > 0.001) {
            double rangeStart = 0.5 - widthLineAnim / 2.0;
            double rangeEnd = 0.5 + widthLineAnim / 2.0;
            WireRenderingHelper.renderLines(vertexConsumer, cameraPos, rect.position(), new Vec3[]{new PortalLocalXYNormalized(rangeStart, -padding2).getOffset(rect), new PortalLocalXYNormalized(rangeEnd, -padding2).getOffset(rect), new PortalLocalXYNormalized(rangeStart, 1.0 + padding2).getOffset(rect), new PortalLocalXYNormalized(rangeEnd, 1.0 + padding2).getOffset(rect), new PortalLocalXYNormalized(rangeStart, -padding1).getOffset(rect), new PortalLocalXYNormalized(rangeStart, -padding2).getOffset(rect), new PortalLocalXYNormalized(rangeEnd, -padding1).getOffset(rect), new PortalLocalXYNormalized(rangeEnd, -padding2).getOffset(rect), new PortalLocalXYNormalized(rangeStart, 1.0 + padding1).getOffset(rect), new PortalLocalXYNormalized(rangeStart, 1.0 + padding2).getOffset(rect), new PortalLocalXYNormalized(rangeEnd, 1.0 + padding1).getOffset(rect), new PortalLocalXYNormalized(rangeEnd, 1.0 + padding2).getOffset(rect), new PortalLocalXYNormalized(0.5, -padding2).getOffset(rect), new PortalLocalXYNormalized(0.5, -padding3).getOffset(rect), new PortalLocalXYNormalized(0.5, 1.0 + padding2).getOffset(rect), new PortalLocalXYNormalized(0.5, 1.0 + padding3).getOffset(rect)}, 1.0, DQuaternion.identity, -16516018, matrixStack);
        }
        if ((heightLineAnim = renderedHeightLineSegment.getCurrent()) != null && heightLineAnim > 0.001) {
            double rangeStart = 0.5 - heightLineAnim / 2.0;
            double rangeEnd = 0.5 + heightLineAnim / 2.0;
            WireRenderingHelper.renderLines(vertexConsumer, cameraPos, rect.position(), new Vec3[]{new PortalLocalXYNormalized(-padding2, rangeStart).getOffset(rect), new PortalLocalXYNormalized(-padding2, rangeEnd).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding2, rangeStart).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding2, rangeEnd).getOffset(rect), new PortalLocalXYNormalized(-padding1, rangeStart).getOffset(rect), new PortalLocalXYNormalized(-padding2, rangeStart).getOffset(rect), new PortalLocalXYNormalized(-padding1, rangeEnd).getOffset(rect), new PortalLocalXYNormalized(-padding2, rangeEnd).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding1, rangeStart).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding2, rangeStart).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding1, rangeEnd).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding2, rangeEnd).getOffset(rect), new PortalLocalXYNormalized(-padding2, 0.5).getOffset(rect), new PortalLocalXYNormalized(-padding3, 0.5).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding2, 0.5).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding3, 0.5).getOffset(rect)}, 1.0, DQuaternion.identity, -198653, matrixStack);
        }
        matrixStack.popPose();
    }

    private static PortalCorner getClosestCorner(Portal portal, Vec3 hitPos) {
        return Arrays.stream(PortalCorner.values()).min(Comparator.comparingDouble(corner -> corner.getPos(portal).distanceTo(hitPos))).orElseThrow();
    }

    private static void updateDraggedPortalAnimation() {
        Vec3 currentCursor;
        if (draggingContext == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        RenderedPoint renderedCursor = cursor.getCurrent();
        assert (renderedCursor != null);
        Vec3 vec3 = currentCursor = renderedCursor.pos() == null ? null : renderedCursor.pos().value();
        if (currentCursor == null) {
            return;
        }
        Portal selectedPortal = ClientPortalWandPortalDrag.getSelectedPortal();
        if (selectedPortal == null) {
            return;
        }
        UnilateralPortalState newState = PortalWandInteraction.applyDrag(draggingContext.originalPortalState().getThisSideState(), currentCursor, ClientPortalWandPortalDrag.draggingContext.draggingInfo, false);
        if (PortalWandInteraction.validateDraggedPortalState(draggingContext.originalPortalState(), newState, (Player)player)) {
            PortalState newFullState = draggingContext.originalPortalState().withThisSideUpdated(newState, ClientPortalWandPortalDrag.draggingContext.draggingInfo.shouldLockScale());
            selectedPortal.setPortalState(newFullState);
            selectedPortal.rectifyClusterPortals(false);
        }
    }

    @Nullable
    private static PortalState getAnimationEndingState() {
        Vec3 cursorTarget;
        if (draggingContext == null) {
            return null;
        }
        Portal portal = WandUtil.getClientPortalByUUID(draggingContext.portalId());
        if (portal == null) {
            return null;
        }
        RenderedPoint renderedCursorTarget = cursor.getTarget();
        assert (renderedCursorTarget != null);
        Vec3 vec3 = cursorTarget = renderedCursorTarget.pos() == null ? null : renderedCursorTarget.pos().value();
        if (cursorTarget == null) {
            return null;
        }
        UnilateralPortalState newThisSide = PortalWandInteraction.applyDrag(draggingContext.originalPortalState().getThisSideState(), cursorTarget, draggingContext.draggingInfo(), false);
        if (newThisSide == null) {
            return null;
        }
        return draggingContext.originalPortalState().withThisSideUpdated(newThisSide, draggingContext.draggingInfo().shouldLockScale());
    }

    static {
        lockWidth = false;
        lockHeight = false;
        cursor = new Animated<RenderedPoint>(Animated.RENDERED_POINT_TYPE_INFO, () -> RenderStates.renderStartNanoTime, TimingFunction.sine::mapProgress, RenderedPoint.EMPTY);
        renderedRect = new Animated<Object>(UnilateralPortalState.ANIMATION_TYPE_INFO, () -> RenderStates.renderStartNanoTime, TimingFunction.sine::mapProgress, null);
        renderedPlane = new Animated<RenderedPlane>(Animated.RENDERED_PLANE_TYPE_INFO, () -> RenderStates.renderStartNanoTime, TimingFunction.sine::mapProgress, RenderedPlane.NONE);
        renderedPrePlane = new Animated<RenderedPlane>(Animated.RENDERED_PLANE_TYPE_INFO, () -> RenderStates.renderStartNanoTime, TimingFunction.sine::mapProgress, RenderedPlane.NONE);
        renderedLockedAnchor = new Animated<RenderedPoint>(Animated.RENDERED_POINT_TYPE_INFO, () -> RenderStates.renderStartNanoTime, TimingFunction.circle::mapProgress, RenderedPoint.EMPTY);
        renderedWidthLineSegment = new Animated<Double>(Animated.DOUBLE_DEFAULT_ZERO_TYPE_INFO, () -> RenderStates.renderStartNanoTime, TimingFunction.sine::mapProgress, 0.0);
        renderedHeightLineSegment = new Animated<Double>(Animated.DOUBLE_DEFAULT_ZERO_TYPE_INFO, () -> RenderStates.renderStartNanoTime, TimingFunction.sine::mapProgress, 0.0);
        renderedWidthLock = new Animated<Double>(Animated.DOUBLE_DEFAULT_ZERO_TYPE_INFO, () -> RenderStates.renderStartNanoTime, TimingFunction.sine::mapProgress, 0.0);
        renderedHeightLock = new Animated<Double>(Animated.DOUBLE_DEFAULT_ZERO_TYPE_INFO, () -> RenderStates.renderStartNanoTime, TimingFunction.sine::mapProgress, 0.0);
        isUndoing = false;
    }

    private record SelectionStatus(PortalLocalXYNormalized selectedAnchor, boolean selectsHorizontalEdge, boolean selectsVerticalEdge) {
    }

    private record DraggingContext(ResourceKey<Level> dimension, @NotNull UUID portalId, @Nullable Plane limitingPlane, @Nullable Sphere limitingSphere, PortalWandInteraction.DraggingInfo draggingInfo, @Nullable MutableComponent planeText, PortalState originalPortalState) {
    }
}

